/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.security.service;

import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import org.bouncycastle.operator.OperatorCreationException;

public interface CertificateBuilder {
    public CertificateBuilder distinguishedName(String var1);

    public CertificateBuilder commonName(String var1);

    public CertificateBuilder issuerName(String var1);

    public CertificateBuilder validityDays(int var1);

    public CertificateBuilder ca();

    public CertificateBuilder issuer(Certificate var1, PrivateKey var2);

    public CertificateBuilder subjectAlternativeName(SubjectAlternativeNameType var1, String var2);

    public CertificateBuilder tlsClientAuth();

    public CertificateBuilder tlsServerAuth();

    public RSACertificateBuilder rsa();

    public ECCertificateBuilder ec();

    public KeyStore.PrivateKeyEntry build() throws NoSuchAlgorithmException, InvalidAlgorithmParameterException, OperatorCreationException, IOException, CertificateException;

    public static interface ECCertificateBuilder {
        public ECCertificateBuilder namedCurve(NamedCurve var1);

        public CertificateBuilder build();

        public static enum NamedCurve {
            secp224r1("secp224r1", 224),
            secp256r1("secp256r1", 256),
            brainpoolP320r1("brainpoolP320r1", 320),
            secp384r1("secp384r1", 384),
            brainpoolP512r1("brainpoolP512r1", 512),
            secp521r1("secp521r1", 521);

            private final String namedCurve;
            private final int keyLength;

            private NamedCurve(String namedCurve, int keyLength) {
                this.namedCurve = namedCurve;
                this.keyLength = keyLength;
            }

            public String getNamedCurve() {
                return this.namedCurve;
            }

            public int getKeyLength() {
                return this.keyLength;
            }
        }
    }

    public static interface RSACertificateBuilder {
        public RSACertificateBuilder signingUsage();

        public RSACertificateBuilder keyLength(int var1);

        public CertificateBuilder build();
    }

    public static enum SubjectAlternativeNameType {
        OTHER_NAME,
        RFC822_NAME,
        DNS_NAME,
        X400_ADDRESS,
        DIRECTORY_NAME,
        EDI_PARTY_NAME,
        UNIFORM_RESOURCE_IDENTIFIER,
        IP_ADDRESS,
        REGISTERED_ID;

    }
}

