/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.security.authorization;

import com.ericsson.lwac.security.authorization.UnsupportedTokenTypeException;
import java.util.stream.Stream;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlType;

@XmlEnum
@XmlType(namespace="http://www.ericsson.com/lwac/security/authorization/common", name="tokentype")
public enum TokenType {
    ID_TOKEN("urn:ietf:params:oauth:token-type:id_token"),
    ACCESS_TOKEN("urn:ietf:params:oauth:token-type:access_token");

    private final String name;

    private TokenType(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public String getValue() {
        return this.name;
    }

    public static TokenType fromString(String text) {
        TokenType tokenType = Stream.of(TokenType.values()).filter(token -> token.getValue().equals(text)).findFirst().orElse(null);
        if (tokenType == null) {
            throw new UnsupportedTokenTypeException("unsupported_token_type");
        }
        return tokenType;
    }
}

