/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.security;

import java.util.HashMap;
import java.util.Map;

public enum HashVersion {
    SHA1(1, 1000){

        public String toString() {
            return "SHA1";
        }
    }
    ,
    SHA512(2, 1024){

        public String toString() {
            return "SHA-512";
        }
    }
    ,
    HMACSHA512(3, 1){

        public String toString() {
            return "HmacSHA512";
        }
    }
    ,
    HMACSHA512DB(4, 1, true){

        public String toString() {
            return "HmacSHA512";
        }
    };

    private final int version;
    private final int hashIterations;
    private final boolean dbKey;
    private static final Map<Integer, HashVersion> versions;

    private HashVersion(int hashVersion, int hashIterations) {
        this.version = hashVersion;
        this.hashIterations = hashIterations;
        this.dbKey = false;
    }

    private HashVersion(int hashVersion, int hashIterations, boolean keyInDB) {
        this.version = hashVersion;
        this.hashIterations = hashIterations;
        this.dbKey = keyInDB;
    }

    public int toInt() {
        return this.version;
    }

    public int getHashIterations() {
        return this.hashIterations;
    }

    public boolean isDbKey() {
        return this.dbKey;
    }

    public static HashVersion fromInt(int hashVersion) {
        HashVersion hashVersionReturn = versions.get(hashVersion);
        if (hashVersionReturn != null) {
            return hashVersionReturn;
        }
        return versions.get(HMACSHA512DB.toInt());
    }

    static {
        versions = new HashMap<Integer, HashVersion>();
        for (HashVersion hashVersion : HashVersion.values()) {
            versions.put(hashVersion.toInt(), hashVersion);
        }
    }
}

