/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.net.ws.client;

import com.ericsson.lwac.net.http.core.HttpHeaders;
import com.ericsson.lwac.net.http.core.HttpMethod;
import com.ericsson.lwac.net.http.core.HttpQueryParameters;
import com.ericsson.lwac.net.ws.core.WebSocketPingPongPolicy;
import com.ericsson.lwac.net.ws.core.WebSocketSubProtocol;
import com.google.common.base.Preconditions;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;

public final class WebSocketClientConfiguration {
    public static final Duration DEFAULT_UPGRADE_TIMEOUT = Duration.ofSeconds(5L);
    private final String name;
    private final String url;
    private final HttpMethod method;
    private final HttpHeaders httpHeaders;
    private final HttpQueryParameters httpQueryParameters;
    private final Duration upgradeTimeout;
    private final Boolean openChannelsOnClientCreation;
    private final WebSocketSubProtocol subProtocol;
    private final WebSocketPingPongPolicy pingPongPolicy;

    private WebSocketClientConfiguration(Builder builder) {
        this.name = builder.name;
        this.url = builder.url;
        this.method = builder.method;
        this.httpHeaders = builder.httpHeaders;
        this.httpQueryParameters = builder.httpQueryParameters;
        this.upgradeTimeout = builder.upgradeTimeout;
        this.openChannelsOnClientCreation = builder.openChannelsOnClientCreation;
        this.subProtocol = builder.subProtocol;
        this.pingPongPolicy = builder.pingPongPolicy;
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public HttpHeaders getHttpHeaders() {
        return this.httpHeaders;
    }

    public HttpQueryParameters getHttpQueryParameters() {
        return this.httpQueryParameters;
    }

    public Duration getUpgradeTimeout() {
        return this.upgradeTimeout;
    }

    public Optional<Boolean> isOpenChannelsOnClientCreation() {
        return Optional.ofNullable(this.openChannelsOnClientCreation);
    }

    public WebSocketSubProtocol getSubProtocol() {
        return this.subProtocol;
    }

    public Optional<WebSocketPingPongPolicy> getPingPongPolicy() {
        return Optional.ofNullable(this.pingPongPolicy);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebSocketClientConfiguration that = (WebSocketClientConfiguration)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.url, that.url) && this.method == that.method && Objects.equals(this.httpHeaders, that.httpHeaders) && Objects.equals(this.httpQueryParameters, that.httpQueryParameters) && Objects.equals(this.upgradeTimeout, that.upgradeTimeout) && Objects.equals(this.openChannelsOnClientCreation, that.openChannelsOnClientCreation) && Objects.equals(this.subProtocol, that.subProtocol) && Objects.equals(this.pingPongPolicy, that.pingPongPolicy);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.url, this.method, this.httpHeaders, this.httpQueryParameters, this.upgradeTimeout, this.openChannelsOnClientCreation, this.pingPongPolicy});
    }

    public static class Builder {
        private String name;
        private String url;
        private HttpMethod method = HttpMethod.GET;
        private HttpHeaders httpHeaders = HttpHeaders.EMPTY;
        private HttpQueryParameters httpQueryParameters = HttpQueryParameters.EMPTY;
        private Duration upgradeTimeout = DEFAULT_UPGRADE_TIMEOUT;
        private Boolean openChannelsOnClientCreation;
        private WebSocketSubProtocol subProtocol = WebSocketSubProtocol.NONE;
        private WebSocketPingPongPolicy pingPongPolicy = WebSocketPingPongPolicy.DEFAULT_SEND_PINGS;

        public Builder name(String name) {
            Preconditions.checkNotNull(name, "'name' is invalid, can not be null");
            this.name = name;
            return this;
        }

        public Builder url(String url) {
            Preconditions.checkNotNull(url, "'url' is invalid, can not be null");
            Preconditions.checkArgument(url.startsWith("ws://") || url.startsWith("wss://"), "'url' is invalid, must use ws:// or wss:// schema");
            this.url = url;
            return this;
        }

        public Builder method(HttpMethod method) {
            Preconditions.checkArgument(method == HttpMethod.GET || method == HttpMethod.CONNECT, "'method' is invalid, only GET and CONNECT is allowed");
            this.method = method;
            return this;
        }

        public Builder httpHeaders(HttpHeaders httpHeaders) {
            if (httpHeaders == null) {
                httpHeaders = HttpHeaders.EMPTY;
            }
            this.httpHeaders = httpHeaders;
            return this;
        }

        public Builder httpQueryParameters(HttpQueryParameters httpQueryParameters) {
            if (httpQueryParameters == null) {
                httpQueryParameters = HttpQueryParameters.EMPTY;
            }
            this.httpQueryParameters = httpQueryParameters;
            return this;
        }

        public Builder upgradeTimeout(Duration upgradeTimeout) {
            if (upgradeTimeout == null) {
                upgradeTimeout = DEFAULT_UPGRADE_TIMEOUT;
            }
            if (upgradeTimeout.isNegative() || upgradeTimeout.isZero()) {
                upgradeTimeout = DEFAULT_UPGRADE_TIMEOUT;
            }
            this.upgradeTimeout = upgradeTimeout;
            return this;
        }

        public Builder openChannelsOnClientCreation(boolean openChannelsOnClientCreation) {
            this.openChannelsOnClientCreation = openChannelsOnClientCreation;
            return this;
        }

        public Builder subProtocol(WebSocketSubProtocol subProtocol) {
            if (subProtocol == null) {
                subProtocol = WebSocketSubProtocol.NONE;
            }
            this.subProtocol = subProtocol;
            return this;
        }

        public Builder pingPongPolicy(WebSocketPingPongPolicy pingPongPolicy) {
            this.pingPongPolicy = pingPongPolicy;
            return this;
        }

        public WebSocketClientConfiguration build() {
            Preconditions.checkNotNull(this.url, "'url' is invalid, can not be null");
            Preconditions.checkNotNull(this.name, "'name' is invalid, can not be null");
            return new WebSocketClientConfiguration(this);
        }
    }
}

