/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.net.http.core;

import com.ericsson.lwac.net.http.core.HttpQueryParameters;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import jakarta.validation.constraints.NotNull;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class HttpQueryParameter
implements Iterable<HttpQueryParameter> {
    @NotNull
    private final String name;
    @NotNull
    private final String value;

    private HttpQueryParameter(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public static HttpQueryParameter fromNameAndValue(String name, String value) {
        if (value == null) {
            return null;
        }
        Preconditions.checkNotNull(name, "'name' is invalid, can not be null");
        return new HttpQueryParameter(name, value);
    }

    public static HttpQueryParameter fromNameAndValue(String name, Optional<String> value) {
        Preconditions.checkNotNull(value, "'value' is invalid, can not be null");
        return HttpQueryParameter.fromNameAndValue(name, value.orElse(null));
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpQueryParameter that = (HttpQueryParameter)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.value);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public Iterator<HttpQueryParameter> iterator() {
        return Collections.singletonList(this).iterator();
    }

    public static Optional<HttpQueryParameter> findByName(Iterable<HttpQueryParameter> parameters, String name) {
        Preconditions.checkNotNull(name, "'name' is invalid, can not be null");
        if (parameters == null) {
            return Optional.empty();
        }
        return StreamSupport.stream(parameters.spliterator(), false).filter(parameter -> Objects.equals(parameter.name, name)).findFirst();
    }

    public static Optional<String> findValueByName(Iterable<HttpQueryParameter> parameters, String name) {
        return HttpQueryParameter.findByName(parameters, name).map(HttpQueryParameter::getValue);
    }

    public static List<HttpQueryParameter> findAllByName(Iterable<HttpQueryParameter> parameters, String name) {
        Preconditions.checkNotNull(name, "'name' is invalid, can not be null");
        if (parameters == null) {
            return ImmutableList.of();
        }
        return StreamSupport.stream(parameters.spliterator(), false).filter(parameter -> Objects.equals(parameter.name, name)).collect(Collectors.toList());
    }

    public static List<String> findAllValuesByName(Iterable<HttpQueryParameter> parameters, String name) {
        return HttpQueryParameter.findAllByName(parameters, name).stream().map(HttpQueryParameter::getValue).collect(Collectors.toList());
    }

    public HttpQueryParameters plus(HttpQueryParameter parameter) {
        return HttpQueryParameters.newBuilder().parameter(this).parameter(parameter).build();
    }

    public HttpQueryParameters plus(HttpQueryParameters parameters) {
        return HttpQueryParameters.newBuilder().parameter(this).parameters(parameters).build();
    }

    public static final class Builder {
        private String name;
        private String value;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder value(String value) {
            this.value = value;
            return this;
        }

        public Builder value(Optional<String> value) {
            Preconditions.checkNotNull(value, "'value' is invalid, can not be null");
            return this.value((String)value.orElse(null));
        }

        public HttpQueryParameter build() {
            Preconditions.checkNotNull(this.name, "'name' is invalid, can not be null");
            if (this.value == null) {
                return null;
            }
            return new HttpQueryParameter(this.name, this.value);
        }
    }
}

