/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.net.http.core;

import com.ericsson.lwac.net.http.core.HttpHeader;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import jakarta.validation.Valid;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class HttpHeaders
implements Iterable<HttpHeader> {
    public static final HttpHeaders EMPTY = new HttpHeaders(ImmutableList.of());
    @Valid
    private final List<HttpHeader> headers;

    protected HttpHeaders(List<HttpHeader> headers) {
        this.headers = headers;
    }

    public Collection<HttpHeader> getHeaders() {
        return Collections.unmodifiableCollection(this.headers);
    }

    public int hashCode() {
        return Objects.hash(this.headers);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        HttpHeaders that = (HttpHeaders)obj;
        return Objects.equals(this.headers, that.headers);
    }

    @Override
    public Iterator<HttpHeader> iterator() {
        return this.getHeaders().iterator();
    }

    public Optional<String> findFirst(String name) {
        Preconditions.checkNotNull(name, "'name' is invalid, cannot be null");
        return StreamSupport.stream(this.spliterator(), false).filter(value -> name.equalsIgnoreCase(value.getName())).map(HttpHeader::getValue).findFirst();
    }

    public HttpHeaders without(String name) {
        Preconditions.checkNotNull(name, "'name' is invalid, cannot be null");
        return HttpHeaders.newBuilder().headers(this.headers.stream().filter(input -> input != null && !name.equalsIgnoreCase(input.getName())).collect(Collectors.toList())).build();
    }

    public HttpHeaders withOnly(List<String> names) {
        Preconditions.checkNotNull(names, "'names' is invalid, cannot be null");
        List lowerCasedNames = names.stream().map(String::toLowerCase).collect(Collectors.toList());
        return HttpHeaders.newBuilder().headers(this.headers.stream().filter(httpHeader -> lowerCasedNames.contains(httpHeader.getName().toLowerCase())).collect(Collectors.toList())).build();
    }

    public HttpHeaders withOnly(String ... names) {
        Preconditions.checkNotNull(names, "'names' is invalid, cannot be null");
        return this.withOnly(Arrays.asList(names));
    }

    public static HttpHeaders of(HttpHeader httpHeader) {
        if (httpHeader == null) {
            return null;
        }
        return new HttpHeaders(ImmutableList.of(httpHeader));
    }

    public HttpHeaders plus(HttpHeaders httpHeaders) {
        if (httpHeaders == null) {
            return this;
        }
        if (this.isEmpty()) {
            return httpHeaders;
        }
        return HttpHeaders.newBuilder().headers(this).headers(httpHeaders).build();
    }

    public HttpHeaders plus(HttpHeader httpHeader) {
        return this.plus(HttpHeaders.of(httpHeader));
    }

    public boolean isEmpty() {
        return this.headers.isEmpty();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private ImmutableList.Builder<HttpHeader> headers;

        public Builder header(HttpHeader header) {
            Preconditions.checkNotNull(header, "'header' is invalid, can not be null");
            if (this.headers == null) {
                this.headers = ImmutableList.builder();
            }
            this.headers.add((Object)header);
            return this;
        }

        public Builder header(String name, String value) {
            Preconditions.checkNotNull(name, "'name' is invalid, can not be null");
            if (value != null) {
                return this.header(HttpHeader.fromNameAndValue(name, value));
            }
            return this;
        }

        public Builder headers(Iterable<HttpHeader> httpHeaders) {
            for (HttpHeader httpHeader : httpHeaders) {
                this.header(httpHeader);
            }
            return this;
        }

        public HttpHeaders build() {
            if (this.headers == null) {
                return EMPTY;
            }
            return new HttpHeaders((List<HttpHeader>)((Object)this.headers.build()));
        }
    }
}

