/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.http.xml;

import com.ericsson.lwac.deployer.service.Service;
import com.ericsson.lwac.http.VersionResolver;
import com.ericsson.lwac.http.types.Version;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.jvnet.mimepull.MIMEMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service(serviceInterface=VersionResolver.class)
public class XmlVersionResolver
implements VersionResolver {
    private static XMLInputFactory inputFactory = XMLInputFactory.newInstance();
    private static final Logger logger = LoggerFactory.getLogger(XmlVersionResolver.class);

    @Override
    public Version resolve(HttpServletRequest request) {
        Version version = null;
        try {
            InputStream inputStream = null;
            if (!request.getContentType().contains("multipart/")) {
                inputStream = request.getInputStream();
            } else {
                String contentType = request.getContentType();
                MIMEMessage message = new MIMEMessage((InputStream)request.getInputStream(), contentType.substring(contentType.lastIndexOf(61) + 1, contentType.length()));
                inputStream = message.getPart(0).read();
            }
            XMLEventReader eventReader = inputFactory.createXMLEventReader(inputStream);
            while (eventReader.hasNext()) {
                XMLEvent event = eventReader.nextEvent();
                if (!event.isStartElement()) continue;
                StartElement startElement = event.asStartElement();
                Attribute versionAttribute = startElement.getAttributeByName(new QName("version"));
                version = versionAttribute != null ? new Version(versionAttribute.getValue()) : null;
                break;
            }
        }
        catch (IOException | XMLStreamException e) {
            logger.error("Could not extract version from xml request", e);
        }
        return version;
    }
}

