/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.feature;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PermissionBuilder {
    private static final Logger logger = LoggerFactory.getLogger(PermissionBuilder.class);
    private final Map<String, String[]> map;

    private PermissionBuilder(Map<String, String[]> map) {
        this.map = map;
    }

    public PermissionBuilder grouped(String group, String ... permissions) {
        return this.enrich(group, permissions);
    }

    public PermissionBuilder general(String ... permissions) {
        return this.enrich(null, permissions);
    }

    private PermissionBuilder enrich(String group, String ... permissions) {
        HashMap<String, String[]> enriched = new HashMap<String, String[]>(this.map);
        if (enriched.containsKey(group)) {
            logger.error(String.format("Erroneously redefining group '%s'", group), new Exception());
        }
        enriched.put(group, permissions);
        return new PermissionBuilder(enriched);
    }

    public Map<String, String[]> toMap() {
        return Collections.unmodifiableMap(this.map);
    }

    public static PermissionBuilder builder() {
        return new PermissionBuilder(new HashMap<String, String[]>());
    }
}

