/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.domain;

import java.io.Serializable;

public final class QualifiedName
implements Serializable,
Comparable<QualifiedName> {
    private static final long serialVersionUID = 1L;
    private final String group;
    private final String name;

    private QualifiedName(String group, String name) {
        this.group = group;
        this.name = name;
    }

    public String getQualifiedName() {
        return String.format("%s.%s", this.group, this.name);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.getQualifiedName().hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        QualifiedName other = (QualifiedName)obj;
        return this.getQualifiedName().equals(other.getQualifiedName());
    }

    public String toString() {
        return this.getQualifiedName();
    }

    public String getName() {
        return this.name;
    }

    public String getGroup() {
        return this.group;
    }

    @Override
    public int compareTo(QualifiedName o) {
        return this.getQualifiedName().compareTo(o.getQualifiedName());
    }

    public static QualifiedName create(String qualifiedName) {
        int index = qualifiedName.lastIndexOf(46);
        if (index == -1) {
            throw new IllegalArgumentException(String.format("%s can not be parsed to qualified name", qualifiedName));
        }
        return new QualifiedName(qualifiedName.substring(0, index), qualifiedName.substring(index + 1));
    }

    public static QualifiedName create(String group, String name) {
        return new QualifiedName(group, name);
    }
}

