/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.variable;

import com.ericsson.ere.datatype.ValueResolver;
import com.ericsson.ere.gui.util.ExceptionUtil;
import com.ericsson.ere.util.Location;
import com.ericsson.ere.variable.FixedTextCellRenderer;
import com.ericsson.ere.variable.VariableProducer;
import ericsson.ere.datatype.ContextBasedValueResolver;
import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.defs.FieldStructure;
import ericsson.ere.gui.interfaces.SimulationEditor;
import ericsson.ere.gui.util.EnumEditor;
import ericsson.ere.gui.util.NumberRangeEditor;
import ericsson.ere.gui.util.VariableFactory;
import ericsson.ere.interfaces.FieldHierarchyNode;
import ericsson.ere.interfaces.XMLInitializable;
import ericsson.ere.util.StringUtil;
import ericsson.vareditor.variable.ArrayModel;
import ericsson.vareditor.variable.BitPatternInputVariable;
import ericsson.vareditor.variable.GroupedArrayVariable;
import ericsson.vareditor.variable.PlainCollectionVariable;
import ericsson.vareditor.variable.Variable;
import ericsson.vareditor.variable.array.GroupedObjectArrayVariable;
import ericsson.vareditor.variable.array.ObjectArrayDataDescription;
import ericsson.vareditor.variable.array.ObjectArrayDescription;
import ericsson.vareditor.variable.array.ObjectArrayModel;
import ericsson.vareditor.variable.array.ObjectMapModel;
import ericsson.vareditor.variable.array.ObjectSetModel;
import java.lang.reflect.Array;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.table.TableCellRenderer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DefaultVariableProducer
implements VariableProducer {
    private static final String[] COLUMN_NAMES = new String[]{"Key", "Value"};
    protected final ClassRepository myRepository;
    private Location myLocation = Location.SIMULATION_PANEL;

    public DefaultVariableProducer(ClassRepository repository, Location location) {
        this.myRepository = repository;
        this.myLocation = location;
    }

    public DefaultVariableProducer(ClassRepository repository) {
        this.myRepository = repository;
    }

    @Override
    public Variable produceVariable(FieldDefinition field) {
        Variable v = null;
        v = field.isArray() || field.isSet() ? this.createArrayVariable(field) : (field.isMap() ? this.createMapVariable(field) : this.createPlainVariable(field));
        if (v != null) {
            v.setSelected(field.isMandatory());
        }
        return v;
    }

    private Variable produceVariable(FieldDefinition field, boolean grouped) {
        Variable v = null;
        v = field.isArray() || field.isSet() ? this.createArrayVariable(field, grouped) : (field.isMap() ? this.createMapVariable(field, grouped) : this.produceVariable(field));
        return v;
    }

    @Override
    public Variable produceVariable(DataType dataType, Object value) {
        Variable var;
        if (dataType == DataType.AMOUNT && this.myRepository != null) {
            String strValue = value == null ? "" : String.valueOf(value);
            var = VariableFactory.createAmountVariable("", null, this.myRepository, strValue, false);
        } else {
            Object objValue = value == null ? dataType.createDefaultInstance() : value;
            var = VariableFactory.getVariableOfDataType(dataType.getTypeName(), "", null, null, null, objValue);
        }
        return var;
    }

    @Override
    public Variable produceVariable(String groupName, List<FieldDefinition> fields) {
        assert (fields != null && fields.size() > 0);
        ObjectArrayModel objectArrayModel = this.createObjectArrayModel(groupName, fields);
        return new GroupedObjectArrayVariable(groupName, objectArrayModel);
    }

    protected ObjectArrayModel createObjectArrayModel(String label, List<FieldDefinition> fields) {
        ObjectArrayModel model;
        ObjectArrayDescription description = this.createObjectArrayDescription(label, fields);
        for (FieldDefinition field : fields) {
            ObjectArrayDataDescription dataDesc;
            DataType dataType = field.getTypedDataType();
            assert (dataType != null) : "Unknown data type for field " + field.getFieldName();
            SimulationEditor editor = this.getFieldEditor(field);
            Object defaultValue = this.getDefaultValueForField(field);
            if (this.isChildOfHierarchicalCollection(field) && field.isComplexType()) {
                dataDesc = this.createCollectionArrayModelColumn(field, defaultValue);
            } else if (editor instanceof NumberRangeEditor) {
                NumberRangeEditor numberRangeEditor = (NumberRangeEditor)editor;
                dataDesc = this.createRangeArrayModelColumn(field, defaultValue, numberRangeEditor.getLongMinValue(), numberRangeEditor.getLongMaxValue());
            } else if (editor instanceof EnumEditor) {
                EnumEditor enumEditor = (EnumEditor)editor;
                String defaultValueStr = field.hasDefaultValue() ? field.getDefaultValue() : "";
                int selected = Arrays.asList(enumEditor.getValues()).indexOf(defaultValueStr);
                dataDesc = this.createEnumArrayModelColumn(field, enumEditor.getEditStrings(), selected < 0 ? 0 : selected);
            } else {
                dataDesc = this.createPlainArrayModelColumn(field, defaultValue);
            }
            description.add(dataDesc);
        }
        ObjectArrayModel.DefaultValueResolver dvr = this.createDefaultValueResolver(label, fields);
        List<Object[]> data = Collections.emptyList();
        String[] keyFields = this.getKeyFieldNames(fields);
        if (this.isParentSet(fields.get(0))) {
            model = new ObjectSetModel(label, label.replace(" ", ""), data, description, dvr);
        } else if (keyFields.length > 0) {
            model = new ObjectMapModel(label, label.replace(" ", ""), data, description, dvr);
            int[] keyColumns = this.extractkeyColumnArray(model, keyFields);
            ((ObjectMapModel)model).setKeyColumns(keyColumns);
        } else {
            model = new ObjectArrayModel(label, label.replace(" ", ""), data, description, dvr);
        }
        return model;
    }

    private boolean isChildOfHierarchicalCollection(FieldDefinition field) {
        boolean result = false;
        for (FieldStructure parent = field.getParent(); parent != null; parent = parent.getParent()) {
            if (parent.getComplexType() == FieldHierarchyNode.ComplexType.NONE) continue;
            result = true;
            break;
        }
        return result;
    }

    private boolean isParentSet(FieldHierarchyNode field) {
        return field.getParent() != null && field.getParent().getComplexType() == FieldHierarchyNode.ComplexType.SET;
    }

    private String[] getKeyFieldNames(List<FieldDefinition> fields) {
        ArrayList<String> keyFields = new ArrayList<String>();
        for (FieldDefinition field : fields) {
            if (field.getParent() == null || !field.isKey()) continue;
            keyFields.add(field.getFieldName());
        }
        String[] keyFieldArray = keyFields.toArray(new String[0]);
        if (keyFields.size() == 0) {
            for (FieldDefinition field : fields) {
                if (field.getKeyFields() == null) continue;
                keyFieldArray = field.getKeyFields();
                break;
            }
        }
        return keyFieldArray;
    }

    private int[] extractkeyColumnArray(ObjectArrayModel model, String[] keyFieldNames) {
        int[] keyColumnArray;
        if (keyFieldNames.length > 1) {
            keyColumnArray = new int[keyFieldNames.length];
            for (int i = 0; i < keyFieldNames.length; ++i) {
                keyColumnArray[i] = model.getColumnIndexByName(keyFieldNames[i]);
            }
        } else {
            keyColumnArray = new int[]{model.getColumnIndexByName(keyFieldNames[0])};
        }
        return keyColumnArray;
    }

    protected Object getDefaultValueForField(FieldDefinition field) {
        return this.createValueResolverForField(field).createDefaultInstance();
    }

    protected ObjectArrayModel.DefaultValueResolver createDefaultValueResolver(String label, List<FieldDefinition> fields) {
        return null;
    }

    protected ObjectArrayDescription createObjectArrayDescription(String label, List<FieldDefinition> fields) {
        return new ObjectArrayDescription();
    }

    protected ObjectArrayDataDescription createPlainArrayModelColumn(FieldDefinition field, Object defaultValue) {
        DataType dt = this.getFieldDataType(field);
        assert (dt != null) : "Unknown data type for field " + field.getFieldName();
        return new CustomObjectArrayDataDescription(field, dt, null);
    }

    protected CustomCollectionObjectArrayDataDescription createCollectionArrayModelColumn(FieldDefinition field, Object defaultValue) {
        return new CustomCollectionObjectArrayDataDescription(field, field.getTypedDataType(), defaultValue);
    }

    protected ObjectArrayDataDescription createEnumArrayModelColumn(FieldDefinition field, Object[] choices, int index) {
        return new CustomObjectArrayDataDescription(field, index, choices);
    }

    protected ObjectArrayDataDescription createRangeArrayModelColumn(FieldDefinition field, Object defaultValue, long min, long max) {
        DataType dt = this.getFieldDataType(field);
        assert (dt != null) : "Unknown data type for field " + field.getFieldName();
        return new CustomObjectArrayDataDescription(field, dt, defaultValue, min, max);
    }

    protected Variable createMapVariable(FieldDefinition field) {
        return this.createMapVariable(field, true);
    }

    private Variable createMapVariable(FieldDefinition field, boolean grouped) {
        String name = field.getFieldName();
        Object[] dataTypedValueArray = new Object[]{new String[0], this.createTypedArray(field, 0)};
        ValueResolver resolver = this.createValueResolverForField(field);
        PlainCollectionVariable var = grouped ? new GroupedArrayVariable(name, dataTypedValueArray, COLUMN_NAMES, resolver) : new PlainCollectionVariable(name, new ArrayModel(dataTypedValueArray, COLUMN_NAMES), resolver, field.getComplexType());
        var.setVariableProducer(new FixedFieldBasedVariableProducer(field));
        return var;
    }

    private Object[] createTypedArray(FieldDefinition field, int size) {
        Object[] array;
        if (field.hasValueClass()) {
            array = (Object[])Array.newInstance(field.getValueClassProper(), size);
        } else {
            DataType dt = this.getFieldDataType(field);
            array = dt.createArray(size);
        }
        return array;
    }

    protected Variable createArrayVariable(FieldDefinition field) {
        return this.createArrayVariable(field, true);
    }

    private Variable createArrayVariable(FieldDefinition field, boolean grouped) {
        Vector<Object> values = new Vector<Object>();
        String defaultValues = field.getDefaultValue();
        ValueResolver resolver = this.createValueResolverForField(field);
        if (defaultValues != null) {
            try {
                values.addAll(Arrays.asList(DataType.parseMultiString(defaultValues, resolver)));
            }
            catch (ParseException ex) {
                this.handleException(ex, String.format("Failed to parse the default value of field %s. Cannot populate the array variable.", field.getFieldName()));
            }
        }
        Object[] valueArray = values.toArray(this.createTypedArray(field, values.size()));
        if (field.isArray()) {
            valueArray = this.createTwoDimensionalArrayForValues(valueArray);
        }
        PlainCollectionVariable var = grouped ? new GroupedArrayVariable(field.getFieldName(), valueArray, resolver, true) : new PlainCollectionVariable(field.getFieldName(), valueArray, resolver, field.getComplexType());
        var.setVariableProducer(new FixedFieldBasedVariableProducer(field));
        if (field.isSet()) {
            var.actAsSetEditor(true);
        }
        return var;
    }

    private ValueResolver createValueResolverForField(FieldDefinition field) {
        FieldDefinition useField = this.createProxyField(field);
        ContextBasedValueResolver cb = DataType.createTypeIndependentContextBasedValueResolver().withFieldDefinition(useField);
        if (this.myRepository != null) {
            cb = cb.withClassRepository(this.myRepository);
        }
        return cb.disableLazyEvaluatedValuePreference().finish();
    }

    private void handleException(Exception e, String msg) {
        ExceptionUtil.handleException(e, "simulation", 1, msg, false);
    }

    protected Variable createPlainVariable(FieldDefinition field) {
        try {
            FieldDefinition useField = this.createProxyField(field);
            Variable var = VariableFactory.createInputVariable(field.getFieldName(), null, useField, this.myRepository, null, this.myLocation);
            if (var instanceof BitPatternInputVariable) {
                ((BitPatternInputVariable)var).setIsFoldable(true);
            }
            return var;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private FieldDefinition createProxyField(FieldDefinition field) {
        FieldDefinition useField = field;
        DataType dt = this.getFieldDataType(field);
        if (dt != field.getTypedDataType()) {
            useField = DefaultVariableProducer.createDataTypeAdjustedField(field, dt);
        }
        return useField;
    }

    private static FieldDefinition createDataTypeAdjustedField(final FieldDefinition field, DataType dataType) {
        final Element configClone = (Element)field.getDefinitionNode().cloneNode(true);
        configClone.setAttribute("DataType", dataType.getTypeName());
        if (field.hasDefaultValue()) {
            Object dummy;
            String def = field.getDefaultValue();
            Object object = dummy = field.isArray() ? dataType.parseMultiValue(def) : dataType.parseValue(def);
            if (dummy == null) {
                configClone.removeAttribute("Default");
            }
        }
        return FieldDefinition.createField(new FieldDefinition.FieldConfiguration(){

            @Override
            public List<String> getContexts() {
                return field.getContextNames();
            }

            @Override
            public Node getFieldNode() {
                return configClone;
            }

            @Override
            public String getKeyField() {
                return StringUtil.join(field.getKeyFields(), ";");
            }
        });
    }

    protected DataType getFieldDataType(FieldDefinition field) {
        return field.getTypedDataType();
    }

    private SimulationEditor getFieldEditor(FieldDefinition field) {
        XMLInitializable editor = null;
        if (DataType.OBJECT != field.getTypedDataType()) {
            try {
                editor = field.createUtil("InputRestriction");
                if (editor == null) {
                    editor = field.createUtil("EditComponent");
                }
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return (SimulationEditor)((Object)editor);
    }

    private Object[] createTwoDimensionalArrayForValues(Object[] array) {
        Integer[] indexArray = new Integer[array.length];
        for (int i = 0; i < indexArray.length; ++i) {
            indexArray[i] = i;
        }
        Object[] twoDimArray = new Object[]{indexArray, array};
        return twoDimArray;
    }

    private class CustomCollectionObjectArrayDataDescription
    extends CustomObjectArrayDataDescription {
        private CustomCollectionObjectArrayDataDescription(FieldDefinition field, DataType dataType, Object defaultValue) {
            super(field, dataType, defaultValue);
        }

        @Override
        protected Variable getVariable(String label, DataType dataType, Object value) {
            Variable variable = DefaultVariableProducer.this.produceVariable(this.myFieldDefinition, false);
            variable.setValue(value);
            return variable;
        }

        @Override
        public Object[] createDefaultArray(int size) {
            return new Object[size];
        }

        @Override
        public FieldHierarchyNode.ComplexType getCollectionType() {
            return this.myFieldDefinition.getComplexType();
        }

        @Override
        public TableCellRenderer getTableCellRenderer() {
            return new FixedTextCellRenderer("<" + this.myFieldDefinition.getComplexType().name() + ">");
        }
    }

    protected class CustomObjectArrayDataDescription
    extends ObjectArrayDataDescription {
        protected final FieldDefinition myFieldDefinition;

        @Deprecated
        protected CustomObjectArrayDataDescription(String label, String dataType, Object defaultValue, long longMinValue, long longMaxValue) {
            super(label, dataType, defaultValue, longMinValue, longMaxValue);
            this.myFieldDefinition = null;
        }

        protected CustomObjectArrayDataDescription(FieldDefinition field, DataType dataType, Object defaultValue, long longMinValue, long longMaxValue) {
            super(field.getFieldName(), DefaultVariableProducer.this.createValueResolverForField(field), longMinValue, longMaxValue);
            this.myFieldDefinition = field;
        }

        protected CustomObjectArrayDataDescription(String label, int defaultValue, Object[] choices) {
            super(label, defaultValue, choices);
            this.myFieldDefinition = null;
        }

        protected CustomObjectArrayDataDescription(FieldDefinition field, int defaultValue, Object[] choices) {
            super(field.getFieldName(), defaultValue, choices);
            this.myFieldDefinition = field;
        }

        protected CustomObjectArrayDataDescription(String label, String dataType, Object defaultValue) {
            super(label, dataType, defaultValue);
            this.myFieldDefinition = null;
        }

        protected CustomObjectArrayDataDescription(FieldDefinition field, DataType dataType, Object defaultValue) {
            super(field.getFieldName(), DefaultVariableProducer.this.createValueResolverForField(field));
            this.myFieldDefinition = field;
        }

        @Override
        protected Variable getVariable(String label, DataType dataType, Object value) {
            Variable var;
            if (this.myFieldDefinition != null) {
                var = DefaultVariableProducer.this.createPlainVariable(this.myFieldDefinition);
                var.setValue(value);
            } else {
                var = DefaultVariableProducer.this.produceVariable(dataType, value);
                var.setLabel(label);
            }
            return var;
        }
    }

    private class FixedFieldBasedVariableProducer
    implements VariableProducer {
        private FieldDefinition myField;

        FixedFieldBasedVariableProducer(FieldDefinition field) {
            this.myField = field;
        }

        @Override
        public Variable produceVariable(FieldDefinition field) {
            return DefaultVariableProducer.this.produceVariable(field);
        }

        @Override
        public Variable produceVariable(DataType dataType, Object value) {
            DataType fieldType = DefaultVariableProducer.this.getFieldDataType(this.myField);
            if (fieldType != dataType) {
                throw new IllegalArgumentException("Data type mismatch, got " + dataType + " but expected " + fieldType);
            }
            Variable v = DefaultVariableProducer.this.createPlainVariable(this.myField);
            if (value != null) {
                v.setValue(value);
            }
            return v;
        }

        @Override
        public Variable produceVariable(String groupName, List<FieldDefinition> fields) {
            return DefaultVariableProducer.this.produceVariable(groupName, fields);
        }
    }
}

