/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.util;

import com.ericsson.ere.util.BooleanPredicate;
import com.ericsson.ere.util.Predicate;
import java.util.Arrays;
import java.util.Collections;

public final class Predicates {
    private Predicates() {
    }

    public static <T> Predicate<T> any() {
        return new TruePredicate();
    }

    public static <T> Predicate<T> none() {
        return Predicates.not(new TruePredicate());
    }

    public static <T> Predicate<T> and(Predicate<T> p1, Predicate<T> p2) {
        return new BooleanPredicate(BooleanPredicate.Operation.AND, Arrays.asList(p1, p2));
    }

    public static <T> Predicate<T> or(Predicate<T> p1, Predicate<T> p2) {
        return new BooleanPredicate(BooleanPredicate.Operation.OR, Arrays.asList(p1, p2));
    }

    public static <T> Predicate<T> not(Predicate<T> p1) {
        return new BooleanPredicate<T>(BooleanPredicate.Operation.NOT, Collections.singletonList(p1));
    }

    public static <T> Predicate<T> notNull() {
        return new NotNullPredicate();
    }

    private static class TruePredicate<T>
    implements Predicate<T> {
        private TruePredicate() {
        }

        @Override
        public boolean test(T item) {
            return true;
        }
    }

    private static class NotNullPredicate<T>
    implements Predicate<T> {
        private NotNullPredicate() {
        }

        @Override
        public boolean test(T item) {
            return item != null;
        }
    }
}

