/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.util;

import com.ericsson.ere.util.CountedObjectRepository;
import com.ericsson.ere.util.CountedObjectRepositoryChangeEvent;
import com.ericsson.ere.util.CountedObjectRepositoryListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.event.EventListenerList;

public class CountedObjectRepositoryImpl<T>
implements CountedObjectRepository<T> {
    private final Map<T, List<Object>> myObjects = new HashMap<T, List<Object>>();
    private final EventListenerList myListeners = new EventListenerList();

    @Override
    public void add(T object, Object owner) {
        this.checkOwner(owner);
        List<Object> refs = this.myObjects.get(object);
        if (refs == null) {
            refs = new ArrayList<Object>();
            this.myObjects.put(object, refs);
        } else if (refs.contains(owner)) {
            throw new IllegalArgumentException("Object " + object + " already exists with owner " + owner);
        }
        refs.add(owner);
        this.notifyListeners(object, true);
    }

    private void checkOwner(Object owner) {
        if (owner == null) {
            throw new IllegalArgumentException("Owner must not be null.");
        }
    }

    @Override
    public boolean remove(T object, Object owner) {
        this.checkOwner(owner);
        boolean removed = false;
        List<Object> refs = this.myObjects.get(object);
        if (refs != null && !refs.isEmpty() && (removed = refs.remove(owner))) {
            this.notifyListeners(object, false);
            if (refs.isEmpty()) {
                this.myObjects.remove(object);
            }
        }
        return removed;
    }

    @Override
    public int getReferenceCount(T object) {
        List<Object> refs = this.myObjects.get(object);
        return refs != null ? refs.size() : 0;
    }

    private void notifyListeners(T object, boolean added) {
        CountedObjectRepositoryChangeEvent<T> evt = null;
        CountedObjectRepositoryListener[] listeners = (CountedObjectRepositoryListener[])this.myListeners.getListeners(CountedObjectRepositoryListener.class);
        for (int i = listeners.length - 1; i >= 0; --i) {
            if (evt == null) {
                evt = new CountedObjectRepositoryChangeEvent<T>(this, added ? CountedObjectRepositoryChangeEvent.EventType.ADDED : CountedObjectRepositoryChangeEvent.EventType.REMOVED, object);
            }
            listeners[i].repositoryChanged(evt);
        }
    }

    @Override
    public void addRepositoryListener(CountedObjectRepositoryListener<T> listener) {
        this.myListeners.add(CountedObjectRepositoryListener.class, listener);
    }

    @Override
    public void removeRepositoryListener(CountedObjectRepositoryListener<T> listener) {
        this.myListeners.remove(CountedObjectRepositoryListener.class, listener);
    }
}

