/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.util;

import com.ericsson.ere.util.AggregatedCollection;
import com.ericsson.ere.util.FilteringCollection;
import com.ericsson.ere.util.Predicate;
import com.ericsson.ere.util.Transformer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public final class CollectionUtils {
    private CollectionUtils() {
    }

    public static <T> Collection<T> combineCollections(Collection<T> ... collections) {
        return new AggregatedCollection<T>(collections);
    }

    public static <T, U> Map<U, T> createMap(Collection<T> c, Transformer<T, U> t) {
        Map<U, T> map = null;
        for (T value : c) {
            U key = t.transform(value);
            if (map == null) {
                map = new HashMap();
            }
            map.put(key, value);
        }
        return map != null ? map : Collections.emptyMap();
    }

    public static <T, U> Map<U, List<T>> bucket(Collection<T> c, Transformer<T, U> t) {
        return net.sf.cglib.core.CollectionUtils.bucket(c, CollectionUtils.cglib_trans(t));
    }

    public static <T, U extends T> Collection<U> filterInPlace(Collection<U> c, Predicate<T> p) {
        return net.sf.cglib.core.CollectionUtils.filter(c, CollectionUtils.cglib_pred(p));
    }

    public static <T, U extends T> Collection<U> filter(Collection<U> c, Predicate<T> p) {
        return FilteringCollection.create(c, p);
    }

    public static <T, U extends T> Collection<U> filterDetached(Collection<U> c, Predicate<T> p) {
        Collection<U> coll = CollectionUtils.filter(c, p);
        return CollectionUtils.listFromCollection(coll);
    }

    public static <T, U, V extends T> Collection<U> transform(Collection<V> c, Transformer<T, U> t) {
        return FilteringCollection.transform(c, t);
    }

    public static <T, U, V extends T> Collection<U> transformDetached(Collection<V> c, Transformer<T, U> t) {
        Collection<U> coll = CollectionUtils.transform(c, t);
        return CollectionUtils.listFromCollection(coll);
    }

    private static <T> List<T> listFromCollection(Collection<T> coll) {
        LinkedList<T> list = new LinkedList<T>();
        Iterator<T> it = coll.iterator();
        while (it.hasNext()) {
            list.add(it.next());
        }
        return list;
    }

    private static <T, U> net.sf.cglib.core.Transformer<T, U> cglib_trans(final Transformer<T, U> trans) {
        return new net.sf.cglib.core.Transformer<T, U>(){

            @Override
            public U transform(T value) {
                return trans.transform(value);
            }
        };
    }

    private static <T> net.sf.cglib.core.Predicate<T> cglib_pred(final Predicate<T> pred) {
        return new net.sf.cglib.core.Predicate<T>(){

            @Override
            public boolean evaluate(T arg) {
                return pred.test(arg);
            }
        };
    }
}

