/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.util;

import com.ericsson.ere.util.AbstractStrategyBasedObjectCloner;
import com.ericsson.ere.util.CloneStrategyException;
import com.ericsson.ere.util.ObjectCloner;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public final class CloneViaCloneableStrategy
implements AbstractStrategyBasedObjectCloner.CloneStrategy {
    @Override
    public <T> T attemptClone(ObjectCloner cloner, T object) throws SecurityException, CloneNotSupportedException, InvocationTargetException, CloneStrategyException {
        Object clone = null;
        Class<?> clazz = object.getClass();
        if (object instanceof Cloneable) {
            try {
                Method cloneMethod = clazz.getMethod("clone", new Class[0]);
                clone = cloneMethod.invoke(object, new Object[0]);
            }
            catch (NoSuchMethodException e) {
                throw new CloneStrategyException("No clone() method in class " + clazz + " despite Cloneable interface.", e);
            }
            catch (IllegalArgumentException ex) {
                throw new CloneStrategyException("Failed to invoke clone() on object of class " + clazz, ex);
            }
            catch (IllegalAccessException ex) {
                throw new CloneStrategyException("Failed to invoke clone() on object of class " + clazz, ex);
            }
        }
        return (T)clone;
    }
}

