/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.util;

import java.util.Comparator;

public class ChainedComparator<T extends Comparable<T>>
implements Comparator<T> {
    private Comparator<T>[] myComparators;

    private ChainedComparator(Comparator<T>[] comparators) {
        this.myComparators = comparators;
    }

    public static <T extends Comparable<T>> ChainedComparator<T> chain(Comparator<T> ... comparators) {
        if (comparators.length < 1) {
            throw new IllegalArgumentException("Need at least one comparator.");
        }
        return new ChainedComparator<T>(comparators);
    }

    @Override
    public int compare(T o1, T o2) {
        int result = 0;
        for (int i = 0; result == 0 && i < this.myComparators.length; ++i) {
            result = this.myComparators[i].compare(o1, o2);
        }
        if (result == 0) {
            result = o1.compareTo(o2);
        }
        return result;
    }
}

