/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.trace;

import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.dataset.STQStack;
import com.ericsson.ere.dataset.SelectionTreeQualifier;
import com.ericsson.ere.executor.DefaultTreeExecutor;
import com.ericsson.ere.executor.TreeExecutor;
import com.ericsson.ere.selectiontree.TreeExecutionException;
import com.ericsson.ere.selectiontree.conditions.ConditionTestResult;
import com.ericsson.ere.selectiontree.conditions.DefaultConditionTestResult;
import com.ericsson.ere.selectiontree.interfaces.Conditionality;
import com.ericsson.ere.selectiontree.interfaces.ExecutableNode;
import com.ericsson.ere.selectiontree.interfaces.Performable;
import com.ericsson.ere.selectiontree.interfaces.ResultConditionality;
import com.ericsson.ere.selectiontree.interfaces.TariffStructure;
import com.ericsson.ere.trace.TraceInfoHelper;
import com.ericsson.ere.trace.TraceNodeInterface;
import com.ericsson.ere.trace.TraceNodeInterfaceV2;
import com.ericsson.ere.trace.TracePoint;
import com.ericsson.ere.trace.TraceTreeException;
import com.ericsson.ere.trace.Traceable;
import com.ericsson.ere.trace.TraceableV2;
import ericsson.ere.management.RatingPlan;
import ericsson.ere.management.Service;
import java.util.ArrayList;
import java.util.List;

class TraceHelper {
    static final Object STQ_LIST = new Object();
    private static final Object KNOWN_EXCEPTION = new Object();
    private static final Object EXCEPTION_ORIGIN = new Object();
    public static final Object EXCEPTION_INFO = new Object();
    public static final Object TRACE_EXCEPTION_INFO = new Object();
    private static final Object SERVICE_PRE = new Object();
    private static final Object SERVICE_POST = new Object();
    private static final Object RATING_PLAN_PRE = new Object();
    private static final Object RATING_PLAN_POST = new Object();
    static final Object TRACED_ELEMENT = new Object();
    private static final TreeExecutor myDefaultTreeExecutor = new DefaultTreeExecutor();

    TraceHelper() {
    }

    static TracePoint traceTariffStructure(TariffStructure structure, DataSet dataSet) {
        return TraceHelper.traceTariffStructure(structure, dataSet, myDefaultTreeExecutor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static TracePoint traceTariffStructure(TariffStructure structure, DataSet dataSet, TreeExecutor executor) {
        boolean isTraceableV2;
        Throwable t = null;
        TracePoint tp = new TracePoint(dataSet, dataSet);
        TraceHelper.addServicesToTracePoint(tp);
        TraceHelper.addCurrentRatingPlanToTracePoint(tp);
        TraceableV2 structureV2 = structure instanceof TraceableV2 ? (TraceableV2)((Object)structure) : null;
        boolean bl = isTraceableV2 = structureV2 != null;
        if (isTraceableV2) {
            TraceHelper.setPreTracePointInfoAndPutAnyExceptionsInTracePoint(structureV2, tp);
        }
        try {
            executor.execute(structure, dataSet);
        }
        catch (TraceTreeException ex) {
            t = ex.getCause();
        }
        catch (Exception ex) {
            t = ex;
        }
        finally {
            TraceHelper.addThrowable(tp, t);
            TraceHelper.markTracePointIfThrowableOrigin(tp, t, dataSet);
            TraceHelper.setTracePointInfoAndPutAnyExceptionsInTracePoint(structure, tp);
            if (!isTraceableV2) {
                tp.setTraceString(TraceInfoHelper.getTariffStructureTraceDescription(structure, tp));
            }
        }
        return tp;
    }

    static TracePoint traceStatement(ExecutableNode statement, DataSet dataSet, boolean forceClone) {
        return TraceHelper.traceStatement(statement, dataSet, forceClone, myDefaultTreeExecutor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static TracePoint traceStatement(ExecutableNode statement, DataSet dataSet, boolean forceClone, TreeExecutor executor) {
        TraceableV2 statementV2 = statement instanceof TraceableV2 ? (TraceableV2)((Object)statement) : null;
        boolean isTraceableV2 = statementV2 != null;
        DataSet pre = TraceHelper.maybeCloneDataSet(dataSet, isTraceableV2, forceClone);
        Throwable t = null;
        TracePoint tp = new TracePoint(pre, dataSet);
        TraceHelper.addServicesToTracePoint(tp);
        TraceHelper.addCurrentRatingPlanToTracePoint(tp);
        if (isTraceableV2) {
            TraceHelper.setPreTracePointInfoAndPutAnyExceptionsInTracePoint(statementV2, tp);
        }
        try {
            executor.execute(statement, dataSet);
        }
        catch (TraceTreeException ex) {
            t = ex.getCause();
        }
        catch (Exception ex) {
            t = ex;
        }
        finally {
            TraceHelper.addThrowable(tp, t);
            TraceHelper.markTracePointIfThrowableOrigin(tp, t, dataSet);
            TraceHelper.setTracePointInfoAndPutAnyExceptionsInTracePoint(statement, tp);
            tp.makeTraceDataSetDiff();
            if (!isTraceableV2) {
                tp.setTraceString(TraceInfoHelper.getStatementTraceDescription(statement, tp));
            }
        }
        return tp;
    }

    static TracePoint traceCondition(Conditionality condition, DataSet dataSet) {
        return TraceHelper.traceCondition(condition, dataSet, myDefaultTreeExecutor);
    }

    static TracePoint traceCondition(Conditionality condition, DataSet dataSet, TreeExecutor executor) {
        return TraceHelper.traceConditionWithOptionalResultObject(condition, dataSet, executor, false);
    }

    static TracePoint traceCondition(ResultConditionality condition, DataSet dataSet, TreeExecutor executor) {
        return TraceHelper.traceConditionWithOptionalResultObject(condition, dataSet, executor, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TracePoint traceConditionWithOptionalResultObject(Conditionality condition, DataSet dataSet, TreeExecutor executor, boolean useResultObject) {
        ConditionTestResult result = new DefaultConditionTestResult(false);
        TraceableV2 conditionV2 = condition instanceof TraceableV2 ? (TraceableV2)((Object)condition) : null;
        boolean isTraceableV2 = conditionV2 != null;
        Throwable t = null;
        TracePoint tp = new TracePoint(dataSet, dataSet);
        TraceHelper.addServicesToTracePoint(tp);
        TraceHelper.addCurrentRatingPlanToTracePoint(tp);
        if (isTraceableV2) {
            TraceHelper.setPreTracePointInfoAndPutAnyExceptionsInTracePoint(conditionV2, tp);
        }
        try {
            result = useResultObject ? executor.testCondition((ResultConditionality)condition, dataSet) : new DefaultConditionTestResult(executor.testCondition(condition, dataSet));
        }
        catch (TraceTreeException ex) {
            t = ex.getCause();
        }
        catch (Exception ex) {
            t = ex;
        }
        finally {
            if (useResultObject) {
                TraceHelper.addConditionResult(tp, result);
            } else {
                TraceHelper.addConditionResult(tp, result.getTestResult());
            }
            TraceHelper.addThrowable(tp, t);
            TraceHelper.markTracePointIfThrowableOrigin(tp, t, dataSet);
            TraceHelper.setTracePointInfoAndPutAnyExceptionsInTracePoint(condition, tp);
            if (!isTraceableV2) {
                tp.setTraceString(TraceInfoHelper.getConditionTraceDescription(condition, tp));
            }
        }
        return tp;
    }

    static TracePoint traceModifier(Performable modifier, DataSet dataSet, boolean forceClone) {
        return TraceHelper.traceModifier(modifier, dataSet, forceClone, myDefaultTreeExecutor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static TracePoint traceModifier(Performable modifier, DataSet dataSet, boolean forceClone, TreeExecutor executor) {
        TraceableV2 modifierV2 = modifier instanceof TraceableV2 ? (TraceableV2)((Object)modifier) : null;
        boolean isTraceableV2 = modifierV2 != null;
        DataSet pre = TraceHelper.maybeCloneDataSet(dataSet, isTraceableV2, forceClone);
        TracePoint tp = TraceHelper.createNewTracePoint(pre, dataSet);
        TraceHelper.addServicesToTracePoint(tp);
        TraceHelper.addCurrentRatingPlanToTracePoint(tp);
        Throwable t = null;
        if (isTraceableV2) {
            TraceHelper.setPreTracePointInfoAndPutAnyExceptionsInTracePoint(modifierV2, tp);
        }
        try {
            executor.execute(modifier, dataSet);
        }
        catch (TraceTreeException ex) {
            t = ex.getCause();
        }
        catch (Exception ex) {
            t = ex;
        }
        finally {
            TraceHelper.addThrowable(tp, t);
            TraceHelper.markTracePointIfThrowableOrigin(tp, t, dataSet);
            TraceHelper.setTracePointInfoAndPutAnyExceptionsInTracePoint(modifier, tp);
            tp.makeTraceDataSetDiff();
            if (!isTraceableV2) {
                tp.setTraceString(TraceInfoHelper.getModifierTraceDescription(modifier, tp));
            }
            TraceHelper.addThrowable(tp, t);
        }
        return tp;
    }

    private static void markTracePointIfThrowableOrigin(TracePoint tp, Throwable throwable, DataSet dataSet) {
        if (throwable != null && TraceHelper.isUnknownThrowable(throwable, dataSet)) {
            TraceHelper.markThrowableAsKnown(throwable, dataSet);
            TraceHelper.markTracePointAsThrowableOrigin(tp, throwable);
        }
    }

    private static void setPreTracePointInfoAndPutAnyExceptionsInTracePoint(TraceableV2 traceable, TracePoint tp) {
        try {
            traceable.setPreTracePointInfo(tp);
        }
        catch (Exception e) {
            tp.addInfo(TRACE_EXCEPTION_INFO, e);
        }
    }

    private static void setTracePointInfoAndPutAnyExceptionsInTracePoint(Traceable traceable, TracePoint tp) {
        try {
            traceable.setTracePointInfo(tp);
        }
        catch (Exception e) {
            tp.addInfo(TRACE_EXCEPTION_INFO, e);
        }
    }

    private static void addThrowable(TracePoint tp, Throwable throwable) {
        if (throwable != null) {
            tp.addInfo(EXCEPTION_INFO, throwable);
        }
    }

    static Throwable getThrowable(TracePoint tp) {
        Throwable t = null;
        Object o = tp.getInfo(EXCEPTION_INFO);
        if (o != null) {
            t = (Throwable)o;
        }
        return t;
    }

    static boolean tracePointIsOriginForThrowable(TracePoint tp, Throwable throwable) {
        return tp.getInfo(EXCEPTION_ORIGIN) == throwable;
    }

    private static void markTracePointAsThrowableOrigin(TracePoint tp, Throwable throwable) {
        tp.addInfo(EXCEPTION_ORIGIN, throwable);
    }

    private static boolean isUnknownThrowable(Throwable throwable, DataSet dataSet) {
        return throwable == null || throwable != dataSet.getState(KNOWN_EXCEPTION);
    }

    private static void markThrowableAsKnown(Throwable throwable, DataSet dataSet) {
        if (throwable != null) {
            dataSet.putState(KNOWN_EXCEPTION, throwable);
        }
    }

    static void throwOnError(Throwable t) {
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t != null) {
            throw new TreeExecutionException(t);
        }
    }

    private static void addConditionResult(TracePoint tp, boolean result) {
        tp.addInfo(TraceNodeInterface.TEST_RESULT, result);
    }

    private static void addConditionResult(TracePoint tp, ConditionTestResult result) {
        tp.addInfo(TraceNodeInterface.TEST_RESULT, result.getTestResult());
        tp.addInfo(TraceNodeInterface.CONDITION_TEST_RESULT, result);
    }

    static boolean getConditionResult(TracePoint tp) {
        return (Boolean)tp.getInfo(TraceNodeInterface.TEST_RESULT);
    }

    static ConditionTestResult getConditionResultObject(TracePoint tp) {
        return (ConditionTestResult)tp.getInfo(TraceNodeInterface.CONDITION_TEST_RESULT);
    }

    static TracePoint executeTraceTreeElement(TraceNodeInterfaceV2 traceNode, DataSet dataSet) {
        dataSet.getTraceOrderHandler().add(traceNode);
        TraceNodeInterface parent = dataSet.getTraceOrderHandler().setCurrentExecutingTraceNode(traceNode);
        TracePoint tp = traceNode.traceTreeElement(dataSet);
        traceNode.setExecuted();
        traceNode.addTracePoint(tp);
        dataSet.getTraceOrderHandler().setCurrentExecutingTraceNode(parent);
        Throwable throwable = TraceHelper.getThrowable(tp);
        traceNode.setException(throwable);
        TraceHelper.throwOnError(throwable);
        return tp;
    }

    private static DataSet maybeCloneDataSet(DataSet data, boolean instanceOfTraceableV2, boolean forceClone) {
        DataSet pre = forceClone || !instanceOfTraceableV2 ? TraceHelper.cloneDataSet(data) : data;
        return pre;
    }

    private static DataSet cloneDataSet(DataSet data) {
        try {
            return (DataSet)data.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new TreeExecutionException(cnse);
        }
    }

    private static TracePoint createNewTracePoint(DataSet pre, DataSet current) {
        TracePoint tp = new TracePoint(pre, current);
        if (current instanceof STQStack) {
            List<SelectionTreeQualifier> stqList = ((STQStack)((Object)current)).getQualifierList();
            tp.addInfo(STQ_LIST, new ArrayList<SelectionTreeQualifier>(stqList));
        }
        return tp;
    }

    private static void addServicesToTracePoint(TracePoint tp) {
        Service service;
        Service service2 = service = tp.getPreDataSet() != null ? tp.getPreDataSet().getService() : null;
        if (service != null) {
            tp.addInfo(SERVICE_PRE, service);
        }
        Service service3 = service = tp.getPostDataSet() != null ? tp.getPostDataSet().getService() : null;
        if (service != null) {
            tp.addInfo(SERVICE_POST, service);
        }
    }

    static Service getServiceFromTracePoint(TracePoint tp, boolean isPreDataServiceWanted) {
        return tp != null ? (Service)tp.getInfo(isPreDataServiceWanted ? SERVICE_PRE : SERVICE_POST) : null;
    }

    private static void addCurrentRatingPlanToTracePoint(TracePoint tp) {
        DataSet dataSet = tp.getPreDataSet();
        if (dataSet != null) {
            tp.addInfo(RATING_PLAN_PRE, dataSet.getCurrentRatingPlan());
        }
        if ((dataSet = tp.getPostDataSet()) != null) {
            tp.addInfo(RATING_PLAN_POST, dataSet.getCurrentRatingPlan());
        }
    }

    static RatingPlan getRatingPlanFromTracePoint(TracePoint tp, boolean isPreDataRatingPlanWanted) {
        return tp != null ? (RatingPlan)tp.getInfo(isPreDataRatingPlanWanted ? RATING_PLAN_PRE : RATING_PLAN_POST) : null;
    }
}

