/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.trace;

import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.dataset.DataSetField;
import com.ericsson.ere.dataset.DataSetValueNotFoundException;
import com.ericsson.ere.dataset.Key;
import com.ericsson.ere.selectiontree.util.FieldIndexKeyContainer;
import com.ericsson.ere.trace.TraceDataSet;
import com.ericsson.ere.trace.TracePoint;
import com.ericsson.ere.trace.TracePointDataKey;

public class PluginTraceHelper {
    public static void storeCurrentTimeAsPreDataInTracePoint(TracePoint tp) {
        PluginTraceHelper.storeCurrentTimeInTracePoint(tp, true);
    }

    public static void storeCurrentTimeAsPostDataInTracePoint(TracePoint tp) {
        PluginTraceHelper.storeCurrentTimeInTracePoint(tp, false);
    }

    private static void storeCurrentTimeInTracePoint(TracePoint tp, boolean isPreData) {
        DataSet sourceDataset;
        if (tp == null) {
            throw new IllegalArgumentException("Trace point must not be null.");
        }
        DataSet dataSet = sourceDataset = isPreData ? tp.getPreDataSet() : tp.getPostDataSet();
        if (sourceDataset == null) {
            throw new IllegalArgumentException("TracePoint must contain a data set");
        }
        TracePointDataKey tpdk = isPreData ? TraceDataSet.PRE_CURRENT_TIME : TraceDataSet.POST_CURRENT_TIME;
        tp.addInfo(tpdk, sourceDataset.getCurrentTime().clone());
    }

    public static void addValueAsPreDataInTracePoint(Object identifier, Object value, TracePoint tracePoint) {
        TracePointDataKey tpdk = TracePointDataKey.createKey().withIdentifier(identifier).forPreData();
        tracePoint.addInfo(tpdk, value);
    }

    public static void addValueAsPostDataInTracePoint(Object identifier, Object value, TracePoint tracePoint) {
        TracePointDataKey tpdk = TracePointDataKey.createKey().withIdentifier(identifier).forPostData();
        tracePoint.addInfo(tpdk, value);
    }

    public static void addValueAsPreDataInTracePoint(int tag, Object value, TracePoint tracePoint) {
        TracePointDataKey tpdk = TracePointDataKey.createKey().withTag(tag).forPreData();
        tracePoint.addInfo(tpdk, value);
    }

    public static void addValueAsPostDataInTracePoint(int tag, Object value, TracePoint tracePoint) {
        TracePointDataKey tpdk = TracePointDataKey.createKey().withTag(tag).forPostData();
        tracePoint.addInfo(tpdk, value);
    }

    public static void addFieldValueAsPreDataInTracePoint(DataSetField dataSetField, FieldIndexKeyContainer keyContainer, TracePoint tp) {
        PluginTraceHelper.addFieldValueInTracePoint(dataSetField, keyContainer, tp, true);
    }

    public static void addFieldValueAsPostDataInTracePoint(DataSetField dataSetField, FieldIndexKeyContainer keyContainer, TracePoint tp) {
        PluginTraceHelper.addFieldValueInTracePoint(dataSetField, keyContainer, tp, false);
    }

    public static void addFieldKeysAsPreDataInTracePoint(FieldIndexKeyContainer keyContainer, TracePoint tp) {
        if (keyContainer != null) {
            PluginTraceHelper.addFieldKeysToTracePoint(keyContainer, tp, tp.getPreDataSet(), true);
        }
    }

    public static void addFieldKeysAsPostDataInTracePoint(FieldIndexKeyContainer keyContainer, TracePoint tp) {
        if (keyContainer != null) {
            PluginTraceHelper.addFieldKeysToTracePoint(keyContainer, tp, tp.getPostDataSet(), false);
        }
    }

    private static void addFieldValueInTracePoint(DataSetField dataSetField, FieldIndexKeyContainer keyContainer, TracePoint tp, boolean isPreData) {
        DataSet sourceDataSet;
        if (dataSetField == null || tp == null) {
            throw new IllegalArgumentException("Parameter must not be null");
        }
        DataSet dataSet = sourceDataSet = isPreData ? tp.getPreDataSet() : tp.getPostDataSet();
        if (sourceDataSet == null) {
            throw new IllegalArgumentException("TracePoint must contain a data set");
        }
        if (keyContainer != null) {
            Key[] keys;
            for (Key key : keys = PluginTraceHelper.extractKeys(keyContainer, sourceDataSet)) {
                try {
                    Object oldValue = dataSetField.getValueFromDataSet(sourceDataSet, key);
                    TracePointDataKey tpk = TracePointDataKey.createKey().withDataSetField(dataSetField).andKey(key).forData(isPreData);
                    tp.addInfo(tpk, oldValue);
                }
                catch (DataSetValueNotFoundException dataSetValueNotFoundException) {
                    // empty catch block
                }
            }
            PluginTraceHelper.addFieldKeysToTracePoint(keyContainer, tp, sourceDataSet, isPreData);
        } else {
            PluginTraceHelper.addInfoForSimpleField(dataSetField, sourceDataSet, tp, isPreData);
        }
    }

    private static Key[] extractKeys(FieldIndexKeyContainer keyContainer, DataSet sourceDataSet) {
        Key[] keys;
        try {
            keys = keyContainer.getKeySet(sourceDataSet);
        }
        catch (DataSetValueNotFoundException e) {
            keys = new Key[]{};
        }
        return keys;
    }

    private static void addFieldKeysToTracePoint(FieldIndexKeyContainer keyContainer, TracePoint tp, DataSet sourceDataSet, boolean isPreData) {
        Object[] rawKeys;
        for (Object rk : rawKeys = keyContainer.getRawKeys()) {
            if (!FieldIndexKeyContainer.rawKeyRepresentsField(rk)) continue;
            DataSetField field = FieldIndexKeyContainer.getFieldFromRawKey(rk);
            PluginTraceHelper.addInfoForSimpleField(field, sourceDataSet, tp, isPreData);
        }
    }

    private static void addInfoForSimpleField(DataSetField dataSetField, DataSet sourceDataSet, TracePoint tp, boolean isPreData) {
        try {
            Object value = dataSetField.getValueFromDataSet(sourceDataSet);
            TracePointDataKey tpk = TracePointDataKey.createKey().withDataSetField(dataSetField).forData(isPreData);
            tp.addInfo(tpk, value);
        }
        catch (DataSetValueNotFoundException dataSetValueNotFoundException) {
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }
}

