/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.trace;

import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.executor.DefaultTreeExecutor;
import com.ericsson.ere.executor.TreeExecutor;
import com.ericsson.ere.selectiontree.CircularJumpException;
import com.ericsson.ere.selectiontree.NoTreeFoundException;
import com.ericsson.ere.selectiontree.conditions.ConditionTestResult;
import com.ericsson.ere.selectiontree.conditions.DefaultConditionTestResult;
import com.ericsson.ere.selectiontree.interfaces.Conditionality;
import com.ericsson.ere.selectiontree.interfaces.ExecutableNode;
import com.ericsson.ere.selectiontree.interfaces.Performable;
import com.ericsson.ere.selectiontree.interfaces.ResultConditionality;
import com.ericsson.ere.selectiontree.interfaces.TariffStructure;
import com.ericsson.ere.trace.TracePoint;
import com.ericsson.ere.trace.TraceTreeExecutor;
import ericsson.ere.interfaces.TariffStructureNode;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;

public class GuiTraceTreeExecutor
extends TraceTreeExecutor {
    Stack<TariffStructure> myTariffStructureStack = new Stack();
    Map<Performable, TariffStructure> myExecutedGoToMap = new HashMap<Performable, TariffStructure>();
    private Stack<Object> myStack = new Stack();
    private static final String NODE_PATH = "NodePath";

    public GuiTraceTreeExecutor(TreeExecutor delegee) {
        super(delegee);
    }

    public GuiTraceTreeExecutor() {
        super(new DefaultTreeExecutor());
    }

    @Override
    public void execute(TariffStructure tariffStructure, DataSet dataSet) {
        this.myTariffStructureStack.push(tariffStructure);
        super.execute(tariffStructure, dataSet);
    }

    @Override
    public void execute(Performable aPerformable, DataSet aDataSet) {
        boolean useStack;
        Performable actualPerformable = (Performable)((Object)this.extractActualTarget((TariffStructureNode)((Object)aPerformable)));
        boolean bl = useStack = this.myStack.size() == 0 || this.myStack.peek() != actualPerformable;
        if (useStack) {
            this.myStack.push(actualPerformable);
        }
        TariffStructure currentRoot = this.myTariffStructureStack.size() > 0 ? this.myTariffStructureStack.peek() : null;
        boolean popIfGoTo = true;
        try {
            super.execute(actualPerformable, aDataSet);
        }
        catch (NoTreeFoundException e) {
            popIfGoTo = false;
            throw e;
        }
        catch (CircularJumpException e) {
            popIfGoTo = false;
            throw e;
        }
        finally {
            if (currentRoot != null && currentRoot != this.myTariffStructureStack.peek() && popIfGoTo) {
                TariffStructure root = this.myTariffStructureStack.pop();
                this.myExecutedGoToMap.put(actualPerformable, root);
            }
            if (useStack) {
                this.myStack.pop();
            }
        }
    }

    @Override
    public void execute(ExecutableNode executableNode, DataSet dataSet) {
        ExecutableNode actualExecutable = (ExecutableNode)((Object)this.extractActualTarget((TariffStructureNode)((Object)executableNode)));
        this.myStack.push(actualExecutable);
        super.execute(actualExecutable, dataSet);
        this.myStack.pop();
    }

    @Override
    public boolean testCondition(Conditionality aCondition, DataSet dataSet) {
        Conditionality actualCondition = (Conditionality)((Object)this.extractActualTarget((TariffStructureNode)((Object)aCondition)));
        this.myStack.push(actualCondition);
        boolean result = super.testCondition(actualCondition, dataSet);
        this.myStack.pop();
        return result;
    }

    @Override
    public ConditionTestResult testCondition(ResultConditionality aCondition, DataSet dataSet) {
        ConditionTestResult result = null;
        Conditionality actualCondition = (Conditionality)((Object)this.extractActualTarget((TariffStructureNode)((Object)aCondition)));
        this.myStack.push(actualCondition);
        boolean isLink = aCondition != actualCondition;
        boolean resultCondition = actualCondition instanceof ResultConditionality;
        result = isLink && !resultCondition ? new DefaultConditionTestResult(super.testCondition(actualCondition, dataSet)) : super.testCondition((ResultConditionality)actualCondition, dataSet);
        this.myStack.pop();
        return result;
    }

    @Override
    protected void addAdditionalInfo(TracePoint tp) {
        super.addAdditionalInfo(tp);
        tp.addInfo(NODE_PATH, this.myStack.clone());
    }

    @Override
    public TraceTreeExecutor.TraceData getTraceData() {
        return new GuiTraceData();
    }

    public class GuiTraceData
    extends TraceTreeExecutor.TraceData {
        public GuiTraceData() {
            super(GuiTraceTreeExecutor.this);
        }

        public Map<Performable, TariffStructure> getExecutedTreeJumps() {
            return GuiTraceTreeExecutor.this.myExecutedGoToMap;
        }
    }
}

