/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.util;

import com.ericsson.ere.annotations.ConfigurationClass;
import com.ericsson.ere.interfaces.XMLAppendable;
import com.ericsson.ere.selectiontree.ParseContext;
import com.ericsson.ere.selectiontree.interfaces.PluginConfiguration;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.xml.DomWriter;
import ericsson.ere.xml.XMLUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class PluginConfigurationHelper {
    private static final Map<Class<?>, Method> myConfigCreateMethodCache = new HashMap();

    private PluginConfigurationHelper() {
    }

    private static Method getCreateMethod(Class<?> pluginTrafficClass) {
        Method meth = myConfigCreateMethodCache.get(pluginTrafficClass);
        if (meth == null) {
            ConfigurationClass cc = pluginTrafficClass.getAnnotation(ConfigurationClass.class);
            if (cc == null) {
                throw new IllegalStateException(PluginConfigurationHelper.msg("No configuration class specified for %s.", pluginTrafficClass));
            }
            Class<? extends PluginConfiguration> configClass = cc.value();
            if (!Modifier.isPublic(configClass.getModifiers())) {
                throw new IllegalStateException(PluginConfigurationHelper.msg("Configuration class %s is not public.", configClass));
            }
            try {
                Method m = configClass.getMethod("create", ParseContext.class);
                if (!Modifier.isStatic(m.getModifiers())) {
                    throw new IllegalStateException(PluginConfigurationHelper.msg("The create method in configuration class %s is not static.", configClass));
                }
                if (!PluginConfiguration.class.isAssignableFrom(m.getReturnType())) {
                    throw new IllegalStateException(PluginConfigurationHelper.msg("The create method in configuration class %s does not return a PluginConfiguration object.", configClass));
                }
                meth = m;
                myConfigCreateMethodCache.put(pluginTrafficClass, m);
            }
            catch (NoSuchMethodException ex) {
                throw new IllegalStateException(PluginConfigurationHelper.msg("No public create(ParseContext) method found in configuration class %s.", configClass));
            }
        }
        return meth;
    }

    private static String msg(String fmt, Class<?> clazz) {
        String msg = String.format(fmt, clazz.getName());
        return msg;
    }

    public static PluginConfiguration createConfigurationInstance(Class<?> sourceClass, ParseContext context) throws InvocationTargetException {
        Method createMethod = PluginConfigurationHelper.getCreateMethod(sourceClass);
        assert (createMethod != null) : "getCreateMethod should throw on failure.";
        return PluginConfigurationHelper.createConfigurationInstance(createMethod, context);
    }

    public static boolean hasValidConfigurationClass(Class<?> sourceClass) {
        try {
            PluginConfigurationHelper.getCreateMethod(sourceClass);
            return true;
        }
        catch (IllegalStateException ex) {
            return false;
        }
    }

    public static void writeXML(XMLAppendable conf, PrintWriter out, int indentLevel, String indentMarker) {
        String sep;
        Document doc = XMLUtil.createEmptyDocument();
        Element parent = doc.createElement("root");
        conf.appendXML(parent);
        StringWriter sw = new StringWriter();
        for (Node n : XMLUtil.getElementChildren(parent)) {
            DomWriter.nodeToWriter(n, sw, true, false);
        }
        String xml = sw.toString();
        if (xml.length() > 0) {
            xml = XMLUtil.indentXML(xml, indentLevel, indentMarker);
        }
        if (!"\n".equals(sep = System.getProperty("line.separator"))) {
            xml = xml.replace(sep, "\n");
        }
        out.write(xml);
    }

    public static String getElementTypeName(ClassRepository repository, Node configuration, boolean useAlias) {
        String nodeName = configuration.getNodeName();
        int type = PluginConfigurationHelper.getElementType(nodeName);
        if (type < 0) {
            throw new IllegalArgumentException("Unknown element type: " + configuration);
        }
        String tn = PluginConfigurationHelper.getRawTypeName(configuration, type);
        if (repository != null && useAlias) {
            String alias = tn;
            switch (type) {
                case 3: {
                    alias = repository.getModifierAliasOrName(tn);
                    break;
                }
                case 2: {
                    alias = repository.getConditionAliasOrName(tn);
                }
            }
            tn = alias;
        }
        return tn;
    }

    private static String getRawTypeName(Node configuration, int type) {
        Element e = (Element)configuration;
        String tn = type == 0 ? XMLUtil.getAttributeFromElement(e, "type", "TariffStructure") : (type == 1 ? XMLUtil.getAttributeFromElement(e, "type", "Node") : XMLUtil.getFirstTextContent(configuration));
        return tn;
    }

    private static int getElementType(String name) {
        int type = -1;
        if ("Tariff".equals(name) || "Modifier".equals(name) || "Leaf".equals(name) || "Action".equals(name)) {
            type = 3;
        } else if ("Condition".equals(name) || "Subcondition".equals(name)) {
            type = 2;
        } else if ("Node".equals(name)) {
            type = 1;
        } else if ("TariffStructure".equals(name)) {
            type = 0;
        }
        return type;
    }

    private static PluginConfiguration createConfigurationInstance(Method createMethod, ParseContext context) throws InvocationTargetException {
        try {
            return (PluginConfiguration)createMethod.invoke(null, context);
        }
        catch (IllegalArgumentException ex) {
            throw new AssertionError((Object)ex);
        }
        catch (IllegalAccessException ex) {
            throw new AssertionError((Object)ex);
        }
    }
}

