/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.util;

import com.ericsson.ere.selectiontree.FieldFilter;
import com.ericsson.ere.selectiontree.HierarchicalFieldFilter;
import com.ericsson.ere.selectiontree.conditions.field.BitPatternEditorSupport;
import com.ericsson.ere.selectiontree.conditions.field.DefaultValueSupport;
import com.ericsson.ere.selectiontree.conditions.field.EnumEditorSupport;
import com.ericsson.ere.selectiontree.conditions.field.NumberRangeEditorSupport;
import com.ericsson.ere.selectiontree.interfaces.ContextCondition;
import com.ericsson.ere.selectiontree.interfaces.FieldArraySupport;
import com.ericsson.ere.selectiontree.interfaces.FieldKeyIndexSupport;
import com.ericsson.ere.selectiontree.interfaces.FieldKeyIndexUser;
import com.ericsson.ere.selectiontree.interfaces.FieldMappable;
import ericsson.ere.condition.AbstractConditionProfile;
import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.EreClassLoader;
import ericsson.ere.defs.EreDefs;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.defs.FieldDefinitionHelper;
import ericsson.ere.defs.PluginName;
import ericsson.ere.gui.interfaces.SimulationEditor;
import ericsson.ere.gui.util.EnumEditor;
import ericsson.ere.gui.util.NumberRangeEditor;
import ericsson.ere.interfaces.ConditionProfile;
import ericsson.ere.interfaces.FieldHierarchyNode;
import ericsson.ere.interfaces.XMLInitializable;
import ericsson.vareditor.variable.bitpatternutils.BitPatternEditor;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Element;

public class ClassRepositoryHelper {
    public static final String ALL_FIELDS = "ALL fields";
    public static final String NON_CONTEXT_FIELD = "Non context field";
    public static final FieldDefinition SPECIAL_FIELD_START_TIME = new SpecialFieldDefinition("StartTime()", DataType.DATE, "Tree execution start time");
    public static final FieldDefinition SPECIAL_FIELD_CURRENT_TIME = new SpecialFieldDefinition("CurrentTime()", DataType.DATE, "The current time");
    private ClassRepository myClassRepository;
    private Map<Integer, List<ConditionHolder>> mySupportedDataTypes = new HashMap<Integer, List<ConditionHolder>>();
    private Map<String, List<ConditionHolder>> myMappedConditions = new HashMap<String, List<ConditionHolder>>();
    private Map<String, SimulationEditor> myEditComponentFields = new HashMap<String, SimulationEditor>();
    private Map<FieldHierarchyNode.ComplexType, List<ConditionHolder>> mySupportedCollectionTypes = new HashMap<FieldHierarchyNode.ComplexType, List<ConditionHolder>>();

    public ClassRepositoryHelper(ClassRepository classRepository) {
        this.myClassRepository = classRepository;
        this.loadSupportedDataTypes();
        this.loadMappedConditions();
        this.loadEditComponentFields();
        this.loadSupportedCollectionTypes();
    }

    private void loadSupportedDataTypes() {
        List<PluginName> list = this.myClassRepository.getBaseConditionList();
        for (PluginName current : list) {
            String profileName;
            String currentBaseConditionName = current.getName();
            String className = this.myClassRepository.getBaseConditionClass(currentBaseConditionName);
            if (!ClassRepositoryHelper.supportsFieldMappable(className, profileName = this.myClassRepository.getBaseConditionProfile(currentBaseConditionName))) continue;
            List<String> dataTypeList = this.myClassRepository.getBaseConditionDataType(currentBaseConditionName);
            for (String currentDT : dataTypeList) {
                ConditionHolder holder = new ConditionHolder(currentBaseConditionName, className, profileName);
                this.putDataType(EreDefs.getDataType(currentDT), holder);
            }
        }
    }

    private void loadMappedConditions() {
        for (String currentFieldConditionName : this.myClassRepository.getConnectedBaseConditions().keySet()) {
            String conditionName = this.myClassRepository.getConnectedBaseConditions().get(currentFieldConditionName);
            String className = this.myClassRepository.getBaseConditionClass(conditionName);
            String profileName = this.myClassRepository.getBaseConditionProfile(conditionName);
            String fieldName = this.myClassRepository.getConditionFieldName(currentFieldConditionName);
            List<ConditionHolder> list = this.myMappedConditions.get(fieldName);
            if (list == null) {
                list = new ArrayList<ConditionHolder>();
            }
            list.add(new ConditionHolder(currentFieldConditionName, className, profileName));
            this.myMappedConditions.put(fieldName, list);
        }
    }

    private void loadEditComponentFields() {
        List<FieldDefinition> list = this.myClassRepository.getFieldDefinitions();
        Iterator<FieldDefinition> iterator = list.iterator();
        while (iterator.hasNext()) {
            FieldDefinition field;
            FieldDefinition fieldDef = field = iterator.next();
            try {
                SimulationEditor simEdit;
                XMLInitializable editComponent = fieldDef.createUtil("EditComponent");
                if (editComponent != null) {
                    simEdit = (SimulationEditor)((Object)editComponent);
                    simEdit.setFieldDefinition(fieldDef);
                    this.myEditComponentFields.put(fieldDef.getFieldName(), simEdit);
                }
                if ((editComponent = fieldDef.createUtil("InputRestriction")) == null) continue;
                simEdit = (SimulationEditor)((Object)editComponent);
                simEdit.setFieldDefinition(fieldDef);
                this.myEditComponentFields.put(fieldDef.getFieldName(), simEdit);
            }
            catch (Exception exception) {}
        }
    }

    private void loadSupportedCollectionTypes() {
        for (PluginName currentCondition : this.myClassRepository.getFieldStructureBaseConditions()) {
            String profileName;
            String currentConditionName = currentCondition.getName();
            String className = this.myClassRepository.getFieldStructureBaseConditionClass(currentConditionName);
            if (!ClassRepositoryHelper.supportsFieldMappable(className, profileName = this.myClassRepository.getFieldStructureBaseConditionProfile(currentConditionName))) continue;
            List<String> collectionTypeList = this.myClassRepository.getFieldStructureBaseConditionCollectionTypes(currentConditionName);
            for (String currentCT : collectionTypeList) {
                ConditionHolder holder = new ConditionHolder(currentConditionName, className, profileName);
                this.connectConditionToCollectionType(FieldHierarchyNode.ComplexType.valueOf(currentCT), holder);
            }
        }
    }

    private void connectConditionToCollectionType(FieldHierarchyNode.ComplexType collectionType, ConditionHolder holder) {
        if (this.mySupportedCollectionTypes.containsKey((Object)collectionType)) {
            this.mySupportedCollectionTypes.get((Object)collectionType).add(holder);
        } else {
            ArrayList<ConditionHolder> conditionList = new ArrayList<ConditionHolder>();
            conditionList.add(holder);
            this.mySupportedCollectionTypes.put(collectionType, conditionList);
        }
    }

    public List<String> getSupportedFieldStructureConditionProfileNamesForField(String fieldName) {
        List<ConditionHolder> profileCandidates;
        ArrayList<String> list = new ArrayList<String>();
        FieldHierarchyNode.ComplexType collectionType = this.getFieldStructureComplexType(fieldName);
        if (collectionType != null && (profileCandidates = this.mySupportedCollectionTypes.get((Object)collectionType)) != null) {
            for (ConditionHolder holder : profileCandidates) {
                list.add(holder.getName());
            }
        }
        return list;
    }

    private FieldHierarchyNode.ComplexType getFieldStructureComplexType(String fieldName) {
        FieldHierarchyNode fieldNode = this.myClassRepository.getFieldRepository().getFieldByName(fieldName);
        return fieldNode != null && !fieldNode.isLeaf() ? fieldNode.getComplexType() : null;
    }

    public boolean fieldHasEditComponentDefined(String fieldName) {
        return this.myEditComponentFields.containsKey(fieldName);
    }

    public SimulationEditor getFieldsEditComponentVariable(String fieldName) {
        return this.myEditComponentFields.get(fieldName);
    }

    public int[] getSupportedDataTypes() {
        int[] retInt = new int[this.mySupportedDataTypes.size()];
        Iterator<Integer> iterator = this.mySupportedDataTypes.keySet().iterator();
        int ii = 0;
        while (iterator.hasNext()) {
            retInt[ii] = iterator.next();
            ++ii;
        }
        return retInt;
    }

    public List<Integer> getSupportedDataTypesInList() {
        ArrayList<Integer> intList = new ArrayList<Integer>(this.mySupportedDataTypes.size());
        Iterator<Integer> iterator = this.mySupportedDataTypes.keySet().iterator();
        int ii = 0;
        while (iterator.hasNext()) {
            intList.add(iterator.next());
            ++ii;
        }
        return intList;
    }

    public String[] getSupportedDataTypeNames() {
        int[] supportedDataTypes = this.getSupportedDataTypes();
        String[] supportedDataTypeNames = new String[supportedDataTypes.length];
        for (int i = 0; i < supportedDataTypes.length; ++i) {
            supportedDataTypeNames[i] = EreDefs.dataTypeArray[supportedDataTypes[i]];
        }
        return supportedDataTypeNames;
    }

    public ClassRepository getClassRepository() {
        return this.myClassRepository;
    }

    @Deprecated
    public String[] getArrayWithAllNumericNonArrayFields() {
        return this.getArrayWithAllNumericNonArrayFieldsForField(null);
    }

    @Deprecated
    public String[] getArrayWithAllNonComplexFields() {
        return this.getArrayWithAllNonComplexFieldsForField(null);
    }

    @Deprecated
    public String[] getArrayWithAllNumericFields() {
        return this.getArrayWithAllNumericFieldsForField(null);
    }

    public String[] getArrayWithAllNumericNonArrayFieldsForField(String fieldName) {
        ArrayList<String> listWithNumericFields = new ArrayList<String>();
        List<FieldDefinition> candidates = this.getCandidateFieldsForField(fieldName);
        for (FieldDefinition currentFieldDefinition : candidates) {
            DataType datatype;
            if (currentFieldDefinition.isComplexType() || !(datatype = currentFieldDefinition.getTypedDataType()).isIntegerNumeric()) continue;
            listWithNumericFields.add(currentFieldDefinition.getFieldName());
        }
        return listWithNumericFields.toArray(new String[listWithNumericFields.size()]);
    }

    public String[] getArrayWithAllTypedNonArrayFieldsForField(String fieldName, DataType dataType) {
        if (dataType == null) {
            throw new IllegalArgumentException("Data type cannot be null.");
        }
        ArrayList<String> listWithNumericFields = new ArrayList<String>();
        List<FieldDefinition> candidates = this.getCandidateFieldsForField(fieldName);
        for (FieldDefinition currentFieldDefinition : candidates) {
            DataType fieldType;
            if (currentFieldDefinition.isComplexType() || (fieldType = currentFieldDefinition.getTypedDataType()) != dataType) continue;
            listWithNumericFields.add(currentFieldDefinition.getFieldName());
        }
        return listWithNumericFields.toArray(new String[listWithNumericFields.size()]);
    }

    private List<FieldDefinition> getCandidateFieldsForField(String fieldName) {
        List<FieldDefinition> candidates = fieldName == null ? this.myClassRepository.getFieldDefinitions() : this.getFieldDefinitionsForFields(this.getFieldMappableFieldsForField(true, fieldName));
        return candidates;
    }

    public String[] getArrayWithAllNonComplexFieldsForField(String fieldName) {
        ArrayList<String> listWithFields = new ArrayList<String>();
        List<FieldDefinition> candidates = this.getCandidateFieldsForField(fieldName);
        for (FieldDefinition currentFieldDefinition : candidates) {
            if (currentFieldDefinition.isComplexType()) continue;
            listWithFields.add(currentFieldDefinition.getFieldName());
        }
        return listWithFields.toArray(new String[listWithFields.size()]);
    }

    public String[] getArrayWithAllNumericFieldsForField(String fieldName) {
        ArrayList<String> listWithNumericFields = new ArrayList<String>();
        List<FieldDefinition> candidates = this.getCandidateFieldsForField(fieldName);
        for (FieldDefinition currentFieldDefinition : candidates) {
            DataType datatype = currentFieldDefinition.getTypedDataType();
            if (!datatype.isIntegerNumeric()) continue;
            listWithNumericFields.add(currentFieldDefinition.getFieldName());
        }
        return listWithNumericFields.toArray(new String[listWithNumericFields.size()]);
    }

    private List<FieldDefinition> getFieldDefinitionsForFields(List<String> fieldNames) {
        ArrayList<FieldDefinition> fieldDefinitions = new ArrayList<FieldDefinition>();
        for (String name : fieldNames) {
            fieldDefinitions.add(this.myClassRepository.getFieldDefinitionByName(name));
        }
        return fieldDefinitions;
    }

    public static boolean supportsFieldMappable(String className, String profileName) {
        try {
            return FieldMappable.class.isAssignableFrom(EreClassLoader.getClass(className)) && FieldMappable.class.isAssignableFrom(EreClassLoader.getClass(profileName));
        }
        catch (Exception e) {
            return false;
        }
    }

    private void putDataType(int dataType, ConditionHolder holder) {
        if (this.mySupportedDataTypes.containsKey(dataType)) {
            List<ConditionHolder> listToUse = this.mySupportedDataTypes.get(dataType);
            listToUse.add(holder);
        } else {
            ArrayList<ConditionHolder> listToUse = new ArrayList<ConditionHolder>();
            listToUse.add(holder);
            this.mySupportedDataTypes.put(dataType, listToUse);
        }
    }

    private String getProfileClass(int dataType, String fieldName, String conditionName) {
        ArrayList list = new ArrayList();
        list.addAll(this.mySupportedDataTypes.get(dataType));
        if (this.myMappedConditions.containsKey(fieldName)) {
            list.addAll(this.myMappedConditions.get(fieldName));
        }
        for (ConditionHolder current : list) {
            if (!conditionName.equals(current.getName())) continue;
            return current.getProfileClassName();
        }
        return null;
    }

    private String getProfileClass(String fieldName, String conditionName) {
        FieldHierarchyNode.ComplexType collectionType = this.getFieldStructureComplexType(fieldName);
        String retVal = collectionType != null ? this.getProfileClass(collectionType, conditionName) : this.getProfileClass(this.getDataTypeForField(fieldName), fieldName, conditionName);
        return retVal;
    }

    private String getProfileClass(FieldHierarchyNode.ComplexType collectionType, String conditionName) {
        String retVal = null;
        if (this.mySupportedCollectionTypes.containsKey((Object)collectionType)) {
            for (ConditionHolder current : this.mySupportedCollectionTypes.get((Object)collectionType)) {
                if (!conditionName.equals(current.getName())) continue;
                retVal = current.getProfileClassName();
                break;
            }
        }
        return retVal;
    }

    public String getTrafficClass(String fieldName, String conditionName) {
        return this.getTrafficClass(this.getDataTypeForField(fieldName), fieldName, conditionName);
    }

    private String getTrafficClass(int dataType, String fieldName, String conditionName) {
        ArrayList list = new ArrayList();
        list.addAll(this.mySupportedDataTypes.get(dataType));
        if (this.myMappedConditions.containsKey(fieldName)) {
            list.addAll(this.myMappedConditions.get(fieldName));
        }
        for (ConditionHolder current : list) {
            if (!conditionName.equals(current.getName())) continue;
            return current.getClassName();
        }
        return null;
    }

    public ConditionProfile getConditionProfile(String fieldName, String conditionName) {
        SimulationEditor editorToUse = this.myEditComponentFields.get(fieldName);
        try {
            String profileClassName = this.getProfileClass(fieldName, conditionName);
            if (profileClassName != null) {
                FieldDefinition field;
                ConditionProfile conditionProfile = (ConditionProfile)EreClassLoader.createInstance(profileClassName);
                if (editorToUse != null && editorToUse instanceof EnumEditor && conditionProfile instanceof EnumEditorSupport) {
                    ((EnumEditorSupport)((Object)conditionProfile)).setEnumVariable(editorToUse.createVariable());
                } else if (editorToUse != null && editorToUse instanceof NumberRangeEditor && conditionProfile instanceof NumberRangeEditorSupport) {
                    ((NumberRangeEditorSupport)((Object)conditionProfile)).setNumberRangeVariable(editorToUse.createVariable());
                } else if (editorToUse != null && editorToUse instanceof BitPatternEditor && conditionProfile instanceof BitPatternEditorSupport) {
                    ((BitPatternEditorSupport)((Object)conditionProfile)).setBitPatternVariable(editorToUse.createVariable());
                }
                if (conditionProfile instanceof DefaultValueSupport && (field = this.myClassRepository.getFieldDefinitionByName(fieldName)) != null && !field.isComplexType() && field.hasDefaultValue()) {
                    String defaultValue = field.getDefaultValue();
                    ((DefaultValueSupport)((Object)conditionProfile)).setDefaultValue(defaultValue);
                }
                if (conditionProfile instanceof AbstractConditionProfile) {
                    ((AbstractConditionProfile)conditionProfile).setIsMapped(false);
                    ((AbstractConditionProfile)conditionProfile).setFieldName(fieldName);
                    ((AbstractConditionProfile)conditionProfile).setName(conditionName);
                }
                if (conditionProfile.needsRepository()) {
                    conditionProfile.setClassRepository(this.myClassRepository);
                }
                return conditionProfile;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private boolean fieldDataTypeIsSupported(FieldDefinition fd) {
        return this.mySupportedDataTypes.containsKey(fd.getDatatype());
    }

    public static boolean fieldIsCommonOrVisibleContextField(FieldHierarchyNode field, ClassRepository repository) {
        return !field.isContextField() || field.getContextNames().size() > 0 || ClassRepositoryHelper.fieldIsContextIdentifier(field, repository);
    }

    private static boolean fieldIsCommonOrVisibleContextFieldForContext(FieldHierarchyNode field, String contextName, ClassRepository repository) {
        boolean result = contextName == null ? ClassRepositoryHelper.fieldIsCommonOrVisibleContextField(field, repository) : !field.isContextField() || field.getContextNames().contains(contextName) || ClassRepositoryHelper.fieldIsContextIdentifier(field, repository);
        return result;
    }

    private static boolean fieldIsContextIdentifier(FieldHierarchyNode field, ClassRepository repository) {
        return field.getFieldName().equals(repository.getContextFieldIdentifier());
    }

    public String[] getOutFields() {
        ArrayList<String> list = new ArrayList<String>();
        for (int current : this.getSupportedDataTypes()) {
            for (String fieldName : this.myClassRepository.getFieldNamesOfType(current)) {
                if (!"OUT".equals(this.myClassRepository.getFieldDefinitionByName(fieldName).getParameterType())) continue;
                list.add(fieldName);
            }
        }
        String[] retArray = new String[list.size()];
        for (int ii = 0; ii < retArray.length; ++ii) {
            retArray[ii] = (String)list.get(ii);
        }
        return retArray;
    }

    public Element getElementForField(String fieldName) {
        return (Element)this.myClassRepository.getFieldDefinitionByName(fieldName).getDefinitionNode();
    }

    public int getDataTypeForField(String fieldName) {
        return this.myClassRepository.getFieldDefinitionByName(fieldName).getDatatype();
    }

    public String[] getFieldMappableProfileNamesForField(String fieldName) {
        int dataType = this.getDataTypeForField(fieldName);
        boolean fieldIsOfComplexType = this.myClassRepository.getFieldDefinitionByName(fieldName).isComplexType();
        ArrayList<ConditionHolder> list = new ArrayList<ConditionHolder>();
        List<ConditionHolder> profileCandidates = this.mySupportedDataTypes.get(dataType);
        if (profileCandidates != null) {
            for (ConditionHolder holder : profileCandidates) {
                if (!holder.isFieldMappable()) continue;
                if (fieldIsOfComplexType) {
                    if (!holder.supportComplexTypeSingleValueAccess()) continue;
                    list.add(holder);
                    continue;
                }
                list.add(holder);
            }
        }
        String[] retArray = new String[list.size()];
        int ii = 0;
        for (ConditionHolder current : list) {
            retArray[ii] = current.getName();
            ++ii;
        }
        return retArray;
    }

    public List<String> getContextConditionProfileNamesForField(String fieldName) {
        ArrayList<String> profileNames = new ArrayList<String>();
        List<ConditionHolder> profileCandidates = this.mySupportedDataTypes.get(this.getDataTypeForField(fieldName));
        if (profileCandidates != null) {
            for (ConditionHolder holder : profileCandidates) {
                if (!holder.isContextCondition()) continue;
                profileNames.add(holder.getName());
            }
        }
        return profileNames;
    }

    public String[] getAnnotatedConditionsForField(String fieldName, Class<? extends Annotation> annotation) {
        if (annotation == null) {
            throw new IllegalArgumentException("Annotation cannot be null");
        }
        FieldDefinition fd = this.myClassRepository.getFieldDefinitionByName(fieldName);
        if (fd == null) {
            throw new IllegalArgumentException("Field " + fieldName + " doesn't exist");
        }
        ArrayList<ConditionHolder> resultList = new ArrayList<ConditionHolder>();
        List<ConditionHolder> profileCandidates = this.mySupportedDataTypes.get(fd.getDatatype());
        if (profileCandidates != null) {
            for (ConditionHolder holder : profileCandidates) {
                if (!holder.isFieldMappable() || !holder.isConditionProfileAnnotationPresent(annotation)) continue;
                resultList.add(holder);
            }
        }
        String[] retArray = new String[resultList.size()];
        int ii = 0;
        for (ConditionHolder current : resultList) {
            retArray[ii] = current.getName();
            ++ii;
        }
        return retArray;
    }

    public String[] getAllFieldMappableProfileNames() {
        HashSet<String> conditionNameSet = new HashSet<String>();
        for (Map.Entry<Integer, List<ConditionHolder>> currentEntry : this.mySupportedDataTypes.entrySet()) {
            List<ConditionHolder> conditionList = currentEntry.getValue();
            for (ConditionHolder holder : conditionList) {
                if (!holder.isFieldMappable()) continue;
                conditionNameSet.add(holder.getName());
            }
        }
        ArrayList conditionNameList = new ArrayList(conditionNameSet);
        Collections.sort(conditionNameList);
        return conditionNameList.toArray(new String[conditionNameList.size()]);
    }

    public String[] getProfileNamesForField(String fieldName) {
        int dataType = this.getDataTypeForField(fieldName);
        boolean fieldIsOfComplexDataType = this.myClassRepository.getFieldDefinitionByName(fieldName).isComplexType();
        ArrayList<ConditionHolder> list = new ArrayList<ConditionHolder>();
        List<ConditionHolder> profileCandidates = this.mySupportedDataTypes.get(dataType);
        if (profileCandidates != null) {
            for (ConditionHolder holder : profileCandidates) {
                if (fieldIsOfComplexDataType) {
                    if (!holder.supportComplexTypeSingleValueAccess()) continue;
                    list.add(holder);
                    continue;
                }
                list.add(holder);
            }
        }
        if (this.myMappedConditions.containsKey(fieldName)) {
            list.addAll((Collection)this.myMappedConditions.get(fieldName));
        }
        String[] retArray = new String[list.size()];
        int ii = 0;
        for (ConditionHolder current : list) {
            retArray[ii] = current.getName();
            ++ii;
        }
        return retArray;
    }

    public boolean isFieldArray(String fieldName) {
        return this.myClassRepository.getFieldDefinitionByName(fieldName).isArray();
    }

    public boolean isFieldMap(String fieldName) {
        return this.myClassRepository.getFieldDefinitionByName(fieldName).isMap();
    }

    public boolean hasContext() {
        return this.myClassRepository.getAllContexts() != null;
    }

    public String[] getAllContext() {
        Set<Map.Entry<String, Element>> allContexts = this.myClassRepository.getAllContexts();
        int contextsCount = 0;
        if (allContexts != null) {
            contextsCount = allContexts.size();
        }
        String[] contexts = new String[contextsCount + 2];
        contexts[0] = ALL_FIELDS;
        contexts[1] = NON_CONTEXT_FIELD;
        int index = 2;
        if (allContexts != null) {
            for (Map.Entry<String, Element> entry : allContexts) {
                contexts[index] = entry.getKey();
                ++index;
            }
        }
        return contexts;
    }

    public List<String> getFieldListForContextHavingSupportingCondition(String selectedContext, boolean includeAll) {
        if (ALL_FIELDS.equals(selectedContext)) {
            return this.getFieldMappableFieldsHavingSupportingCondition(includeAll);
        }
        if (NON_CONTEXT_FIELD.equals(selectedContext)) {
            return this.getNonContextFieldsHavingSupportingCondition(includeAll);
        }
        ArrayList<String> fields = new ArrayList<String>();
        for (FieldDefinition fd : this.myClassRepository.getFieldDefinitions()) {
            if (!includeAll && !fd.isAutoConditionMapAllowed() || !this.fieldIsConnectedToContext(fd, selectedContext) || !this.fieldDataTypeIsSupported(fd) || ClassRepositoryHelper.fieldIsWorkingParameter(fd)) continue;
            fields.add(fd.getFieldName());
        }
        Collections.sort(fields, String.CASE_INSENSITIVE_ORDER);
        return fields;
    }

    public List<String> getFieldMappableFieldsHavingSupportingCondition(boolean includeAll) {
        ArrayList<String> list = new ArrayList<String>();
        for (FieldDefinition fd : this.myClassRepository.getFieldDefinitions()) {
            if (!includeAll && !fd.isAutoConditionMapAllowed() || !ClassRepositoryHelper.fieldIsCommonOrVisibleContextField(fd, this.myClassRepository) || !this.fieldDataTypeIsSupported(fd) || ClassRepositoryHelper.fieldIsWorkingParameter(fd)) continue;
            list.add(fd.getFieldName());
        }
        Collections.sort(list, String.CASE_INSENSITIVE_ORDER);
        return list;
    }

    private List<String> getNonContextFieldsHavingSupportingCondition(boolean includeAll) {
        ArrayList<String> list = new ArrayList<String>();
        for (FieldDefinition fd : this.myClassRepository.getFieldDefinitions()) {
            if (!includeAll && !fd.isAutoConditionMapAllowed() || fd.isContextField() || !this.fieldDataTypeIsSupported(fd) || ClassRepositoryHelper.fieldIsWorkingParameter(fd)) continue;
            list.add(fd.getFieldName());
        }
        Collections.sort(list, String.CASE_INSENSITIVE_ORDER);
        return list;
    }

    private static boolean fieldIsWorkingParameter(FieldDefinition fd) {
        return "WORKING".equals(fd.getParameterType());
    }

    public String[] getFieldsForContext(String selectedContext) {
        return this.getFieldsForContext(selectedContext, false);
    }

    public String[] getFieldsForContext(String selectedContext, boolean includeAll) {
        List<String> fields = this.getFieldListForContext(selectedContext, includeAll);
        return fields.toArray(new String[fields.size()]);
    }

    public List<String> getFieldListForContext(String selectedContext, boolean includeAll) {
        if (ALL_FIELDS.equals(selectedContext)) {
            return this.getFieldMappableFields(includeAll);
        }
        if (NON_CONTEXT_FIELD.equals(selectedContext)) {
            return this.getNonContextFields(includeAll);
        }
        ArrayList<String> fields = new ArrayList<String>();
        for (FieldDefinition fd : this.myClassRepository.getFieldDefinitions()) {
            if (!includeAll && !fd.isAutoConditionMapAllowed() || !this.fieldIsConnectedToContext(fd, selectedContext) || ClassRepositoryHelper.fieldIsWorkingParameter(fd)) continue;
            fields.add(fd.getFieldName());
        }
        Collections.sort(fields, String.CASE_INSENSITIVE_ORDER);
        return fields;
    }

    public List<String> getFieldMappableFields(boolean includeAll) {
        ArrayList<String> list = new ArrayList<String>();
        for (FieldDefinition fd : this.myClassRepository.getFieldDefinitions()) {
            if (!includeAll && !fd.isAutoConditionMapAllowed() || !ClassRepositoryHelper.fieldIsCommonOrVisibleContextField(fd, this.myClassRepository) || ClassRepositoryHelper.fieldIsWorkingParameter(fd)) continue;
            list.add(fd.getFieldName());
        }
        Collections.sort(list, String.CASE_INSENSITIVE_ORDER);
        return list;
    }

    public List<String> getFieldMappableFieldsForField(boolean includeAll, String fieldName) {
        List<FieldDefinition> list = includeAll ? ClassRepositoryHelper.extractVisibleFieldsForField(fieldName, this.myClassRepository) : ClassRepositoryHelper.extractMappableVisibleFieldsForField(fieldName, this.myClassRepository);
        return FieldDefinitionHelper.extractFieldNameList(list);
    }

    private static void getValidFieldsForContextScope(List<FieldDefinition> list, String context, boolean includeAll, ClassRepository repository) {
        for (FieldDefinition fd : repository.getFieldDefinitions()) {
            if (!includeAll && !fd.isAutoConditionMapAllowed() || !ClassRepositoryHelper.fieldIsCommonOrVisibleContextFieldForContext(fd, context, repository) || ClassRepositoryHelper.fieldIsWorkingParameter(fd) || list.contains(fd)) continue;
            list.add(fd);
        }
    }

    private List<String> getNonContextFields(boolean includeAll) {
        ArrayList<String> fields = new ArrayList<String>();
        for (FieldDefinition fd : this.myClassRepository.getFieldDefinitions()) {
            if (!includeAll && !fd.isAutoConditionMapAllowed() || fd.isContextField() || ClassRepositoryHelper.fieldIsWorkingParameter(fd)) continue;
            fields.add(fd.getFieldName());
        }
        Collections.sort(fields, String.CASE_INSENSITIVE_ORDER);
        return fields;
    }

    private boolean fieldIsConnectedToContext(FieldDefinition fd, String selectedContext) {
        if (fd.isContextField()) {
            List<String> contextNames = fd.getContextNames();
            return contextNames.contains(selectedContext);
        }
        return false;
    }

    public boolean fieldHasInputRestrictionDefined(String fieldName) {
        return this.myEditComponentFields.containsKey(fieldName);
    }

    public SimulationEditor getFieldsInputRestrictionVariable(String fieldName) {
        return this.myEditComponentFields.get(fieldName);
    }

    @Deprecated
    public String getContextForField(String field) {
        for (String context : this.getAllContext()) {
            if (ALL_FIELDS.equals(context)) continue;
            for (String currentField : this.getFieldsForContext(context, true)) {
                if (field == null || !field.equals(currentField)) continue;
                return context;
            }
        }
        return null;
    }

    public List<String> getAllContextsForField(String field) {
        return ClassRepositoryHelper.extractContextNamesForField(field, this.myClassRepository);
    }

    public static List<FieldDefinition> extractVisibleFields(ClassRepository repository) {
        return ClassRepositoryHelper.extractVisibleFields(repository, new AllowAllFieldsFilter());
    }

    public static List<FieldDefinition> extractMappableVisibleFields(ClassRepository repository) {
        return ClassRepositoryHelper.extractVisibleFields(repository, new MappableFieldFilter());
    }

    public static List<FieldDefinition> extractMappableVisibleFieldsForField(String fieldName, ClassRepository repository) {
        return ClassRepositoryHelper.extractFieldsForField(fieldName, repository, false);
    }

    public static List<FieldDefinition> extractVisibleFieldsForField(String fieldName, ClassRepository repository) {
        return ClassRepositoryHelper.extractFieldsForField(fieldName, repository, true);
    }

    public static List<String> extractContextNamesForField(String fieldName, ClassRepository repository) {
        FieldDefinition field = repository.getFieldDefinitionByName(fieldName);
        ArrayList<String> fieldsContextNames = null;
        if (field != null) {
            fieldsContextNames = new ArrayList<String>();
            fieldsContextNames.addAll(field.getContextNames());
            fieldsContextNames.remove(ALL_FIELDS);
        }
        return fieldsContextNames;
    }

    private static List<FieldDefinition> extractFieldsForField(String fieldName, ClassRepository repository, boolean overrideMappable) {
        FieldDefinition field;
        ArrayList<FieldDefinition> list = new ArrayList();
        if (fieldName == null || (field = repository.getFieldDefinitionByName(fieldName)) == null || !field.isContextField()) {
            list = overrideMappable ? ClassRepositoryHelper.extractVisibleFields(repository) : ClassRepositoryHelper.extractMappableVisibleFields(repository);
        } else {
            List<String> contextNames = ClassRepositoryHelper.extractContextNamesForField(field.getFieldName(), repository);
            if (fieldName.equals(repository.getContextFieldIdentifier())) {
                ClassRepositoryHelper.getValidFieldsForContextScope(list, null, overrideMappable, repository);
            } else if (contextNames != null && !contextNames.isEmpty()) {
                for (String context : contextNames) {
                    ClassRepositoryHelper.getValidFieldsForContextScope(list, context, overrideMappable, repository);
                }
                FieldDefinitionHelper.sortFieldsOnName(list);
            }
        }
        return list;
    }

    private static List<FieldDefinition> extractVisibleFields(ClassRepository repository, FieldFilter filter) {
        ArrayList<FieldDefinition> list = new ArrayList<FieldDefinition>();
        VisibleFieldFilter visibleFieldFilter = new VisibleFieldFilter(repository);
        for (FieldDefinition fd : repository.getFieldDefinitions()) {
            if (!filter.isAllowed(fd) || !visibleFieldFilter.isAllowed(fd)) continue;
            list.add(fd);
        }
        FieldDefinitionHelper.sortFieldsOnName(list);
        return list;
    }

    private static class MappableFieldFilter
    implements FieldFilter {
        private MappableFieldFilter() {
        }

        @Override
        public boolean isAllowed(FieldDefinition field) {
            return field.isAutoConditionMapAllowed();
        }
    }

    private static class AllowAllFieldsFilter
    implements FieldFilter {
        private AllowAllFieldsFilter() {
        }

        @Override
        public boolean isAllowed(FieldDefinition field) {
            return true;
        }
    }

    public static class VisibleHierarchicalFieldFilter
    implements HierarchicalFieldFilter {
        private ClassRepository myRepository;

        public VisibleHierarchicalFieldFilter(ClassRepository repository) {
            this.myRepository = repository;
        }

        @Override
        public boolean isAllowed(FieldHierarchyNode field) {
            boolean isWorkingField = field.isLeaf() ? ClassRepositoryHelper.fieldIsWorkingParameter((FieldDefinition)field) : false;
            return !isWorkingField && ClassRepositoryHelper.fieldIsCommonOrVisibleContextField(field, this.myRepository);
        }
    }

    public static class VisibleFieldFilter
    implements FieldFilter {
        ClassRepository myRepository;

        public VisibleFieldFilter(ClassRepository repository) {
            this.myRepository = repository;
        }

        @Override
        public boolean isAllowed(FieldDefinition field) {
            return ClassRepositoryHelper.fieldIsCommonOrVisibleContextField(field, this.myRepository) && !ClassRepositoryHelper.fieldIsWorkingParameter(field);
        }
    }

    private class ConditionHolder {
        String myName = null;
        String myConditionClassName = null;
        String myConditionProfileName = null;
        boolean mySupportSingleValueAccess = false;
        boolean myIsFieldMappable = false;
        private boolean myIsContextCondition = false;

        ConditionHolder(String name, String className, String profileName) {
            this.myName = name;
            this.myConditionClassName = className;
            this.myConditionProfileName = profileName;
            try {
                Class<?> conditionClass = EreClassLoader.getClass(this.myConditionClassName);
                if (FieldArraySupport.class.isAssignableFrom(conditionClass) || FieldKeyIndexSupport.class.isAssignableFrom(conditionClass) || FieldKeyIndexUser.class.isAssignableFrom(conditionClass)) {
                    this.mySupportSingleValueAccess = true;
                }
                this.myIsFieldMappable = FieldMappable.class.isAssignableFrom(conditionClass);
                this.myIsContextCondition = ContextCondition.class.isAssignableFrom(conditionClass);
            }
            catch (Exception e) {
                this.mySupportSingleValueAccess = false;
                this.myIsFieldMappable = false;
            }
        }

        public boolean isConditionProfileAnnotationPresent(Class<? extends Annotation> annotation) {
            Class<?> conditionClass;
            try {
                conditionClass = EreClassLoader.getClass(this.myConditionProfileName);
            }
            catch (ClassNotFoundException e) {
                return false;
            }
            return conditionClass.isAnnotationPresent(annotation);
        }

        public boolean supportComplexTypeSingleValueAccess() {
            return this.mySupportSingleValueAccess;
        }

        public boolean isFieldMappable() {
            return this.myIsFieldMappable;
        }

        public boolean isContextCondition() {
            return this.myIsContextCondition;
        }

        public String getName() {
            return this.myName;
        }

        public String getClassName() {
            return this.myConditionClassName;
        }

        public String getProfileClassName() {
            return this.myConditionProfileName;
        }
    }

    private static class SpecialFieldDefinition
    extends FieldDefinition {
        private String myTooltip;

        public SpecialFieldDefinition(String name, DataType dataType, String tooltip) {
            super(name, dataType.getTypeIdentifier(), false);
            this.myTooltip = tooltip;
        }

        @Override
        public String getTooltip() {
            return this.myTooltip;
        }
    }
}

