/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.tdfimport.states;

import com.ericsson.ere.gui.wizard.AbstractWizardState;
import com.ericsson.ere.gui.wizard.panels.WizardStateView;
import com.ericsson.ere.selectiontree.tdfimport.TDFImportWizardModel;
import com.ericsson.ere.selectiontree.tdfimport.panels.TDFImportProgressPanel;
import com.ericsson.ere.selectiontree.tdfimport.panels.TDFImportProgressView;
import com.ericsson.ere.swing.EDT;
import ericsson.ere.progress.ProgressIndicator;
import ericsson.ere.progress.ProgressIndicatorHandler;
import ericsson.ere.progress.SynchronizedEDTProgressVisualizer;
import java.util.List;
import javax.swing.SwingWorker;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TDFImportWizardProgressState
extends AbstractWizardState {
    private TDFImportProgressView myPanel;
    private TDFImportWizardModel myModel;
    private SwingWorker<Void, Void> myImportWorker;

    public TDFImportWizardProgressState(TDFImportWizardModel model) {
        super(model);
        this.myModel = model;
        this.myPanel = this.createView();
    }

    protected TDFImportProgressView createView() {
        EDT.runAndWait(new Runnable(){

            @Override
            public void run() {
                TDFImportWizardProgressState.this.myPanel = new TDFImportProgressPanel();
            }
        });
        return this.myPanel;
    }

    @Override
    public void activate() {
        this.doImport();
    }

    private void doImport() {
        final SynchronizedEDTProgressVisualizer visualizer = new SynchronizedEDTProgressVisualizer(this.myPanel);
        ProgressIndicatorHandler progressHandler = new ProgressIndicatorHandler(visualizer);
        final ProgressIndicator progressIndicator = progressHandler.getProgressIndicator();
        this.myPanel.setInfoText("Import started...");
        this.myImportWorker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                Element rootElement = TDFImportWizardProgressState.this.myModel.getTDFElementRoot();
                NodeList tdfElements = rootElement.getElementsByTagName("Field");
                List<String> tdfsToImport = TDFImportWizardProgressState.this.myModel.getSelectedTDFList();
                visualizer.setProgressGoal(tdfsToImport.size());
                progressIndicator.progressStart();
                for (int i = 0; i < tdfElements.getLength(); ++i) {
                    Element aTDF = (Element)tdfElements.item(i);
                    String name = aTDF.getAttribute("Name");
                    if (!tdfsToImport.contains(name)) continue;
                    TDFImportWizardProgressState.this.myModel.addTDFToResultList(name, aTDF);
                    progressIndicator.progressIncrement();
                }
                return null;
            }

            @Override
            protected void done() {
                visualizer.setValue(100);
                visualizer.setInfoText("Import done...");
                progressIndicator.progressFinished();
                TDFImportWizardProgressState.this.myModel.setFinishedNavigationButtonMode();
            }
        };
        this.myImportWorker.execute();
    }

    @Override
    public void cancelStateActions() {
        if (this.myImportWorker != null) {
            this.myImportWorker.cancel(true);
        }
        this.myModel.clearResultingTDFs();
    }

    @Override
    public WizardStateView getPanel() {
        return this.myPanel;
    }
}

