/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.structures;

import com.ericsson.ere.selectiontree.structures.ImmutablePeriodTreeDescription;

public class PeriodTreeDescription {
    protected String myTariffName;
    protected String myTariffId;
    protected String myTariffTypeString;
    protected PeriodTreeVersion myTariffVersion;
    protected String myServiceId;
    protected String myRatingPlan;
    protected String myServiceProvider;
    protected String myRatingPeriod;

    public PeriodTreeDescription(String tariffName, String tariffId, String serviceId) {
        this.myTariffName = tariffName;
        this.myTariffId = tariffId;
        this.myServiceId = serviceId;
    }

    public PeriodTreeDescription(ImmutablePeriodTreeDescription base) {
        if (base == null) {
            throw new IllegalArgumentException("Null argument not permitted.");
        }
        this.myTariffName = base.getTariffName();
        this.myTariffId = base.getTariffId();
        this.myTariffTypeString = base.getTariffTypeString();
        this.myServiceId = base.getServiceId();
        ImmutablePeriodTreeDescription.ImmutablePeriodTreeVersion ver = base.getTariffVersion();
        this.myTariffVersion = ver != null ? new PeriodTreeVersion(ver) : null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.myRatingPeriod == null ? 0 : this.myRatingPeriod.hashCode());
        result = 31 * result + (this.myRatingPlan == null ? 0 : this.myRatingPlan.hashCode());
        result = 31 * result + (this.myServiceId == null ? 0 : this.myServiceId.hashCode());
        result = 31 * result + (this.myServiceProvider == null ? 0 : this.myServiceProvider.hashCode());
        result = 31 * result + (this.myTariffId == null ? 0 : this.myTariffId.hashCode());
        result = 31 * result + (this.myTariffName == null ? 0 : this.myTariffName.hashCode());
        result = 31 * result + (this.myTariffTypeString == null ? 0 : this.myTariffTypeString.hashCode());
        result = 31 * result + (this.myTariffVersion == null ? 0 : this.myTariffVersion.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PeriodTreeDescription other = (PeriodTreeDescription)obj;
        if (this.myRatingPeriod == null ? other.myRatingPeriod != null : !this.myRatingPeriod.equals(other.myRatingPeriod)) {
            return false;
        }
        if (this.myRatingPlan == null ? other.myRatingPlan != null : !this.myRatingPlan.equals(other.myRatingPlan)) {
            return false;
        }
        if (this.myServiceId == null ? other.myServiceId != null : !this.myServiceId.equals(other.myServiceId)) {
            return false;
        }
        if (this.myServiceProvider == null ? other.myServiceProvider != null : !this.myServiceProvider.equals(other.myServiceProvider)) {
            return false;
        }
        if (this.myTariffId == null ? other.myTariffId != null : !this.myTariffId.equals(other.myTariffId)) {
            return false;
        }
        if (this.myTariffName == null ? other.myTariffName != null : !this.myTariffName.equals(other.myTariffName)) {
            return false;
        }
        if (this.myTariffTypeString == null ? other.myTariffTypeString != null : !this.myTariffTypeString.equals(other.myTariffTypeString)) {
            return false;
        }
        return !(this.myTariffVersion == null ? other.myTariffVersion != null : !this.myTariffVersion.equals(other.myTariffVersion));
    }

    public String getTariffName() {
        return this.myTariffName;
    }

    public void setTariffName(String tariffName) {
        this.myTariffName = tariffName;
    }

    public String getTariffId() {
        return this.myTariffId;
    }

    public void setTariffId(String tariffId) {
        this.myTariffId = tariffId;
    }

    public String getTariffTypeString() {
        return this.myTariffTypeString;
    }

    public void setTariffTypeString(String tariffTypeString) {
        this.myTariffTypeString = tariffTypeString;
    }

    public String getServiceId() {
        return this.myServiceId;
    }

    public void setServiceId(String serviceId) {
        this.myServiceId = serviceId;
    }

    public String getRatingPlan() {
        return this.myRatingPlan;
    }

    public void setRatingPlan(String ratingPlan) {
        this.myRatingPlan = ratingPlan;
    }

    public String getServiceProvider() {
        return this.myServiceProvider;
    }

    public void setServiceProvider(String serviceProvider) {
        this.myServiceProvider = serviceProvider;
    }

    public String getRatingPeriod() {
        return this.myRatingPeriod;
    }

    public void setRatingPeriod(String ratingPeriod) {
        this.myRatingPeriod = ratingPeriod;
    }

    public PeriodTreeVersion getTariffVersion() {
        return this.myTariffVersion;
    }

    public void setTariffVersion(String id, Long version, String creationDate, String modificationDate) {
        this.myTariffVersion = new PeriodTreeVersion(id, version, creationDate, modificationDate);
    }

    public String toString() {
        return "PeriodTreeDescription: " + this.myTariffName + ":" + this.myTariffId + ", version: " + this.myTariffVersion;
    }

    public class PeriodTreeVersion {
        public String id;
        public Long version;
        public String creationDate;
        public String modificationDate;

        public PeriodTreeVersion(String id1, Long version1, String creationDate1, String modificationDate1) {
            this.id = id1;
            this.version = version1;
            this.creationDate = creationDate1;
            this.modificationDate = modificationDate1;
        }

        public PeriodTreeVersion(ImmutablePeriodTreeDescription.ImmutablePeriodTreeVersion base) {
            this.id = base.getId();
            this.version = base.getVersion();
            this.creationDate = base.getCreationDate();
            this.modificationDate = base.getModificationDate();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.creationDate == null ? 0 : this.creationDate.hashCode());
            result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
            result = 31 * result + (this.modificationDate == null ? 0 : this.modificationDate.hashCode());
            result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PeriodTreeVersion other = (PeriodTreeVersion)obj;
            if (this.creationDate == null ? other.creationDate != null : !this.creationDate.equals(other.creationDate)) {
                return false;
            }
            if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
                return false;
            }
            if (this.modificationDate == null ? other.modificationDate != null : !this.modificationDate.equals(other.modificationDate)) {
                return false;
            }
            return !(this.version == null ? other.version != null : !this.version.equals(other.version));
        }

        public String toString() {
            return "(Id: " + this.id + "v" + this.version + ", created: " + this.creationDate + ", modified: " + this.modificationDate + ")";
        }
    }
}

