/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.statements;

import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.executor.TreeExecutorHelper;
import com.ericsson.ere.selectiontree.TreeExecutionException;
import com.ericsson.ere.selectiontree.interfaces.Performable;
import com.ericsson.ere.selectiontree.statements.Statement;
import com.ericsson.ere.trace.TraceNodeInterface;
import com.ericsson.ere.trace.TracePoint;
import com.ericsson.ere.trace.TraceableV2;
import ericsson.ere.interfaces.DAGNode;
import ericsson.ere.interfaces.TariffStructureNode;
import ericsson.ere.interfaces.XMLInitializable;

public class LeafStatement
extends Statement
implements TraceableV2 {
    private Performable myModifier;

    public LeafStatement(String name) {
        super(name);
        this.myModifier = null;
    }

    public LeafStatement(String name, Performable mod) {
        super(name);
        this.myModifier = mod;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCodeImpl();
        result = 31 * result + (this.myModifier == null ? 0 : this.myModifier.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !super.equalsImpl(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LeafStatement other = (LeafStatement)obj;
        return !(this.myModifier == null ? other.myModifier != null : !this.myModifier.equals(other.myModifier));
    }

    public void setModifier(Performable m) throws IllegalArgumentException {
        if (m != null && this.myModifier != null) {
            throw new IllegalArgumentException("Modifier already added to LeafStatement");
        }
        this.myModifier = m;
    }

    public Performable getModifier() {
        return this.myModifier;
    }

    @Override
    public DAGNode getChildAt(int index) throws IndexOutOfBoundsException {
        if (index == 0) {
            return (DAGNode)((Object)this.myModifier);
        }
        throw new IndexOutOfBoundsException("Invalid index: " + index);
    }

    @Override
    public int getChildCount() {
        if (this.myModifier != null) {
            return 1;
        }
        return 0;
    }

    @Override
    public void replace(DAGNode child, DAGNode replacement) {
        if (child != this.myModifier) {
            throw new IllegalArgumentException("Child not found: " + child);
        }
        this.myModifier = (Performable)((Object)replacement);
    }

    @Override
    public void insertChildAt(int index, DAGNode node) throws IllegalArgumentException {
        throw new IllegalArgumentException("LeafStatement cannot hold DAGNode");
    }

    @Override
    public void insertLinkAt(int index, DAGNode node) throws IllegalArgumentException {
        throw new IllegalArgumentException("LeafStatement cannot hold DAGNode");
    }

    @Override
    public void add(XMLInitializable node) throws IllegalArgumentException {
        throw new IllegalArgumentException("LeafStatement cannot hold XMLInitializable");
    }

    @Override
    protected void removeChild(DAGNode node) throws IllegalArgumentException {
        throw new IllegalArgumentException("Node not removed, structure is read-only");
    }

    @Override
    protected void removeLink(DAGNode node) throws IllegalArgumentException {
        throw new IllegalArgumentException("Node not removed, structure is read-only");
    }

    @Override
    public void execute(DataSet theData) {
        TreeExecutorHelper.performPerformable(this.myModifier, theData);
        theData.modifierExecuted();
    }

    @Override
    public TariffStructureNode createTraceNode(int childIndex, TraceNodeInterface parent) {
        try {
            LeafStatement clone = (LeafStatement)this.clone();
            clone.myModifier = null;
            clone.setModifier((Performable)((Object)this.myModifier.createTraceNode(childIndex, parent)));
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new TreeExecutionException(e);
        }
    }

    @Override
    public void setPreTracePointInfo(TracePoint tp) {
    }
}

