/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.statements;

import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.executor.TreeExecutorHelper;
import com.ericsson.ere.selectiontree.ParseContext;
import com.ericsson.ere.selectiontree.TreeExecutionException;
import com.ericsson.ere.selectiontree.conditions.ConditionTestResult;
import com.ericsson.ere.selectiontree.interfaces.Conditionality;
import com.ericsson.ere.selectiontree.interfaces.ExecutableNode;
import com.ericsson.ere.selectiontree.interfaces.Performable;
import com.ericsson.ere.selectiontree.interfaces.ResultConditionality;
import com.ericsson.ere.selectiontree.statements.LeafStatement;
import com.ericsson.ere.trace.TraceNodeInterface;
import com.ericsson.ere.trace.TraceNodeStatement;
import com.ericsson.ere.trace.TracePoint;
import com.ericsson.ere.trace.Traceable;
import ericsson.ere.interfaces.AbstractDAGNode;
import ericsson.ere.interfaces.DAGNode;
import ericsson.ere.interfaces.DAGUtil;
import ericsson.ere.interfaces.TariffStructureNode;
import ericsson.ere.interfaces.TariffStructureVisitor;
import ericsson.ere.interfaces.UsedFieldLister;
import ericsson.ere.xml.XMLUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public abstract class ImmutableStatement
extends AbstractDAGNode
implements TariffStructureNode,
ExecutableNode,
Traceable,
Cloneable,
UsedFieldLister {
    private static final Conditionality[] NO_CONDITIONS = new Conditionality[0];
    private static final ExecutableNode[] NO_NODES = new ExecutableNode[0];
    protected final String myName;
    protected final String myNodeId;
    protected Conditionality[] myConditionArray;
    protected ExecutableNode[] myChildrenArray;
    private int myHashCodeCache;

    protected ImmutableStatement(ParseContext ctx, TariffStructureNode[] children) {
        Node node;
        String name;
        if (ctx == null) {
            this.myName = null;
            this.myNodeId = null;
            this.myConditionArray = children == null ? NO_CONDITIONS : ImmutableStatement.getConditions(children);
            this.myChildrenArray = children == null ? NO_NODES : ImmutableStatement.getExecutables(null, children, this.myConditionArray);
            this.myHashCodeCache = this.internalHashCode();
            return;
        }
        Node iterator = ctx.getXMLNode();
        this.myName = name = XMLUtil.getFirstTextContent(iterator);
        String id = null;
        NamedNodeMap attr = null;
        if (iterator.hasAttributes()) {
            attr = iterator.getAttributes();
        }
        if (attr != null && (node = attr.getNamedItem("id")) != null) {
            id = node.getNodeValue().trim().replace('/', '\\');
        }
        this.myNodeId = id;
        if (children != null) {
            for (TariffStructureNode n : children) {
                n.setParent(this);
            }
        }
        this.myConditionArray = ImmutableStatement.getConditions(children);
        this.myChildrenArray = ImmutableStatement.getExecutables(name, children, this.myConditionArray);
        this.myHashCodeCache = this.internalHashCode();
    }

    protected ImmutableStatement(String name, String id, TariffStructureNode[] children) {
        this.myName = name;
        this.myNodeId = id;
        if (children != null) {
            for (TariffStructureNode n : children) {
                n.setParent(this);
            }
        }
        this.myConditionArray = ImmutableStatement.getConditions(children);
        this.myChildrenArray = ImmutableStatement.getExecutables(name, children, this.myConditionArray);
        this.myHashCodeCache = this.internalHashCode();
    }

    protected ImmutableStatement(String name, String id, Conditionality[] conditions, ExecutableNode[] nodes) {
        this.myName = name;
        this.myNodeId = id;
        if (conditions != null) {
            for (Traceable traceable : conditions) {
                ((TariffStructureNode)((Object)traceable)).setParent(this);
            }
        }
        this.myConditionArray = conditions;
        if (nodes != null) {
            for (Traceable traceable : nodes) {
                ((TariffStructureNode)((Object)traceable)).setParent(this);
            }
        }
        this.myChildrenArray = nodes;
        this.myHashCodeCache = this.internalHashCode();
    }

    private int internalHashCode() {
        int prime = 31;
        int result = super.hashCodeImpl();
        result = 31 * result + Arrays.hashCode(this.myChildrenArray);
        result = 31 * result + Arrays.hashCode(this.myConditionArray);
        result = 31 * result + (this.myName == null ? 0 : this.myName.hashCode());
        result = 31 * result + (this.myNodeId == null ? 0 : this.myNodeId.hashCode());
        return result;
    }

    @Override
    public int hashCodeImpl() {
        return this.myHashCodeCache;
    }

    @Override
    public boolean equalsImpl(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !super.equalsImpl(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImmutableStatement other = (ImmutableStatement)obj;
        if (this.myHashCodeCache != other.myHashCodeCache) {
            return false;
        }
        if (!Arrays.equals(this.myChildrenArray, other.myChildrenArray)) {
            return false;
        }
        if (!Arrays.equals(this.myConditionArray, other.myConditionArray)) {
            return false;
        }
        if (this.myName == null ? other.myName != null : !this.myName.equals(other.myName)) {
            return false;
        }
        return !(this.myNodeId == null ? other.myNodeId != null : !this.myNodeId.equals(other.myNodeId));
    }

    @Override
    public abstract void execute(DataSet var1);

    @Override
    public abstract String describeTrace(TracePoint var1);

    @Override
    public abstract void setTracePointInfo(TracePoint var1);

    protected static ExecutableNode[] getExecutables(String name, TariffStructureNode[] children) {
        int nitems = 0;
        for (TariffStructureNode n : children) {
            if (n instanceof ExecutableNode || n instanceof Performable) {
                ++nitems;
            }
            if (n instanceof Traceable) continue;
            throw new IllegalArgumentException("Children of ImmutableStatement needs to be Traceable too");
        }
        if (nitems == 0) {
            return NO_NODES;
        }
        ExecutableNode[] retVal = new ExecutableNode[nitems];
        int i = 0;
        for (TariffStructureNode n : children) {
            if (n instanceof ExecutableNode) {
                retVal[i++] = (ExecutableNode)((Object)n);
                continue;
            }
            if (!(n instanceof Performable)) continue;
            retVal[i++] = new LeafStatement(name, (Performable)((Object)n));
        }
        return retVal;
    }

    protected static ExecutableNode[] getExecutables(String name, TariffStructureNode[] children, Conditionality[] conditions) {
        int first;
        int nitems;
        if (conditions.length == children.length) {
            return NO_NODES;
        }
        int condLen = conditions.length;
        if (condLen == 0) {
            nitems = children.length;
            first = 0;
        } else if (conditions[condLen - 1] == children[condLen - 1]) {
            nitems = children.length - condLen;
            first = condLen;
        } else {
            first = -1;
            nitems = 0;
            int len = children.length;
            for (int i = 0; i < len; ++i) {
                TariffStructureNode n = children[i];
                if (!(n instanceof ExecutableNode) && !(n instanceof Performable)) continue;
                ++nitems;
                if (first >= 0) continue;
                first = i;
            }
        }
        if (nitems == 0) {
            return NO_NODES;
        }
        ExecutableNode[] retVal = new ExecutableNode[nitems];
        int i = 0;
        int len = children.length;
        for (int j = first; j < len; ++j) {
            TariffStructureNode n = children[j];
            if (n instanceof ExecutableNode) {
                retVal[i++] = (ExecutableNode)((Object)n);
                continue;
            }
            if (!(n instanceof Performable)) continue;
            retVal[i++] = new LeafStatement(name, (Performable)((Object)n));
        }
        if (i < nitems) {
            ExecutableNode[] temp = retVal;
            retVal = new ExecutableNode[i];
            System.arraycopy(temp, 0, retVal, 0, i);
        }
        return retVal;
    }

    protected static Conditionality[] getConditions(TariffStructureNode[] children) {
        int nitems = 0;
        int last = -1;
        int len = children.length;
        for (int i = 0; i < len; ++i) {
            TariffStructureNode n = children[i];
            if (!(n instanceof Conditionality)) continue;
            ++nitems;
            last = i;
        }
        if (nitems == 0) {
            return NO_CONDITIONS;
        }
        Conditionality[] retVal = new Conditionality[nitems];
        int i = 0;
        for (int j = 0; j <= last; ++j) {
            TariffStructureNode n = children[j];
            if (!(n instanceof Conditionality)) continue;
            retVal[i++] = (Conditionality)((Object)n);
        }
        return retVal;
    }

    @Override
    public DAGNode getChildAt(int index) throws IndexOutOfBoundsException {
        int nCond = 0;
        if (this.myConditionArray != null && index < (nCond = this.myConditionArray.length)) {
            return (DAGNode)((Object)this.myConditionArray[index]);
        }
        DAGNode node = (DAGNode)((Object)this.myChildrenArray[index - nCond]);
        if (node instanceof LeafStatement) {
            node = node.getChildAt(0);
        }
        return node;
    }

    @Override
    public int getChildCount() {
        int nCond = this.myConditionArray == null ? 0 : this.myConditionArray.length;
        int nChild = this.myChildrenArray == null ? 0 : this.myChildrenArray.length;
        return nCond + nChild;
    }

    @Override
    public final void insertChildAt(int index, DAGNode node) {
        throw new IndexOutOfBoundsException("Condition is immutable, not allowed to add children");
    }

    @Override
    public final void insertLinkAt(int index, DAGNode node) {
        throw new IndexOutOfBoundsException("Condition is immutable, not allowed to add children");
    }

    @Override
    protected final void removeChild(DAGNode node) {
        throw new IllegalArgumentException("Node not removed, structure is read-only");
    }

    @Override
    protected final void removeLink(DAGNode node) {
        throw new IllegalArgumentException("Node not removed, structure is read-only");
    }

    @Override
    public void endVisit(TariffStructureVisitor v) throws Exception {
        v.leaveNode(this);
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public String getNodeId() {
        String id = this.myNodeId;
        if (id == null || "".equals(id.trim())) {
            id = this.myName;
        }
        id = id.replace('/', '\\');
        return id;
    }

    @Override
    public int getNodeType() {
        return 1;
    }

    @Override
    public boolean isLink() {
        return false;
    }

    @Override
    public void startVisit(TariffStructureVisitor v) throws Exception {
        v.enterNode(this);
    }

    @Override
    public void replace(DAGNode child, DAGNode replacement) {
        int i = -1;
        if (this.myConditionArray != null) {
            i = DAGUtil.indexOf(child, Arrays.asList(this.myConditionArray));
        }
        if (i >= 0) {
            this.myConditionArray[i] = (Conditionality)((Object)replacement);
        } else {
            i = DAGUtil.indexOf(child, Arrays.asList(this.myChildrenArray));
            if (i >= 0) {
                this.myChildrenArray[i] = (ExecutableNode)((Object)replacement);
            } else {
                for (ExecutableNode n : this.myChildrenArray) {
                    LeafStatement stmt;
                    if (!(n instanceof LeafStatement) || (stmt = (LeafStatement)n).getModifier() != child) continue;
                    stmt.replace(child, replacement);
                }
            }
        }
    }

    @Override
    public TariffStructureNode createTraceNode(int childIndex, TraceNodeInterface parent) {
        try {
            TariffStructureNode tni;
            int i;
            ImmutableStatement clone = (ImmutableStatement)this.clone();
            TraceNodeStatement tns = new TraceNodeStatement(clone);
            tns.setParent(parent);
            parent.addChild(tns);
            tns.setChildIndex(childIndex);
            clone.myChildrenArray = this.myChildrenArray == null ? null : new ExecutableNode[this.myChildrenArray.length];
            clone.myConditionArray = this.myConditionArray == null ? null : new Conditionality[this.myConditionArray.length];
            for (i = 0; this.myConditionArray != null && i < this.myConditionArray.length; ++i) {
                tni = this.myConditionArray[i].createTraceNode(i, tns);
                clone.myConditionArray[i] = (Conditionality)((Object)tni);
            }
            for (i = 0; this.myChildrenArray != null && i < this.myChildrenArray.length; ++i) {
                tni = this.myChildrenArray[i].createTraceNode(i, tns);
                clone.myChildrenArray[i] = (ExecutableNode)((Object)tni);
            }
            clone.myHashCodeCache = clone.internalHashCode();
            return tns;
        }
        catch (CloneNotSupportedException e) {
            throw new TreeExecutionException(e);
        }
    }

    private final void performChildUsingExecutor(Performable child, DataSet dataSet) {
        TreeExecutorHelper.performPerformable(child, dataSet);
        dataSet.modifierExecuted();
    }

    protected final void executeChildUsingExecutor(ExecutableNode child, DataSet dataSet) {
        if (child instanceof LeafStatement) {
            this.performChildUsingExecutor(((LeafStatement)child).getModifier(), dataSet);
        } else if (child instanceof Performable) {
            this.performChildUsingExecutor((Performable)((Object)child), dataSet);
        } else {
            TreeExecutorHelper.executeExecutableNode(child, dataSet);
        }
    }

    protected final boolean testConditionUsingExecutor(Conditionality condition, DataSet dataSet) {
        return TreeExecutorHelper.testCondition(condition, dataSet);
    }

    protected final ConditionTestResult testConditionUsingExecutor(ResultConditionality condition, DataSet dataSet) {
        return TreeExecutorHelper.testCondition(condition, dataSet);
    }

    @Override
    public Set<String> getUsedFields() {
        return new HashSet<String>();
    }
}

