/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.modifiers.operation.strategy;

import com.ericsson.ere.math.RatingDecimal;
import com.ericsson.ere.selectiontree.modifiers.operation.strategy.RangeStrategy;
import ericsson.ere.datatype.DataType;
import java.math.BigInteger;

public class TruncateStrategy
extends RangeStrategy {
    @Override
    public Number calculateResult(BigInteger proposedResult, BigInteger max, BigInteger min, DataType targetType) {
        if (max == null && min == null) {
            max = (BigInteger)targetType.getMaximumValue();
            min = (BigInteger)targetType.getMinimumValue();
        }
        if (max != null && proposedResult.compareTo(max) == 1) {
            return max;
        }
        if (min != null && proposedResult.compareTo(min) == -1) {
            return min;
        }
        return proposedResult;
    }

    @Override
    public RatingDecimal calculateResult(RatingDecimal proposedResult, RatingDecimal max, RatingDecimal min, DataType targetType) {
        if (max == null && min == null) {
            if (this.isTargetTypeIsNullOrRatingDecimal(targetType)) {
                return proposedResult;
            }
            max = new RatingDecimal(targetType.getMaximumValue().toString());
            min = new RatingDecimal(targetType.getMinimumValue().toString());
        }
        if (max != null && proposedResult.compareTo(max) == 1) {
            return max;
        }
        if (min != null && proposedResult.compareTo(min) == -1) {
            return min;
        }
        return proposedResult;
    }

    private boolean isTargetTypeIsNullOrRatingDecimal(DataType targetType) {
        return targetType == null || targetType == DataType.RATINGDECIMAL;
    }
}

