/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.modifiers.operation;

import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.datatype.ERETime;
import com.ericsson.ere.datatype.ERETimeFactory;
import com.ericsson.ere.datatype.ERETimeUtil;
import com.ericsson.ere.datatype.ValueResolver;
import com.ericsson.ere.selectiontree.modifiers.operation.AbstractOperation;
import com.ericsson.ere.selectiontree.modifiers.operation.TimeOperation;
import ericsson.ere.datatype.DataType;
import ericsson.ere.datatype.Time;
import ericsson.ere.defs.FieldDefinition;
import java.util.Set;

public class TimeFieldOperation
extends AbstractOperation<ERETime, Object> {
    TimeOperation myOperation = TimeOperation.SET;
    private static final String LBL_ADDITIONAL_DATA = "Unit";
    private int mySelectedUnit = TimeOperation.DEFAULT_UNIT_IDENTIFIER;

    @Override
    protected boolean needsAffectedFieldValueForOperation() {
        return this.myOperation != TimeOperation.SET;
    }

    @Override
    protected Long fetchSpecialOperandValue(DataSet dataSet) {
        Long value = null;
        if (this.myOperandField != null) {
            if ("CurrentTime()".equals(this.myOperandField.getFieldName())) {
                value = dataSet.getCurrentTime().getTimeInMillis();
            } else if ("StartTime()".equals(this.myOperandField.getFieldName())) {
                value = dataSet.getStartTime().getTimeInMillis();
            }
        }
        return value;
    }

    @Override
    protected Object prepareOperandValue(Object value, DataSet dataSet) {
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (ERETimeUtil.isBoundaryDate(value) || value instanceof ERETime) {
            return value;
        }
        ERETime time = ERETimeUtil.convertToERETime(value);
        return time.getMillisecondsSinceEpoch();
    }

    @Override
    protected Object parseOperandValueString(ValueResolver resolver, String valueString) {
        Object ret;
        try {
            ret = Long.parseLong(valueString);
        }
        catch (NumberFormatException e) {
            ret = super.parseOperandValueString(resolver, valueString);
        }
        return ret;
    }

    @Override
    protected ERETime perform(ERETime operand1, Object operand2, DataSet data) {
        ERETime result = operand2 instanceof ERETime ? this.myOperation.performTime(operand1, (ERETime)operand2, this.mySelectedUnit) : this.myOperation.performTime(operand1, (Long)operand2, this.mySelectedUnit);
        return result;
    }

    @Override
    public String[] getOperationNames() {
        return TimeOperation.getOperationNames();
    }

    @Override
    public void setOperation(String operation) {
        this.myOperation = TimeOperation.getOperation(operation);
    }

    @Override
    public String getOperation() {
        return this.myOperation.toString();
    }

    @Override
    protected boolean isDataTypeSupported(DataType dataType) {
        boolean support = this.myOperation.equals((Object)TimeOperation.SET) ? dataType == DataType.TIME || dataType == DataType.DATE : dataType == DataType.SHORT || dataType == DataType.INTEGER || dataType == DataType.LONG;
        return support;
    }

    public String[] getUnitArray() {
        return TimeOperation.getSupportedUnits();
    }

    public String getSelectedUnit(String selectedUnitCandidate) {
        int unitIdentifier = TimeOperation.getUnitIdentifierForString(selectedUnitCandidate);
        return TimeOperation.getUnitStringForIdentifier(unitIdentifier);
    }

    @Override
    public String getAdditionalDataLabel() {
        return LBL_ADDITIONAL_DATA;
    }

    @Override
    public void setAdditionalData(String data) {
        this.mySelectedUnit = TimeOperation.getUnitIdentifierForString(data);
    }

    @Override
    public boolean useAdditionalData() {
        return true;
    }

    @Override
    public String makeDisplayableStringFromOperandValueObject(Object valueObject, FieldDefinition fd) {
        Object timeObject = null;
        switch (this.myOperation) {
            case SET: {
                if (valueObject instanceof String) {
                    timeObject = DataType.TIME.parseValue((String)valueObject);
                    break;
                }
                if (valueObject instanceof Long) {
                    long msecs = (Long)valueObject;
                    timeObject = ERETimeFactory.createFromMillisecondsSinceEpoch(msecs);
                    break;
                }
                if (!(valueObject instanceof Time)) break;
                timeObject = valueObject;
                break;
            }
        }
        Object actual = timeObject != null ? timeObject : valueObject;
        return super.makeDisplayableStringFromOperandValueObject(actual, fd);
    }

    @Override
    public String getAdditionalInformationString() {
        switch (this.myOperation) {
            case ADD: 
            case SUBTRACT: {
                return " " + TimeOperation.getUnitStringForIdentifier(this.mySelectedUnit);
            }
        }
        return super.getAdditionalInformationString();
    }

    @Override
    public String makeDisplayableStringFromAffectedFieldValueObject(Object valueObject, FieldDefinition fd) {
        return super.makeDisplayableStringFromAffectedFieldValueObject(valueObject, fd);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.myOperation == null ? 0 : this.myOperation.hashCode());
        result = 31 * result + this.mySelectedUnit;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimeFieldOperation other = (TimeFieldOperation)obj;
        if (this.myOperation == null ? other.myOperation != null : !this.myOperation.equals((Object)other.myOperation)) {
            return false;
        }
        return this.mySelectedUnit == other.mySelectedUnit;
    }

    @Override
    public Set<String> getUsedFields() {
        Set<String> usedFields = super.getUsedFields();
        usedFields.remove("CurrentTime()");
        usedFields.remove("StartTime()");
        return usedFields;
    }
}

