/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.modifiers.operation;

import com.ericsson.ere.selectiontree.modifiers.operation.AmountFieldOperation;
import com.ericsson.ere.selectiontree.modifiers.operation.BooleanFieldOperation;
import com.ericsson.ere.selectiontree.modifiers.operation.DateFieldOperation;
import com.ericsson.ere.selectiontree.modifiers.operation.DateOperation;
import com.ericsson.ere.selectiontree.modifiers.operation.IntegerFieldOperation;
import com.ericsson.ere.selectiontree.modifiers.operation.LongFieldOperation;
import com.ericsson.ere.selectiontree.modifiers.operation.Operation;
import com.ericsson.ere.selectiontree.modifiers.operation.RatingDecimalFieldOperation;
import com.ericsson.ere.selectiontree.modifiers.operation.ShortFieldOperation;
import com.ericsson.ere.selectiontree.modifiers.operation.StringFieldOperation;
import com.ericsson.ere.selectiontree.modifiers.operation.TimeFieldOperation;
import com.ericsson.ere.selectiontree.modifiers.operation.TimeOperation;
import com.ericsson.ere.selectiontree.modifiers.operation.UIntegerFieldOperation;
import com.ericsson.ere.selectiontree.modifiers.operation.UnsignedInt16FieldOperation;
import com.ericsson.ere.selectiontree.modifiers.operation.UnsignedInt32FieldOperation;
import com.ericsson.ere.selectiontree.modifiers.operation.UnsignedInt8FieldOperation;
import com.ericsson.ere.selectiontree.modifiers.operation.UnsignedLongFieldOperation;
import com.ericsson.ere.selectiontree.modifiers.operation.UnsignedShortFieldOperation;
import com.ericsson.ere.selectiontree.util.FieldOrientedPluginProfileUtil;
import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.FieldDefinition;
import ericsson.vareditor.variable.AmountVariable;
import ericsson.vareditor.variable.BaseVariable;
import ericsson.vareditor.variable.BoolVariable;
import ericsson.vareditor.variable.DateAndTimeVariable;
import ericsson.vareditor.variable.DropDownVariable;
import ericsson.vareditor.variable.IntegerVariable;
import ericsson.vareditor.variable.LongVariable;
import ericsson.vareditor.variable.NotAllowedVariable;
import ericsson.vareditor.variable.RatingDecimalVariable;
import ericsson.vareditor.variable.ShortVariable;
import ericsson.vareditor.variable.StringVariable;
import ericsson.vareditor.variable.UIntegerVariable;
import ericsson.vareditor.variable.ULongVariable;
import ericsson.vareditor.variable.UShortVariable;
import ericsson.vareditor.variable.UnsignedInt16Variable;
import ericsson.vareditor.variable.UnsignedInt32Variable;
import ericsson.vareditor.variable.UnsignedInt8Variable;
import ericsson.vareditor.variable.Variable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class OperationProfileHelper {
    public static List<Variable> getEnumVariableForStaticOperation(String label, String value, String[] enumNames, String[] enumValues) {
        ArrayList<Variable> l = new ArrayList<Variable>();
        l.add(new DropDownVariable(label, enumNames, enumValues, (Object)(value != null ? value : enumValues[0])));
        return l;
    }

    public static List<Variable> getVariablesForStaticOperation(Operation<?, ?> operation, String label, String value, String additionalData, String min, String max) {
        ArrayList<Variable> l = new ArrayList<Variable>();
        if (operation instanceof LongFieldOperation) {
            if (min != null && max != null) {
                try {
                    l.add(new LongVariable(label, value == null || value.equals("") ? "0" : value, Long.parseLong(min), Long.parseLong(max)));
                }
                catch (NumberFormatException e) {
                    l.add(new LongVariable(label, value == null || value.equals("") ? "0" : value));
                }
            } else {
                l.add(new LongVariable(label, value == null || value.equals("") ? "0" : value));
            }
        } else if (operation instanceof IntegerFieldOperation) {
            if (min != null && max != null) {
                try {
                    l.add(new IntegerVariable(label, value == null || value.equals("") ? "0" : value, Integer.parseInt(min), Integer.parseInt(max)));
                }
                catch (NumberFormatException e) {
                    l.add(new IntegerVariable(label, value == null || value.equals("") ? "0" : value));
                }
            } else {
                l.add(new IntegerVariable(label, value == null || value.equals("") ? "0" : value));
            }
        } else if (operation instanceof RatingDecimalFieldOperation) {
            l.add(new RatingDecimalVariable(label, value == null || value.equals("") ? "0" : value));
        } else if (operation instanceof ShortFieldOperation) {
            if (min != null && max != null) {
                try {
                    l.add(new ShortVariable(label, value == null || value.equals("") ? "0" : value, (int)Short.parseShort(min), (int)Short.parseShort(max)));
                }
                catch (NumberFormatException e) {
                    l.add(new ShortVariable(label, value == null || value.equals("") ? "0" : value));
                }
            } else {
                l.add(new ShortVariable(label, value == null || value.equals("") ? "0" : value));
            }
        } else if (operation instanceof UIntegerFieldOperation) {
            if (min != null && max != null) {
                try {
                    l.add(new UIntegerVariable(label, value == null || value.equals("") ? "0" : value, new BigInteger(DataType.UIntegerParser(Integer.valueOf(min))), new BigInteger(DataType.UIntegerParser(Integer.valueOf(max)))));
                }
                catch (NumberFormatException e) {
                    l.add(new UIntegerVariable(label, value == null || value.equals("") ? "0" : value));
                }
            } else {
                l.add(new UIntegerVariable(label, value == null || value.equals("") ? "0" : value));
            }
        } else if (operation instanceof UnsignedInt32FieldOperation) {
            if (min != null && max != null) {
                try {
                    l.add(new UnsignedInt32Variable(label, value == null || value.equals("") ? "0" : value, (long)new Long(min), (long)new Long(max)));
                }
                catch (NumberFormatException e) {
                    l.add(new UnsignedInt32Variable(label, value == null || value.equals("") ? "0" : value));
                }
            } else {
                l.add(new UnsignedInt32Variable(label, value == null || value.equals("") ? "0" : value));
            }
        } else if (operation instanceof UnsignedInt16FieldOperation) {
            if (min != null && max != null) {
                try {
                    l.add(new UnsignedInt16Variable(label, value == null || value.equals("") ? "0" : value, (int)Integer.valueOf(min), (int)Integer.valueOf(max)));
                }
                catch (NumberFormatException e) {
                    l.add(new UnsignedInt16Variable(label, value == null || value.equals("") ? "0" : value));
                }
            } else {
                l.add(new UnsignedInt16Variable(label, value == null || value.equals("") ? "0" : value));
            }
        } else if (operation instanceof UnsignedInt8FieldOperation) {
            if (min != null && max != null) {
                try {
                    l.add(new UnsignedInt8Variable(label, value == null || value.equals("") ? "0" : value, (int)Integer.valueOf(min), (int)Integer.valueOf(max)));
                }
                catch (NumberFormatException e) {
                    l.add(new UnsignedInt8Variable(label, value == null || value.equals("") ? "0" : value));
                }
            } else {
                l.add(new UnsignedInt8Variable(label, value == null || value.equals("") ? "0" : value));
            }
        } else if (operation instanceof UnsignedShortFieldOperation) {
            if (min != null && max != null) {
                try {
                    l.add(new UShortVariable(label, value == null || value.equals("") ? "0" : value, new BigInteger(DataType.UIntegerParser(Integer.valueOf(min))), new BigInteger(DataType.UIntegerParser(Integer.valueOf(max)))));
                }
                catch (NumberFormatException e) {
                    l.add(new UShortVariable(label, value == null || value.equals("") ? "0" : value));
                }
            } else {
                l.add(new UShortVariable(label, value == null || value.equals("") ? "0" : value));
            }
        } else if (operation instanceof UnsignedLongFieldOperation) {
            if (min != null && max != null) {
                try {
                    l.add(new ULongVariable(label, value == null || value.equals("") ? "0" : value, new BigInteger(DataType.UIntegerParser(Integer.valueOf(min))), new BigInteger(DataType.UIntegerParser(Integer.valueOf(max)))));
                }
                catch (NumberFormatException e) {
                    l.add(new ULongVariable(label, value == null || value.equals("") ? "0" : value));
                }
            } else {
                l.add(new ULongVariable(label, value == null || value.equals("") ? "0" : value));
            }
        } else if (operation instanceof StringFieldOperation) {
            l.add(new StringVariable(label, value == null ? "" : value));
        } else if (operation instanceof DateFieldOperation) {
            if (operation.getOperation().equals(DateOperation.SET.name())) {
                if (value != null && !value.isEmpty()) {
                    l.add(new DateAndTimeVariable(label, DateAndTimeVariable.Content.DATE, value));
                } else {
                    l.add(new DateAndTimeVariable(label, DateAndTimeVariable.Content.DATE));
                }
            } else {
                Object[] unitArray = ((DateFieldOperation)operation).getUnitArray();
                String defaultUnit = ((DateFieldOperation)operation).getSelectedUnit(additionalData);
                l.add(new DropDownVariable(operation.getAdditionalDataLabel(), (Object)defaultUnit, unitArray));
                if (value == null || value.equals("") || value.contains("T")) {
                    l.add(new LongVariable(label, "0"));
                } else {
                    l.add(new LongVariable(label, value));
                }
            }
        } else if (operation instanceof TimeFieldOperation) {
            if (operation.getOperation().equals((Object)((Object)TimeOperation.SET) + "")) {
                if (value != null && !value.isEmpty()) {
                    l.add(new DateAndTimeVariable(label, DateAndTimeVariable.Content.DATE_TIME, value));
                } else {
                    l.add(new DateAndTimeVariable(label, DateAndTimeVariable.Content.DATE_TIME));
                }
            } else {
                Object[] unitArray = ((TimeFieldOperation)operation).getUnitArray();
                String defaultUnit = ((TimeFieldOperation)operation).getSelectedUnit(additionalData);
                l.add(new DropDownVariable(operation.getAdditionalDataLabel(), (Object)defaultUnit, unitArray));
                if (value == null || value.equals("") || value.contains("T")) {
                    l.add(new LongVariable(label, "0"));
                } else {
                    l.add(new LongVariable(label, value));
                }
            }
        } else if (operation instanceof AmountFieldOperation) {
            if (value != null) {
                l.add(new AmountVariable(label, value, false));
            } else {
                l.add(new AmountVariable(label, false));
            }
        } else if (operation instanceof BooleanFieldOperation) {
            if (value != null) {
                l.add(new BoolVariable(label, Boolean.valueOf(value)));
            } else {
                l.add(new BoolVariable(label, false));
            }
        } else {
            throw new IllegalArgumentException("operation " + operation + " is NOT supported");
        }
        return l;
    }

    public static List<Variable> getVariablesForFieldOperation(Operation<?, ?> operation, String label, String selectedFieldCandidate, List<FieldDefinition> fieldList, String additionalData) {
        ArrayList<Variable> l = new ArrayList<Variable>();
        if (operation instanceof DateFieldOperation) {
            if (!operation.getOperation().equals(DateOperation.SET.name())) {
                Object[] unitArray = ((DateFieldOperation)operation).getUnitArray();
                String defaultUnit = ((DateFieldOperation)operation).getSelectedUnit(additionalData);
                l.add(new DropDownVariable(operation.getAdditionalDataLabel(), (Object)defaultUnit, unitArray));
            }
        } else if (operation instanceof TimeFieldOperation && !operation.getOperation().equals(TimeOperation.SET.name())) {
            Object[] unitArray = ((TimeFieldOperation)operation).getUnitArray();
            String defaultUnit = ((TimeFieldOperation)operation).getSelectedUnit(additionalData);
            l.add(new DropDownVariable(operation.getAdditionalDataLabel(), (Object)defaultUnit, unitArray));
        }
        l.add(OperationProfileHelper.createOperandFieldVariable("Operand field", selectedFieldCandidate, fieldList));
        return l;
    }

    private static Variable createOperandFieldVariable(String label, String defaultFieldName, List<FieldDefinition> fieldList) {
        BaseVariable variable = fieldList.isEmpty() ? new NotAllowedVariable(label, "Matching field NOT found") : FieldOrientedPluginProfileUtil.createFilterableFieldListVariable(label, label, fieldList, defaultFieldName);
        return variable;
    }
}

