/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.modifiers.mfo;

import com.ericsson.ere.dataset.DataSetField;
import com.ericsson.ere.expression.ExpressionException;
import com.ericsson.ere.expression.FieldValueOperand;
import com.ericsson.ere.expression.Operand;
import com.ericsson.ere.expression.ValueOperand;
import com.ericsson.ere.math.RatingDecimal;
import com.ericsson.ere.selectiontree.modifiers.DataSetValueReader;
import com.ericsson.ere.selectiontree.modifiers.DefaultDataSetValueReader;
import com.ericsson.ere.selectiontree.modifiers.mfo.AbstractExpressionXMLReader;
import com.ericsson.ere.selectiontree.modifiers.mfo.DataSetTimeOperand;
import com.ericsson.ere.selectiontree.util.FieldIndexKeyContainer;
import com.ericsson.ere.selectiontree.util.FieldOrientedPluginUtil;
import com.ericsson.ere.selectiontree.util.ValueFieldCompositeObject;
import ericsson.ere.datatype.AmountStub;
import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.interfaces.FieldHierarchyNode;
import ericsson.ere.util.StringUtil;
import org.w3c.dom.Element;

public class TrafficExpressionXMLReader
extends AbstractExpressionXMLReader {
    private static final String START_TIME = "StartTime()";
    private static final String CURRENT_TIME = "CurrentTime()";
    private static final String RE_NUMERIC = "\\d*(\\.\\d+)?";
    private final ClassRepository myRepository;
    private final DataSetValueReader myReader;

    public TrafficExpressionXMLReader(ClassRepository classRep) {
        this(classRep, DefaultDataSetValueReader.INSTANCE);
    }

    public TrafficExpressionXMLReader(ClassRepository classRep, DataSetValueReader reader) {
        this.myRepository = classRep;
        this.myReader = reader;
    }

    @Override
    protected Operand readOperand(Element operandValue, Element operandIndex) {
        ValueFieldCompositeObject valueObject = new ValueFieldCompositeObject(this.getFirstChildElement(operandValue));
        if (operandIndex != null) {
            boolean valueIsField = valueObject.getMode() == ValueFieldCompositeObject.Mode.Field;
            String fieldName = valueObject.getFieldOrValueAsString();
            if (!valueIsField) {
                throw new ExpressionException("Found index specification for non-field: " + fieldName);
            }
            FieldDefinition fd = this.myRepository.getFieldDefinitionByName(fieldName);
            if (fd == null || !fd.isComplexType()) {
                throw new ExpressionException("Field does not exist or is not complex: " + fieldName);
            }
            FieldIndexKeyContainer keyContainer = FieldOrientedPluginUtil.extractIndexKeyObjectFromIndexElement(operandIndex, this.myRepository, (FieldHierarchyNode)fd);
            return new FieldValueOperand(new DataSetField(fd), keyContainer, this.myReader);
        }
        Operand o = this.createFieldOrValueOperand(valueObject);
        return o;
    }

    private Operand createFieldOrValueOperand(ValueFieldCompositeObject object) {
        Operand o;
        String str = object.getFieldOrValueAsString();
        if (object.getMode() == ValueFieldCompositeObject.Mode.Field) {
            o = this.createFieldValueOperand(str);
        } else {
            DataType dt = object.getValueDataType();
            if (dt != null) {
                o = null;
                if (dt == DataType.TIME) {
                    o = this.createSpecialTimeOperandIfRequested(str);
                }
                if (o == null) {
                    Object value = this.parseValue(dt, str);
                    o = ValueOperand.createFor(value);
                }
            } else if (!StringUtil.isEmptyString(str) && str.matches(RE_NUMERIC)) {
                RatingDecimal rd = new RatingDecimal(str);
                o = ValueOperand.createFor(rd);
            } else {
                o = ValueOperand.createFor(str);
            }
        }
        return o;
    }

    private Operand createSpecialTimeOperandIfRequested(String str) {
        DataSetTimeOperand ret = null;
        if (START_TIME.equals(str)) {
            ret = DataSetTimeOperand.startTimeOperand();
        } else if (CURRENT_TIME.equals(str)) {
            ret = DataSetTimeOperand.currentTimeOperand();
        }
        return ret;
    }

    private Object parseValue(DataType dataType, String value) {
        Object ret;
        switch (dataType) {
            case AMOUNT: {
                ret = AmountStub.create(value);
                break;
            }
            default: {
                ret = dataType.parseValue(value);
            }
        }
        return ret;
    }

    private FieldDefinition getField(String fieldName) {
        if (this.myRepository == null) {
            throw new IllegalStateException("Null repository but needed.");
        }
        FieldDefinition fd = this.myRepository.getFieldDefinitionByName(fieldName);
        if (fd == null) {
            throw new ExpressionException("Unknown field: " + fieldName);
        }
        return fd;
    }

    private Operand createFieldValueOperand(String fieldName) {
        FieldDefinition fd = this.getField(fieldName);
        DataSetField dsf = new DataSetField(fd);
        return new FieldValueOperand(dsf, this.myReader);
    }
}

