/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.modifiers.mfo;

import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.expression.EvaluationContext;
import com.ericsson.ere.expression.Expression;
import com.ericsson.ere.expression.ExpressionEvaluator;
import com.ericsson.ere.expression.ExpressionToken;
import com.ericsson.ere.expression.FieldValueOperand;
import com.ericsson.ere.expression.InfixExpressionFormatter;
import com.ericsson.ere.expression.Operand;
import com.ericsson.ere.expression.ValueOperand;
import com.ericsson.ere.selectiontree.modifiers.mfo.DataSetEvaluationContext;
import com.ericsson.ere.selectiontree.util.FieldIndexFormatter;
import com.ericsson.ere.selectiontree.util.FieldIndexKeyContainer;
import java.util.List;

public class ResolvingInfixExpressionFormatter
implements ExpressionEvaluator {
    @Override
    public Operand evaluate(Expression expr, EvaluationContext context) {
        if (expr.getNotation() != Expression.ExpressionNotation.INFIX) {
            throw new IllegalArgumentException("This formatter can only operate on infix expressions.");
        }
        assert (context instanceof CustomContext);
        final CustomContext ctx = (CustomContext)context;
        if (ctx.level != ResolutionLevel.NONE && ctx.getDataSet() == null) {
            throw new IllegalArgumentException("This formatter needs a data set.");
        }
        InfixExpressionFormatter formatter = new InfixExpressionFormatter(){

            @Override
            protected void appendToken(StringBuilder b, List<ExpressionToken> tokens, int i) {
                ExpressionToken token = tokens.get(i);
                b.append(ResolvingInfixExpressionFormatter.this.tokenToString(token, ctx));
            }
        };
        return ValueOperand.createFor(formatter.format(expr));
    }

    private String tokenToString(ExpressionToken token, CustomContext context) {
        String s = token instanceof FieldValueOperand ? this.tokenToString((FieldValueOperand)token, context) : token.toString();
        return s;
    }

    private String tokenToString(FieldValueOperand field, CustomContext context) {
        String s;
        FieldIndexKeyContainer keyContainer = field.getKeyContainer();
        switch (context.level) {
            case FULL: {
                Object value = field.getValue(context);
                s = ValueOperand.createFor(value).toString();
                break;
            }
            default: {
                s = field.getFieldName();
                if (keyContainer == null) break;
                FieldIndexFormatter formatter = new FieldIndexFormatter(field.getFieldName());
                formatter.setIncludeIndexFieldValue(context.level == ResolutionLevel.INDEXES_ONLY);
                formatter.setIncludeIndexFieldName(context.level == ResolutionLevel.NONE);
                formatter.setUseDataSetResolution(context.level != ResolutionLevel.NONE);
                formatter.setSeparator(" ; ");
                s = formatter.format(keyContainer, context.getDataSet());
            }
        }
        return s;
    }

    public static String format(Expression expr, DataSet ds, ResolutionLevel level) {
        final ResolvingInfixExpressionFormatter eval = new ResolvingInfixExpressionFormatter();
        CustomContext context = new CustomContext(ds, level){

            @Override
            public ExpressionEvaluator getEvaluator() {
                return eval;
            }
        };
        Operand o = expr.evaluate(context);
        return (String)o.getValue(null);
    }

    private static abstract class CustomContext
    extends DataSetEvaluationContextImpl {
        ResolutionLevel level;

        CustomContext(DataSet ds, ResolutionLevel level) {
            super(ds);
            this.level = level;
        }
    }

    private static abstract class DataSetEvaluationContextImpl
    implements DataSetEvaluationContext {
        private DataSet myDataSet;

        DataSetEvaluationContextImpl(DataSet ds) {
            this.myDataSet = ds;
        }

        @Override
        public DataSet getDataSet() {
            return this.myDataSet;
        }
    }

    public static enum ResolutionLevel {
        NONE,
        INDEXES_ONLY,
        FULL;

    }
}

