/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.modifiers.mfo;

import com.ericsson.ere.expression.ExpressionToken;
import com.ericsson.ere.selectiontree.modifiers.mfo.ComplexRow;
import com.ericsson.ere.selectiontree.modifiers.mfo.MFORow;
import com.ericsson.ere.selectiontree.modifiers.mfo.MultiFieldOperationModel;
import java.util.Collections;
import java.util.List;

public class FunctionArgumentRow
extends ComplexRow {
    private static final List<ExpressionToken> EMPTY_TOKENS = Collections.emptyList();

    public FunctionArgumentRow(List<? extends MFORow> rows) {
        super(rows);
    }

    @Override
    public void addRow(int index, MFORow row) {
        this.checkValid();
        if (this.isNoArgumentRow()) {
            throw new IllegalStateException("Cannot add a row to a no-argument function.");
        }
        if (index == 0) {
            throw new IllegalArgumentException("Cannot insert a row first.");
        }
        List<ExpressionToken> tokens = row.getExpressionTokens();
        assert (!tokens.isEmpty());
        if (tokens.get(0).equals(ExpressionToken.FUNCTION_ARG_SEPARATOR)) {
            throw new IllegalArgumentException("Cannot add row with function argument separator.");
        }
        super.addRow(index, row);
    }

    public boolean isNoArgumentRow() {
        return !MultiFieldOperationModel.containsOperand((MFORow)this.myRows.get(0));
    }

    @Override
    public MFORow setRow(int index, MFORow replacement) {
        this.checkValid();
        List<ExpressionToken> tokens = replacement.getExpressionTokens();
        assert (!tokens.isEmpty());
        if (tokens.get(0).equals(ExpressionToken.FUNCTION_ARG_SEPARATOR) && index > 0) {
            throw new IllegalArgumentException("Cannot set function argument separator row at index " + index);
        }
        return super.setRow(index, replacement);
    }

    @Override
    protected void collapseImpl(MFORow row1, MFORow row2, ComplexRow.Collapser collapser) {
        this.checkValid();
        if (this.isNoArgumentRow()) {
            throw new IllegalStateException("Cannot collapse a no-argument function.");
        }
        super.collapseImpl(row1, row2, collapser);
    }

    @Override
    public boolean canCollapseRows(MFORow row1, MFORow row2) {
        return super.canCollapseRows(row1, row2) && !this.isNoArgumentRow();
    }

    @Override
    protected List<? extends ExpressionToken> getLeadTokens() {
        return EMPTY_TOKENS;
    }

    @Override
    protected List<? extends ExpressionToken> getTailTokens() {
        return EMPTY_TOKENS;
    }

    @Override
    public boolean canSplit() {
        return false;
    }

    @Override
    public List<MFORow> split() {
        throw new IllegalStateException("Cannot split a function argument row.");
    }
}

