/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.modifiers.mfo;

import com.ericsson.ere.annotations.jcip.Immutable;
import com.ericsson.ere.dataset.DataSetField;
import com.ericsson.ere.selectiontree.modifiers.mfo.DestinationFieldInfo;
import com.ericsson.ere.selectiontree.util.FieldIndexKeyContainer;
import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.FieldDefinition;

@Immutable
public abstract class AbstractDestinationFieldInfo
implements DestinationFieldInfo {
    private final DataSetField myDestinationField;
    private final DataType myDestinationDataType;
    private final FieldIndexKeyContainer myKeyContainer;

    protected AbstractDestinationFieldInfo(FieldDefinition field, FieldIndexKeyContainer key) {
        this.myKeyContainer = key;
        this.myDestinationDataType = field.getTypedDataType();
        this.myDestinationField = new DataSetField(field);
    }

    protected AbstractDestinationFieldInfo(FieldDefinition field, FieldIndexKeyContainer key, DataType supportedDataType) {
        this(field, key);
        DataType dt = this.getDestinationDataType();
        if (dt != supportedDataType) {
            throw new IllegalArgumentException("Destination data type not supported: " + dt);
        }
    }

    protected DataType getDestinationDataType() {
        return this.myDestinationDataType;
    }

    @Override
    public boolean useKeyForDestination() {
        return this.myKeyContainer != null;
    }

    @Override
    public FieldIndexKeyContainer retrieveKeyContainerForDestination() {
        return this.myKeyContainer;
    }

    @Override
    public DataSetField getDestinationField() {
        return this.myDestinationField;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.myDestinationDataType == null ? 0 : this.myDestinationDataType.hashCode());
        result = 31 * result + (this.myDestinationField == null ? 0 : this.myDestinationField.hashCode());
        result = 31 * result + (this.myKeyContainer == null ? 0 : this.myKeyContainer.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractDestinationFieldInfo other = (AbstractDestinationFieldInfo)obj;
        if (this.myDestinationDataType == null ? other.myDestinationDataType != null : !this.myDestinationDataType.equals(other.myDestinationDataType)) {
            return false;
        }
        if (this.myDestinationField == null ? other.myDestinationField != null : !this.myDestinationField.equals(other.myDestinationField)) {
            return false;
        }
        return !(this.myKeyContainer == null ? other.myKeyContainer != null : !this.myKeyContainer.equals(other.myKeyContainer));
    }
}

