/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.modifiers;

import com.ericsson.ere.selectiontree.ParseContextAdapter;
import com.ericsson.ere.selectiontree.modifiers.RateFieldConfiguration;
import com.ericsson.ere.selectiontree.modifiers.RateFieldIntervalConfiguration;
import com.ericsson.ere.selectiontree.modifiers.RateFieldProfile;
import com.ericsson.ere.selectiontree.util.FieldOrientedPluginProfileUtil;
import com.ericsson.ere.selectiontree.util.PluginConfigurationHelper;
import com.ericsson.ere.selectiontree.util.ValueFieldCompositeObject;
import com.ericsson.vareditor.document.RateFieldDocument;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.gui.util.GuiUtil;
import ericsson.ere.xml.XMLUtil;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RateFieldIntervalProfile
extends RateFieldProfile {
    public static final String LBL_PRICE_INTERVAL = "Price interval";
    public static final String LBL_PRICE_INTERVAL_INDEX = "Price interval Index";
    public static final String LBL_PRICE_PER_INTERVAL = "Price per interval";
    public static final String DEFAULT_PRICE_INTERVAL = "1";

    @Override
    public String getAdditionalInfo(List<Variable> variables) {
        return GuiUtil.descriptionToTooltip(this.getDescription(variables), this.getName(), this.getComment(variables));
    }

    @Override
    public String getDescription(List<Variable> variables) {
        StringBuilder strBuilder = this.getRateFieldDescription(variables);
        strBuilder.append(", ").append("PriceInterval").append(" = ");
        String intervalName = VarListUtil.getValueStringForName(variables, LBL_PRICE_INTERVAL);
        FieldDefinition intervalField = this.myClassRepository.getFieldDefinitionByName(intervalName);
        if (intervalField != null) {
            strBuilder.append(this.createFieldDisplayString(intervalField, variables, LBL_PRICE_INTERVAL_INDEX));
        } else {
            strBuilder.append(intervalName);
        }
        return strBuilder.toString();
    }

    @Override
    public Map<String, Object> getDisplayValues(Node data, Map<String, Object> prev) {
        Map<String, Object> displayValuesMap = super.getDisplayValues(data, prev);
        Element priceElement = XMLUtil.getFirstElementNamed("PriceInterval", (Element)data);
        String priceName = XMLUtil.getFirstTextContent(priceElement);
        displayValuesMap.put(LBL_PRICE_INTERVAL, priceName);
        Element priceIndexElem = XMLUtil.getFirstElementNamed("Index", priceElement);
        if (priceIndexElem != null) {
            displayValuesMap.put(LBL_PRICE_INTERVAL_INDEX, priceIndexElem.getTextContent());
        }
        return displayValuesMap;
    }

    @Override
    public String[] getTreeDefinedFieldInUse(List<Variable> profileState) {
        Set<String> usedTDFs = this.getRateFieldTDFs(profileState);
        usedTDFs.addAll(FieldOrientedPluginProfileUtil.extractReservedTreeDefinedFieldFromVariable(VarListUtil.getVariableForKey(profileState, LBL_PRICE_INTERVAL), this.myClassRepository, true));
        usedTDFs.addAll(FieldOrientedPluginProfileUtil.extractReservedTreeDefinedFieldFromVariable(VarListUtil.getVariableForKey(profileState, LBL_PRICE_INTERVAL_INDEX), this.myClassRepository, true));
        return usedTDFs.toArray(new String[usedTDFs.size()]);
    }

    @Override
    public List<Variable> getVariables() {
        RateFieldIntervalConfiguration conf = new RateFieldIntervalConfiguration();
        return this.createInputVariables(conf);
    }

    @Override
    public List<Variable> getVariables(Node xmlNode) {
        RateFieldIntervalConfiguration conf = RateFieldIntervalConfiguration.create(new ParseContextAdapter(this.myClassRepository, xmlNode, null));
        return this.createInputVariables(conf);
    }

    @Override
    public boolean parameterChanged(String reference, Variable value, List<Variable> vars) {
        boolean updated = super.parameterChanged(reference, value, vars);
        if (!updated && LBL_PRICE_INTERVAL.equals(reference)) {
            updated = this.updateIndexVariableForFieldVariable(vars, value, LBL_PRICE_INTERVAL_INDEX);
        }
        return updated;
    }

    @Override
    public void printParametersImpl(PrintWriter out, int indentLevel, String indentMarker, List<Variable> variables) {
        ValueFieldCompositeObject priceIntervalVFCO = null;
        ValueFieldCompositeObject priceIntervalIndexVFCO = null;
        priceIntervalVFCO = this.getVFCOFromVariables(variables, LBL_PRICE_INTERVAL);
        if (priceIntervalVFCO.getMode() == ValueFieldCompositeObject.Mode.Field) {
            priceIntervalIndexVFCO = this.getVFCOFromVariables(variables, LBL_PRICE_INTERVAL_INDEX);
        }
        RateFieldConfiguration conf = this.getConfigFromVariables(variables);
        RateFieldIntervalConfiguration intervalConf = new RateFieldIntervalConfiguration(conf.getPriceValueVFCO(), conf.getPriceIndexVFCO(), conf.getChargingIntervalValueVFCO(), conf.getChargingIntervalIndexVFCO(), priceIntervalVFCO, priceIntervalIndexVFCO);
        PluginConfigurationHelper.writeXML(intervalConf, out, indentLevel, indentMarker);
    }

    private List<Variable> createInputVariables(RateFieldIntervalConfiguration conf) {
        List<Variable> vars = super.createInputVariables(conf);
        this.addFieldVariable(vars, conf.getPriceIntervalValueVFCO(), conf.getPriceIntervalIndexVFCO(), DEFAULT_PRICE_INTERVAL, LBL_PRICE_INTERVAL, LBL_PRICE_INTERVAL_INDEX, new RateFieldDocument(false, 3));
        return vars;
    }

    @Override
    protected String getPriceLabel() {
        return LBL_PRICE_PER_INTERVAL;
    }
}

