/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.modifiers;

import com.ericsson.ere.constraint.ConstraintService;
import com.ericsson.ere.constraint.contract.Constrainable;
import com.ericsson.ere.expression.Expression;
import com.ericsson.ere.expression.Function;
import com.ericsson.ere.expression.FunctionParameterInfo;
import com.ericsson.ere.expression.Functions;
import com.ericsson.ere.expression.Operand;
import com.ericsson.ere.expression.Operator;
import com.ericsson.ere.expression.Operators;
import com.ericsson.ere.selectiontree.FieldFilter;
import com.ericsson.ere.selectiontree.modifiers.AbstractMultiFieldOperationProfile;
import com.ericsson.ere.selectiontree.modifiers.MultiFieldOperationProfileContract;
import com.ericsson.ere.selectiontree.modifiers.mfo.ExpressionVariable;
import com.ericsson.ere.selectiontree.modifiers.mfo.MultiFieldOperationModel;
import com.ericsson.ere.selectiontree.modifiers.mfo.ValueFieldCompositeOperand;
import com.ericsson.ere.selectiontree.util.AvailableFieldListBuilder;
import com.ericsson.ere.selectiontree.util.FieldOrientedPluginProfileUtil;
import com.ericsson.ere.selectiontree.util.FieldOrientedPluginUtil;
import com.ericsson.ere.selectiontree.util.ValueFieldCompositeObject;
import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.gui.util.VariableFactory;
import ericsson.vareditor.variable.InfoVariable;
import ericsson.vareditor.variable.NotAllowedVariable;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import org.w3c.dom.Node;

@Constrainable(contractClass=MultiFieldOperationProfileContract.class)
public class MultiFieldOperationProfile
extends AbstractMultiFieldOperationProfile {
    private static final String MFO_FUNCTION_SUPPORT_FEATURE = "Function_Support";
    private static final List<String> OPERAND_PARAM_TYPES;
    private static final Operator[] NUMERIC_OPERATORS;
    private static final Function[] DEFAULT_SUPPORTED_FUNCTIONS;
    private static final Function[] EMPTY_FUNCTIONS;
    private static final List<DataType> NUMERIC_DATA_TYPES;
    public static final String LBL_EXPRESSION = "Expression";
    public static final String LBL_DT_WARNING = "Warning";
    public static final String LBL_DT_ERROR = "Error";
    public static final String LBL_DEST_FIELD_INDEX = "Indexes";
    private static final String MSG_DT_WARNING = "The destination field may be too small to hold the expression result.";
    private static final String MSG_DT_INCOMPAT_ERROR = "The expression data type is not compatible with the destination field data type.";
    private static final FieldFilter DESTINATION_FIELD_FILTER;
    private Boolean myIsFunctionSupportEnabled;
    private boolean myCreateNewModelForFieldSwitch;

    protected List<String> getCandidateFeatures() {
        return Arrays.asList(MFO_FUNCTION_SUPPORT_FEATURE);
    }

    private static Variable createDataTypeErrorVariable() {
        return new NotAllowedVariable(LBL_DT_ERROR, MSG_DT_INCOMPAT_ERROR);
    }

    private static Variable createDataTypeWarningVariable() {
        InfoVariable var = new InfoVariable(LBL_DT_WARNING, MSG_DT_WARNING);
        JComponent editor = (JComponent)((Variable)var).getEditor();
        editor.setForeground(Color.red);
        editor.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        return var;
    }

    public MultiFieldOperationProfile() {
        super(LBL_DEST_FIELD_INDEX);
    }

    @Override
    public List<Variable> getVariables() {
        this.myCreateNewModelForFieldSwitch = true;
        return super.getVariables();
    }

    @Override
    public List<Variable> getVariables(Node config) {
        this.myCreateNewModelForFieldSwitch = false;
        return super.getVariables(config);
    }

    @Override
    public boolean parameterChanged(String reference, Variable value, List<Variable> vars) {
        boolean updated = super.parameterChanged(reference, value, vars);
        if ("Destination field".equals(reference)) {
            updated |= this.updateDataTypeWarning(vars, null);
        } else if (LBL_EXPRESSION.equals(reference)) {
            this.myCreateNewModelForFieldSwitch = false;
            MultiFieldOperationModel model = (MultiFieldOperationModel)value.getValueObject();
            this.updateResultingExpression(vars, model == null ? null : model.getExpression());
            this.updateDataTypeWarning(vars, null);
            updated = true;
        }
        return updated;
    }

    @Override
    protected List<Variable> createVariables(List<String> destinationFields, String selectedDestination, ValueFieldCompositeObject indexObject, Expression expression) {
        List<Variable> vars = super.createVariables(destinationFields, selectedDestination, indexObject, expression);
        if (VarListUtil.getVariableForName(vars, "Resulting expression") == null) {
            return vars;
        }
        FieldDefinition field = this.getField(selectedDestination);
        if (field != null) {
            this.updateDataTypeWarning(vars, field);
        }
        return vars;
    }

    private boolean updateDataTypeWarning(List<Variable> vars, FieldDefinition field) {
        boolean updated = false;
        FieldDefinition fd = field;
        if (fd == null) {
            String destField = VarListUtil.getValueStringForName(vars, "Destination field");
            fd = this.getField(destField);
        }
        if (fd != null) {
            DataType needed;
            ExpressionVariable evar = (ExpressionVariable)VarListUtil.getVariableForName(vars, LBL_EXPRESSION);
            DataType resultingDataType = evar.getExpressionDataType();
            DataType destDataType = fd.getTypedDataType();
            if (destDataType == (needed = this.findNeededDataTypeForDestination(resultingDataType, destDataType))) {
                updated |= VarListUtil.removeVariablesByLabel(vars, LBL_DT_WARNING, LBL_DT_ERROR);
            } else if (this.bothAreNumericTypes(destDataType, needed)) {
                if (VarListUtil.getVariableForName(vars, LBL_DT_WARNING) == null) {
                    VarListUtil.removeVariablesByLabel(vars, LBL_DT_ERROR);
                    VarListUtil.insertVariableAfterLabel(vars, LBL_EXPRESSION, MultiFieldOperationProfile.createDataTypeWarningVariable());
                    updated = true;
                }
            } else if (VarListUtil.getVariableForName(vars, LBL_DT_ERROR) == null) {
                VarListUtil.removeVariablesByLabel(vars, LBL_DT_WARNING);
                VarListUtil.insertVariableAfterLabel(vars, LBL_EXPRESSION, MultiFieldOperationProfile.createDataTypeErrorVariable());
                updated = true;
            }
        }
        return updated;
    }

    private DataType findNeededDataTypeForDestination(DataType resultingDataType, DataType destDataType) {
        if (resultingDataType == null) {
            return destDataType;
        }
        if (this.bothAreNumericTypes(resultingDataType, destDataType)) {
            return DataType.getLargerEnclosingDataType(destDataType, resultingDataType);
        }
        return resultingDataType;
    }

    private boolean bothAreNumericTypes(DataType dt1, DataType dt2) {
        return dt1.isNumeric() && dt2.isNumeric();
    }

    private MultiFieldOperationModel createModel(Expression expression, String field) {
        MultiFieldOperationModel model;
        if (expression == null || this.myCreateNewModelForFieldSwitch) {
            assert (field != null);
            model = new MultiFieldOperationModel(this.createOperandForField(field));
        } else {
            model = new MultiFieldOperationModel(expression);
        }
        return model;
    }

    private Operand createOperandForField(String fieldName) {
        FieldDefinition field = this.myClassRepository.getFieldDefinitionByName(fieldName);
        ValueFieldCompositeObject obj = new ValueFieldCompositeObject(ValueFieldCompositeObject.Mode.Field, fieldName);
        ValueFieldCompositeObject index = null;
        if (field.isComplexType()) {
            index = FieldOrientedPluginUtil.createDefaultValueFieldCompositeObjectForFieldKey(field, this.myClassRepository);
        }
        return new ValueFieldCompositeOperand(obj, index);
    }

    @Override
    protected FieldFilter getOrCreateDestinationFieldFilter() {
        return DESTINATION_FIELD_FILTER;
    }

    @Override
    protected List<? extends Variable> createExpressionVariables(Expression expression) {
        String destField = this.getCurrentDestinationField();
        MultiFieldOperationModel model = this.createModel(expression, destField);
        ExpressionVariable.ExpressionBuilder builder = this.createExpressionBuilderForField(destField);
        ExpressionVariable var = new ExpressionVariable(LBL_EXPRESSION, model, builder);
        return Arrays.asList(var);
    }

    protected ExpressionVariable.ExpressionBuilder createExpressionBuilderForField(String destField) {
        Function[] functions = this.getSupportedFunctions();
        List<DataType> dataTypes = this.getNecessaryDataTypes(destField, functions);
        MFOExpressionBuilder builder = new MFOExpressionBuilder(dataTypes.toArray(new DataType[dataTypes.size()]), NUMERIC_OPERATORS, functions);
        return builder;
    }

    private List<DataType> getNecessaryDataTypes(String destField, Function[] functions) {
        ArrayList<DataType> dataTypes = new ArrayList<DataType>(NUMERIC_DATA_TYPES);
        this.addFieldDataType(this.getField(destField), dataTypes);
        this.addFunctionParameterDataTypes(functions, dataTypes);
        return dataTypes;
    }

    private void addFunctionParameterDataTypes(Function[] functions, List<DataType> dataTypes) {
        for (Function func : functions) {
            for (FunctionParameterInfo param : func.getParameters()) {
                DataType dt = param.getType();
                if (dataTypes.contains(dt)) continue;
                dataTypes.add(dt);
            }
        }
    }

    private void addFieldDataType(FieldDefinition fd, List<DataType> dataTypes) {
        DataType fieldType;
        if (fd != null && !dataTypes.contains(fieldType = fd.getTypedDataType())) {
            dataTypes.add(0, fieldType);
        }
    }

    protected Function[] getSupportedFunctions() {
        return this.isFunctionSupportEnabled() ? DEFAULT_SUPPORTED_FUNCTIONS : EMPTY_FUNCTIONS;
    }

    private boolean isFunctionSupportEnabled() {
        if (this.myIsFunctionSupportEnabled == null) {
            this.myIsFunctionSupportEnabled = this.isFeatureEnabled(MFO_FUNCTION_SUPPORT_FEATURE);
        }
        return this.myIsFunctionSupportEnabled;
    }

    private boolean isFeatureEnabled(String feature) {
        List<String> features = ConstraintService.constrainFeatures(this, this.myClassRepository, this.getCandidateFeatures());
        return features.contains(feature);
    }

    @Override
    protected FieldFilter getOrCreateOperandFieldFilter(String destination) {
        Function[] functions = this.getSupportedFunctions();
        List<DataType> dataTypes = this.getNecessaryDataTypes(destination, functions);
        return new OperandFieldFilter(dataTypes);
    }

    @Override
    protected Expression getCurrentExpression(List<Variable> variables) {
        MultiFieldOperationModel model = (MultiFieldOperationModel)VarListUtil.getValueForName(variables, LBL_EXPRESSION);
        Expression e = model == null ? null : model.getExpression();
        return e;
    }

    @Override
    protected VariableFactory.IndexType getIndexTypeForField(FieldDefinition field, boolean ignored) {
        return FieldOrientedPluginProfileUtil.getIndexTypeForFieldMultipleIndicies(field);
    }

    @Override
    protected boolean needsExpressionRefreshForDestinationFieldChange(String oldField, String newField) {
        boolean need = super.needsExpressionRefreshForDestinationFieldChange(oldField, newField);
        if (!need) {
            FieldDefinition oldfd = this.getField(oldField);
            FieldDefinition newfd = this.getField(newField);
            need = this.fieldsHaveDifferentTypes(oldfd, newfd);
        }
        return need || this.myCreateNewModelForFieldSwitch;
    }

    private boolean fieldsHaveDifferentTypes(FieldDefinition oldfd, FieldDefinition newfd) {
        DataType newdt;
        DataType olddt = oldfd.getTypedDataType();
        if (this.bothAreNumericTypes(olddt, newdt = newfd.getTypedDataType())) {
            return false;
        }
        return olddt != newdt;
    }

    static {
        NUMERIC_OPERATORS = new Operator[]{Operators.ADD, Operators.SUBTRACT, Operators.MULTIPLY, Operators.DIVIDE, Operators.INT_DIVIDE, Operators.MODULUS, Operators.POWER};
        DEFAULT_SUPPORTED_FUNCTIONS = new Function[]{Functions.ROUND, Functions.TRUNCATE, Functions.BALANCEOF};
        EMPTY_FUNCTIONS = new Function[0];
        DESTINATION_FIELD_FILTER = new DestinationFieldFilter();
        OPERAND_PARAM_TYPES = new ArrayList<String>(DEST_PARAM_TYPES);
        OPERAND_PARAM_TYPES.addAll(Arrays.asList(ClassRepository.INPUT_TYPES));
        ArrayList<DataType> numTypes = new ArrayList<DataType>();
        for (DataType dt : DataType.values()) {
            if (!dt.isNumeric()) continue;
            numTypes.add(dt);
        }
        NUMERIC_DATA_TYPES = Collections.unmodifiableList(numTypes);
    }

    private class MFOExpressionBuilder
    implements ExpressionVariable.ExpressionBuilder {
        private List<Operator> myOperators;
        private List<DataType> myDataTypes;
        private List<Function> myFunctions;

        MFOExpressionBuilder(DataType[] dataTypes, Operator[] operators, Function[] functions) {
            this.myDataTypes = Arrays.asList(dataTypes);
            this.myOperators = Arrays.asList(operators);
            this.myFunctions = Arrays.asList(functions);
        }

        @Override
        public List<String> getAllowedOperandFields() {
            String selectedField = MultiFieldOperationProfile.this.getCurrentDestinationField();
            return MultiFieldOperationProfile.this.getConstrainedOperandFieldsForDestinationField(selectedField);
        }

        @Override
        public List<Operator> getAllowedOperators() {
            return this.myOperators;
        }

        @Override
        public List<DataType> getAllowedValueDataTypes() {
            return this.myDataTypes;
        }

        @Override
        public ClassRepository getClassRepository() {
            return MultiFieldOperationProfile.this.myClassRepository;
        }

        @Override
        public String getDestinationField() {
            return MultiFieldOperationProfile.this.getCurrentDestinationField();
        }

        @Override
        public List<Function> getAllowedFunctions() {
            return this.myFunctions;
        }

        @Override
        public AvailableFieldListBuilder getAllowedOperandFieldsListBuilder() {
            return MultiFieldOperationProfile.this.createOperandFieldListBuilder();
        }
    }

    private static class OperandFieldFilter
    implements FieldFilter {
        private Collection<DataType> myTypes;

        OperandFieldFilter(Collection<DataType> types) {
            this.myTypes = types;
        }

        @Override
        public boolean isAllowed(FieldDefinition field) {
            DataType dt = field.getTypedDataType();
            String pt = field.getParameterType();
            return OPERAND_PARAM_TYPES.contains(pt) && this.isSupportedDataType(dt);
        }

        private boolean isSupportedDataType(DataType dt) {
            return this.myTypes.contains(dt);
        }
    }

    private static class DestinationFieldFilter
    implements FieldFilter {
        private DestinationFieldFilter() {
        }

        @Override
        public boolean isAllowed(FieldDefinition field) {
            DataType dt = field.getTypedDataType();
            String pt = field.getParameterType();
            return AbstractMultiFieldOperationProfile.DEST_PARAM_TYPES.contains(pt) && (dt.isNumeric() || dt == DataType.AMOUNT);
        }
    }
}

