/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.mdu.filter;

import com.ericsson.ere.selectiontree.mdu.MDUTreeElement;
import com.ericsson.ere.selectiontree.mdu.filter.SelectionTreeElementFilter;
import ericsson.ere.interfaces.TariffStructureNode;
import ericsson.ere.util.StringUtil;

public class TagBasedElementFilter
implements SelectionTreeElementFilter {
    private String myTag;
    private boolean myConsiderCase;
    private MatchOperation myOperation;

    public TagBasedElementFilter(String tag) {
        this(tag, MatchOperation.Equals, false);
    }

    public TagBasedElementFilter(String tag, MatchOperation operation, boolean caseSensitive) {
        if (tag == null || operation == null) {
            throw new IllegalArgumentException("Tag and operation cannot be null.");
        }
        this.myTag = tag;
        this.myConsiderCase = caseSensitive;
        this.myOperation = operation;
    }

    @Override
    public boolean test(TariffStructureNode object) {
        assert (object instanceof MDUTreeElement) : "All elements must implement MDUTreeElement!";
        String elementTag = ((MDUTreeElement)((Object)object)).getProductTag();
        if (elementTag == null) {
            return false;
        }
        return this.myOperation.compare(this.myTag, elementTag, this.myConsiderCase);
    }

    public String toString() {
        return String.format("[sought tag = %s; operation = %s; case sensitive = %b]", new Object[]{this.myTag, this.myOperation, this.myConsiderCase});
    }

    @Override
    public String getDisplayString() {
        return this.myTag;
    }

    public static enum MatchOperation {
        Equals{

            @Override
            protected boolean compare(String needle, String haystack, boolean considerCase) {
                return considerCase ? haystack.equals(needle) : haystack.equalsIgnoreCase(needle);
            }
        }
        ,
        StartsWith{

            @Override
            protected boolean compare(String needle, String haystack, boolean considerCase) {
                return considerCase ? haystack.startsWith(needle) : StringUtil.startsWithIgnoreCase(haystack, needle);
            }
        }
        ,
        EndsWith{

            @Override
            protected boolean compare(String needle, String haystack, boolean considerCase) {
                return considerCase ? haystack.endsWith(needle) : StringUtil.endsWithIgnoreCase(haystack, needle);
            }
        }
        ,
        Contains{

            @Override
            protected boolean compare(String needle, String haystack, boolean considerCase) {
                return considerCase ? haystack.contains(needle) : haystack.toLowerCase().contains(needle.toLowerCase());
            }
        };


        protected abstract boolean compare(String var1, String var2, boolean var3);
    }
}

