/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.mdu.filter;

import com.ericsson.ere.selectiontree.mdu.filter.SelectionTreeElementFilter;
import ericsson.ere.interfaces.TariffStructureNode;
import ericsson.ere.util.StringUtil;

public class PathBasedElementFilter
implements SelectionTreeElementFilter {
    private String myPathString;
    private boolean myInterpretWildCards;
    private boolean myCaseSensitive;
    private String[] myPathParts;

    public PathBasedElementFilter(String path, boolean caseSensitive) {
        this(path, caseSensitive, true);
    }

    public PathBasedElementFilter(String path, boolean caseSensitive, boolean interpretWildCards) {
        this.validateStringPath(path);
        this.myInterpretWildCards = interpretWildCards;
        this.myCaseSensitive = caseSensitive;
        this.myPathParts = this.normalizeWildcards(path.substring(1).split("/"));
        this.myPathString = path;
    }

    private String[] normalizeWildcards(String[] parts) {
        if (!this.myInterpretWildCards) {
            return parts;
        }
        String[] temp = new String[parts.length];
        int idx = 0;
        for (int i = 0; i < parts.length; ++i) {
            String previous = idx > 0 ? temp[idx - 1] : null;
            boolean add = true;
            if ("*".equals(parts[i])) {
                add = !"**".equals(previous);
            } else if ("**".equals(parts[i]) && ("*".equals(previous) || "**".equals(previous))) {
                temp[idx - 1] = "**";
                add = false;
            }
            if (!add) continue;
            temp[idx++] = parts[i];
        }
        String[] ret = new String[idx];
        System.arraycopy(temp, 0, ret, 0, ret.length);
        return ret;
    }

    private void validateStringPath(String path) {
        if (path == null) {
            throw new IllegalArgumentException("Path cannot be null.");
        }
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException("Path must be absolute (begin with /): " + path);
        }
        if (path.endsWith("/")) {
            throw new IllegalArgumentException("Path must not end with a /: " + path);
        }
    }

    private boolean testPart(String[] pathParts, int cursor, TariffStructureNode current) {
        if (this.isRoot(current)) {
            return cursor < 0;
        }
        if (cursor < 0) {
            return false;
        }
        if (this.isDoubleWildCard(pathParts[cursor])) {
            if (cursor == 0) {
                return true;
            }
            String precedingPathPart = pathParts[cursor - 1];
            TariffStructureNode temp = (TariffStructureNode)current.getParent();
            while (!this.isRoot(temp) && !this.equals(precedingPathPart, temp.getNodeId())) {
                temp = (TariffStructureNode)temp.getParent();
            }
            if (this.isRoot(temp)) {
                return false;
            }
            return this.testPart(pathParts, cursor - 2, (TariffStructureNode)temp.getParent());
        }
        if (this.equals(pathParts[cursor], current.getNodeId())) {
            return this.testPart(pathParts, cursor - 1, (TariffStructureNode)current.getParent());
        }
        return false;
    }

    private boolean isDoubleWildCard(String pathPart) {
        return this.myInterpretWildCards && "**".equals(pathPart);
    }

    private boolean equals(String pathPart, String nodeId) {
        if (this.myInterpretWildCards) {
            boolean isWC = "*".equals(pathPart);
            boolean isWCStart = pathPart.startsWith("*");
            boolean isWCEnd = pathPart.endsWith("*") && !pathPart.endsWith("\\*");
            boolean isWCContains = isWCStart && isWCEnd && !"**".equals(pathPart);
            pathPart = pathPart.replace("\\*", "*");
            if (isWC) {
                return true;
            }
            if (isWCContains) {
                String middle = pathPart.substring(1, pathPart.length() - 1);
                return this.myCaseSensitive ? nodeId.contains(middle) : PathBasedElementFilter.containsIgnoreCase(nodeId, middle);
            }
            if (isWCStart) {
                String trail = pathPart.substring(1);
                return this.myCaseSensitive ? nodeId.endsWith(trail) : StringUtil.endsWithIgnoreCase(nodeId, trail);
            }
            if (isWCEnd) {
                String lead = pathPart.substring(0, pathPart.length() - 1);
                return this.myCaseSensitive ? nodeId.startsWith(lead) : StringUtil.startsWithIgnoreCase(nodeId, lead);
            }
        }
        return this.myCaseSensitive ? pathPart.equals(nodeId) : pathPart.equalsIgnoreCase(nodeId);
    }

    private static boolean containsIgnoreCase(String needle, String haystack) {
        return needle.toUpperCase().contains(haystack.toUpperCase()) || needle.toLowerCase().contains(haystack.toLowerCase());
    }

    private boolean isRoot(TariffStructureNode current) {
        return current.getParent() == null;
    }

    @Override
    public boolean test(TariffStructureNode object) {
        return this.testPart(this.myPathParts, this.myPathParts.length - 1, object);
    }

    @Override
    public String getDisplayString() {
        return this.myPathString;
    }

    public String toString() {
        return this.myPathString;
    }
}

