/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.conditions.string;

import com.ericsson.charging.common.documents.RegularExpressionDocument;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.RequiresNonMapField;
import com.ericsson.ere.selectiontree.interfaces.FieldMappable;
import ericsson.ere.condition.AbstractConditionProfileV2;
import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.util.ErrorDialog;
import ericsson.ere.gui.util.GuiUtil;
import ericsson.ere.xml.XMLUtil;
import ericsson.vareditor.variable.MultilineStringVariable;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@RequiresNonMapField
public class RegularExpressionConditionProfile
extends AbstractConditionProfileV2
implements FieldMappable {
    private static String LABEL_EXPRESSION = "Expression";
    private Variable myExpressionVar;

    @Override
    public List<Variable> getVariables() {
        ArrayList<Variable> l = new ArrayList<Variable>();
        this.myExpressionVar = new MultilineStringVariable(LABEL_EXPRESSION, ".*", new RegularExpressionDocument());
        l.add(this.myExpressionVar);
        return l;
    }

    @Override
    public List<Variable> getVariables(Node iterator) {
        ArrayList<Variable> l = new ArrayList<Variable>();
        NodeList childs = iterator.getChildNodes();
        String theExpression = RegularExpressionConditionProfile.getNodeTextValue("Expression", childs);
        this.myExpressionVar = new MultilineStringVariable(LABEL_EXPRESSION, theExpression, new RegularExpressionDocument());
        l.add(this.myExpressionVar);
        return l;
    }

    @Override
    public String getDescription(List<Variable> variables) {
        String name = VarListUtil.getValueStringForName(variables, "Name");
        String expression = XMLUtil.unEscape(VarListUtil.getStringValueForName(variables, LABEL_EXPRESSION));
        return name + " matches '" + expression + "'";
    }

    private static String getNodeTextValue(String tag, NodeList theNodeList) {
        Element aNode = XMLUtil.getNamedElement(tag, theNodeList);
        if (aNode != null && aNode.hasChildNodes() && aNode.getFirstChild().getNodeType() == 3) {
            return aNode.getFirstChild().getNodeValue();
        }
        return null;
    }

    @Override
    public void printParametersImpl(PrintWriter out, int indentLevel, String indentMarker, List<Variable> variables) {
        String expression = VarListUtil.getStringValueForName(variables, LABEL_EXPRESSION);
        out.println("<Expression>" + expression + "</" + "Expression" + ">");
    }

    @Override
    public String getAdditionalInfo(List<Variable> variables) {
        String name = VarListUtil.getValueStringForName(variables, "Name");
        String expression = VarListUtil.getStringValueForName(variables, LABEL_EXPRESSION);
        String info = "<b>" + name + "</b> (Matches '" + expression + "')";
        info = info + "\n" + this.getComment(variables);
        return GuiUtil.multilineTooltipWrapper(info);
    }

    class RegularExpressionChecker
    implements ActionListener {
        RegularExpressionChecker() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String expression = RegularExpressionConditionProfile.this.myExpressionVar.getValueObject().toString();
            String result = "";
            try {
                Pattern.compile(expression);
                result = expression + " is OK ";
            }
            catch (PatternSyntaxException pse) {
                result = expression + " NOT OK \n\n" + pse.getMessage() + "\n\n" + pse.getDescription();
            }
            RmaDefs.getInstance().properties.setProperty(RmaDefs.PROP_DEBUG, "off");
            ErrorDialog dialog = new ErrorDialog("Check RegularExpression", result);
            dialog.setVisible(true);
        }
    }
}

