/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.conditions.numberseries;

import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.RequiresMapField;
import com.ericsson.ere.gui.simulator.testgenerator.TestCaseGenerationConditionInterface;
import com.ericsson.ere.selectiontree.AbstractBaseConditionProfile;
import com.ericsson.ere.selectiontree.interfaces.FieldMappable;
import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.gui.util.GuiUtil;
import ericsson.ere.xml.XMLUtil;
import ericsson.vareditor.variable.ArrayModel;
import ericsson.vareditor.variable.LongVariable;
import ericsson.vareditor.variable.StringVariable;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@RequiresMapField
public class ValueInArrayConditionProfile
extends AbstractBaseConditionProfile
implements TestCaseGenerationConditionInterface,
FieldMappable {
    protected static String LBL_VALUE = "Value";
    private FieldDefinition myFieldDefinition;

    @Override
    public List<Variable> getVariables() {
        ArrayList<Variable> l = new ArrayList<Variable>();
        l.add(this.getValueVariable("0"));
        return l;
    }

    @Override
    public List<Variable> getVariables(Node iterator) {
        ArrayList<Variable> l = new ArrayList<Variable>();
        String tagName = "Value";
        String val = "0";
        NodeList children = iterator.getChildNodes();
        for (int aa = 0; aa < children.getLength(); ++aa) {
            String k;
            if (children.item(aa).getNodeType() != 1 || !(k = children.item(aa).getNodeName()).equalsIgnoreCase(tagName = this.getTagName(k))) continue;
            NodeList value = children.item(aa).getChildNodes();
            for (int bb = 0; bb < value.getLength(); ++bb) {
                val = value.item(bb).getNodeValue();
            }
        }
        l.add(this.getValueVariable(val));
        return l;
    }

    @Override
    public String getDescription(List<Variable> variables) {
        String name = VarListUtil.getValueStringForName(variables, "Name");
        String value = VarListUtil.getValueStringForName(variables, LBL_VALUE);
        return name + " contains " + value;
    }

    @Override
    public void printParametersImpl(PrintWriter out, int indentLevel, String indentMarker, List<Variable> variables) {
        String value = VarListUtil.getValueStringForName(variables, LBL_VALUE);
        for (int i = 0; i < indentLevel + 1; ++i) {
            out.print(indentMarker);
        }
        out.println("<Value>" + value + "</" + "Value" + ">");
    }

    @Override
    public String getAdditionalInfo(List<Variable> variables) {
        String name = VarListUtil.getValueStringForName(variables, "Name");
        String value = VarListUtil.getValueStringForName(variables, LBL_VALUE).toString();
        String desc = name + " (Contains " + value + ")";
        return GuiUtil.descriptionToTooltip(desc, name, this.getComment(variables));
    }

    private String getTagName(String fieldsName) {
        String tagName = "Value";
        return tagName;
    }

    protected Variable getValueVariable(String aValue) {
        StringVariable var = this.getFieldDefinition().getTypedDataType() == DataType.STRING ? new StringVariable(LBL_VALUE, aValue) : new LongVariable(LBL_VALUE, aValue);
        return var;
    }

    public String getMaximumValue() {
        return "";
    }

    public String getMinimumValue() {
        return "";
    }

    @Override
    public List<Variable> getTestVariables(Node variableValueIterator, Node testSettingsIterator) {
        return null;
    }

    @Override
    public void printTestVariables(PrintWriter out, List<Variable> vars) {
    }

    @Override
    public Map<String, Object> getTestSimulationFieldValues(Node variableValueIterator, Node testSettingsIterator) throws Exception {
        Element numberElement = XMLUtil.getFirstElementNamed("Value", (Element)variableValueIterator);
        HashMap<String, Object> fieldInformation = new HashMap<String, Object>();
        if (numberElement != null) {
            String value = XMLUtil.getFirstTextContent(numberElement);
            DataType dataType = this.myFieldDefinition.getTypedDataType();
            ArrayModel model = new ArrayModel(new Object[]{dataType.parseValue(value)});
            model.setColumnNames(new String[]{"Index", "Value"});
            fieldInformation.put(this.myFieldDefinition.getFieldName(), model);
        }
        if (fieldInformation.size() == 0) {
            throw new Exception("Condition settings does not allow test case generation.");
        }
        return fieldInformation;
    }

    @Override
    public void setTestFieldDefinition(FieldDefinition fieldDefinition) {
        this.myFieldDefinition = fieldDefinition;
    }

    @Override
    public boolean testParameterChanged(String reference, Variable value, List<Variable> vars) {
        return false;
    }
}

