/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.conditions.numberseries;

import com.ericsson.ere.annotations.ConfigurationClass;
import com.ericsson.ere.annotations.jcip.Immutable;
import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.dataset.DataSetValueNotFoundException;
import com.ericsson.ere.selectiontree.ParseContext;
import com.ericsson.ere.selectiontree.conditions.ImmutableFieldMappableCondition;
import com.ericsson.ere.selectiontree.conditions.numberseries.NumberSeriesConditionConfiguration;
import com.ericsson.ere.selectiontree.conditions.numberseries.NumberTree;
import com.ericsson.ere.selectiontree.interfaces.ContextCondition;
import com.ericsson.ere.selectiontree.interfaces.ExecutionContext;
import com.ericsson.ere.selectiontree.interfaces.FieldKeyIndexUser;
import com.ericsson.ere.selectiontree.interfaces.TraceContext;
import com.ericsson.ere.trace.PluginTraceHelper;
import com.ericsson.ere.trace.TraceDataSet;
import com.ericsson.ere.trace.TracePoint;
import com.ericsson.ere.trace.TraceableV2;
import ericsson.ere.interfaces.TariffStructureNode;

@Immutable
@ConfigurationClass(value=NumberSeriesConditionConfiguration.class)
public final class NumberSeriesCondition
extends ImmutableFieldMappableCondition
implements FieldKeyIndexUser,
TraceableV2,
ContextCondition {
    public static final String TAG_NUMBER = "Number";
    private final NumberTree myNumbers;

    private NumberSeriesCondition(ParseContext ctx) {
        super(ctx);
        NumberSeriesConditionConfiguration conf = new NumberSeriesConditionConfiguration(ctx);
        this.myNumbers = new NumberTree(conf.getNumbers());
    }

    public static NumberSeriesCondition create(ParseContext ctx, TariffStructureNode[] notUsed) {
        return new NumberSeriesCondition(ctx);
    }

    @Override
    public boolean test(DataSet theData) {
        Object fieldValue = null;
        try {
            fieldValue = this.extractFieldValueFromDataSet(theData, this.myField);
        }
        catch (DataSetValueNotFoundException dataSetValueNotFoundException) {
            // empty catch block
        }
        return fieldValue != null && this.doTest(fieldValue);
    }

    @Override
    public boolean test(ExecutionContext exeCtx) {
        Object fieldValue = exeCtx.getValue(null);
        return this.doTest(fieldValue);
    }

    private boolean doTest(Object value) {
        boolean result = false;
        if (value != null) {
            result = this.myNumbers.checkNumber(value.toString(), 0);
        }
        return result;
    }

    @Override
    public String describeTrace(TracePoint tp) {
        TraceDataSet dataSet = TraceDataSet.createPreDataSet(tp);
        String fieldValueString = null;
        String fieldNameString = this.describeFieldName(dataSet);
        try {
            Object fieldValue = this.extractFieldValueFromDataSet(dataSet, this.myField);
            if (fieldValue != null) {
                fieldValueString = this.describeValue(fieldValue, dataSet);
            }
        }
        catch (DataSetValueNotFoundException dataSetValueNotFoundException) {
            // empty catch block
        }
        return this.doDescribeTrace(fieldNameString, fieldValueString);
    }

    @Override
    public String describeTrace(TraceContext traceCtx) {
        return this.doDescribeTrace(traceCtx.getFieldDescription(), traceCtx.getTraceValue());
    }

    private String doDescribeTrace(String selectedFieldName, String testedFieldValue) {
        return this.createTraceDescriptionText("NumberSeries", selectedFieldName, testedFieldValue, "is found", "in series");
    }

    @Override
    public void setPreTracePointInfo(TracePoint tp) {
        PluginTraceHelper.addFieldValueAsPreDataInTracePoint(this.myField, this.myKeyIndex, tp);
    }

    @Override
    public void setTracePointInfo(TracePoint tp) {
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCodeImpl();
        result = 31 * result + (this.myNumbers == null ? 0 : this.myNumbers.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !super.equalsImpl(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NumberSeriesCondition other = (NumberSeriesCondition)obj;
        return !(this.myNumbers == null ? other.myNumbers != null : !this.myNumbers.equals(other.myNumbers));
    }
}

