/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.conditions.logic;

import com.ericsson.ere.annotations.jcip.Immutable;
import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.exception.PluginCreationException;
import com.ericsson.ere.selectiontree.ParseContext;
import com.ericsson.ere.selectiontree.conditions.ImmutableFieldMappableCondition;
import com.ericsson.ere.selectiontree.conditions.logic.util.AmountField;
import com.ericsson.ere.selectiontree.conditions.logic.util.FieldFactory;
import com.ericsson.ere.selectiontree.interfaces.FieldKeyIndexUser;
import com.ericsson.ere.trace.TraceDataSet;
import com.ericsson.ere.trace.TracePoint;
import com.ericsson.ere.trace.TraceableV2;
import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.interfaces.TariffStructureNode;
import ericsson.ere.xml.XMLUtil;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@Immutable
public final class CompareAmountCondition
extends ImmutableFieldMappableCondition
implements FieldKeyIndexUser,
TraceableV2 {
    public static final String TAG_AMOUNT_CONDITION = "AmountFieldCondition";
    public static final String TAG_AMOUNT_FIELD = "AmountField";
    public static final String TAG_AMOUNT_OPERATOR = "Operator";
    public static final String TAG_AMOUNT_VALUE = "AmountValue";
    public static final String TAG_AMOUNT_FIELD2 = "AmountField2";
    public static final String[] operatorString = new String[]{"=", ">", "<", ">=", "<="};
    private final int myOperator;
    private final AmountField myField1;
    private final AmountField myField2;

    private CompareAmountCondition(ParseContext ctx, AmountField field1, AmountField field2, int operator) {
        super(ctx);
        this.myField1 = field1;
        this.myField2 = field2;
        this.myOperator = operator;
    }

    public static CompareAmountCondition create(ParseContext ctx, TariffStructureNode[] notUsed) {
        ClassRepository classRepository = ctx.getClassRepository();
        NodeList childNodes = ctx.getXMLNode().getChildNodes();
        AmountField amountField1 = CompareAmountCondition.getFirstFieldFromXML(XMLUtil.getNamedElement(TAG_AMOUNT_FIELD, childNodes), classRepository);
        int operator = CompareAmountCondition.getOperatorFromField(XMLUtil.getNamedElement(TAG_AMOUNT_OPERATOR, childNodes), amountField1);
        AmountField amountField2 = CompareAmountCondition.getSecondFieldFromXML(childNodes, classRepository);
        return new CompareAmountCondition(ctx, amountField1, amountField2, operator);
    }

    private static int getOperatorFromField(Element Node2, AmountField field) {
        String operator = XMLUtil.unEscape(XMLUtil.getFirstTextContent(Node2));
        return field.getOperatorInt(operator);
    }

    private static AmountField getFirstFieldFromXML(Element node, ClassRepository classRepository) {
        String field1 = XMLUtil.getFirstTextContent(node);
        FieldDefinition fieldDef1 = classRepository.getFieldDefinitionByName(field1);
        if (fieldDef1 == null) {
            throw new PluginCreationException("Referenced field " + field1 + " is missing");
        }
        return (AmountField)FieldFactory.initField(DataType.AMOUNT, field1, fieldDef1.usesTagNumber(), fieldDef1.getTagNumber(), null);
    }

    private static AmountField getSecondFieldFromXML(NodeList childNodes, ClassRepository classRepository) {
        AmountField amountfield;
        Element node = XMLUtil.getNamedElement(TAG_AMOUNT_FIELD2, childNodes);
        if (node != null) {
            String fieldname = XMLUtil.getFirstTextContent(node);
            FieldDefinition fieldDef2 = classRepository.getFieldDefinitionByName(fieldname);
            if (fieldDef2 == null) {
                throw new PluginCreationException("Referenced field " + fieldname + " is missing");
            }
            if (fieldDef2.getTypedDataType() != DataType.AMOUNT) {
                throw new IllegalArgumentException("Fields must be of type Amount");
            }
            amountfield = (AmountField)FieldFactory.initField(DataType.AMOUNT, fieldname, fieldDef2.usesTagNumber(), fieldDef2.getTagNumber(), null);
        } else {
            Element fieldValueNode = XMLUtil.getNamedElement(TAG_AMOUNT_VALUE, childNodes);
            String fieldValue = XMLUtil.getFirstTextContent(fieldValueNode);
            amountfield = (AmountField)FieldFactory.createFieldFor(DataType.AMOUNT, fieldValue);
        }
        return amountfield;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCodeImpl();
        result = 31 * result + (this.myField1 == null ? 0 : this.myField1.hashCode());
        result = 31 * result + (this.myField2 == null ? 0 : this.myField2.hashCode());
        result = 31 * result + this.myOperator;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass() || !super.equalsImpl(obj)) {
            return false;
        }
        CompareAmountCondition other = (CompareAmountCondition)obj;
        if (this.myField1 == null ? other.myField1 != null : !this.myField1.equals(other.myField1)) {
            return false;
        }
        if (this.myField2 == null ? other.myField2 != null : !this.myField2.equals(other.myField2)) {
            return false;
        }
        return this.myOperator == other.myOperator;
    }

    @Override
    public boolean test(DataSet theData) {
        return this.myField1.compare(this.myOperator, this.myField2, theData);
    }

    @Override
    public String describeTrace(TracePoint tp) {
        TraceDataSet dataSet = TraceDataSet.createPreDataSet(tp);
        return "CompareAmount : " + this.myField1.describeTrace(this.myOperator, this.myField2, dataSet);
    }

    @Override
    public void setPreTracePointInfo(TracePoint tp) {
        if (this.myField1 != null) {
            this.myField1.setPreTracePointInfo(tp);
        }
        if (this.myField2 != null) {
            this.myField2.setPreTracePointInfo(tp);
        }
    }

    @Override
    public void setTracePointInfo(TracePoint tp) {
    }

    @Override
    public Set<String> getUsedFields() {
        Set<String> usedFields = super.getUsedFields();
        if (this.myField1 != null) {
            usedFields.add(this.myField1.getFieldName());
        }
        if (this.myField2 != null) {
            usedFields.add(this.myField2.getFieldName());
        }
        return usedFields;
    }
}

