/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.conditions.logic;

import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.RequiresNonMapField;
import com.ericsson.ere.gui.simulator.testgenerator.TestCaseGenerationConditionInterface;
import com.ericsson.ere.selectiontree.AbstractBaseConditionProfile;
import com.ericsson.ere.selectiontree.interfaces.FieldMappable;
import com.ericsson.ere.selectiontree.util.OperatorUtil;
import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.gui.util.GuiUtil;
import ericsson.ere.xml.XMLUtil;
import ericsson.vareditor.variable.DropDownVariable;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@RequiresNonMapField
public class AmountConditionProfile
extends AbstractBaseConditionProfile
implements FieldMappable,
TestCaseGenerationConditionInterface {
    public static final String LABEL_AMOUNT_OPERATOR = "Operator";
    public static final String LABEL_AMOUNT_VALUE = "Amount value";
    private FieldDefinition myTestCaseGenFieldDefinition;

    @Override
    public List<Variable> getVariables() {
        ArrayList<Variable> l = new ArrayList<Variable>(3);
        this.addInputVariables(l, OperatorUtil.operatorString[0], null);
        return l;
    }

    private void addInputVariables(List<Variable> l, String selection, String value) {
        l.add(new DropDownVariable(LABEL_AMOUNT_OPERATOR, (Object)selection, (Object[])OperatorUtil.operatorString));
        l.add(this.createInputVariable(LABEL_AMOUNT_VALUE, null, value, DataType.AMOUNT));
    }

    @Override
    public List<Variable> getVariables(Node iterator) {
        NodeList childNodes = iterator.getChildNodes();
        Element operatorNode = XMLUtil.getNamedElement(LABEL_AMOUNT_OPERATOR, childNodes);
        String operator = XMLUtil.getFirstTextContent(operatorNode);
        String valueField = null;
        Element valueFieldNode = XMLUtil.getNamedElement("AmountValue", childNodes);
        if (valueFieldNode != null) {
            valueField = XMLUtil.getFirstTextContent(valueFieldNode);
        }
        ArrayList<Variable> l = new ArrayList<Variable>(3);
        this.addInputVariables(l, OperatorUtil.tokenToOperator(operator), valueField);
        return l;
    }

    @Override
    public void printParametersImpl(PrintWriter out, int indentLevel, String indentMarker, List<Variable> variables) {
        int i;
        String operator = VarListUtil.getValueStringForName(variables, LABEL_AMOUNT_OPERATOR);
        String value = VarListUtil.getValueStringForName(variables, LABEL_AMOUNT_VALUE);
        String operatorAsString = OperatorUtil.operatorToToken(operator);
        for (i = 0; i < indentLevel + 1; ++i) {
            out.print(indentMarker);
        }
        out.println("<Operator>" + operatorAsString + "</" + LABEL_AMOUNT_OPERATOR + ">");
        for (i = 0; i < indentLevel + 1; ++i) {
            out.print(indentMarker);
        }
        out.println("<AmountValue>" + value + "</" + "AmountValue" + ">");
    }

    @Override
    public String getAdditionalInfo(List<Variable> variables) {
        String name = VarListUtil.getValueStringForName(variables, "Name");
        String data = VarListUtil.getValueStringForName(variables, LABEL_AMOUNT_OPERATOR);
        if (data == null) {
            data = OperatorUtil.operatorString[0];
        }
        data = data + " " + VarListUtil.getVariableForName(variables, LABEL_AMOUNT_VALUE).toString();
        String info = "<b>" + name + "</b> (" + GuiUtil.replaceSubString(data, "<", "&lt;") + ")\n" + this.getComment(variables);
        return GuiUtil.multilineTooltipWrapper(info);
    }

    @Override
    public String getDescription(List<Variable> variables) {
        String name = VarListUtil.getValueStringForName(variables, "Name");
        String operator = VarListUtil.getValueStringForName(variables, LABEL_AMOUNT_OPERATOR);
        String value = VarListUtil.getVariableForName(variables, LABEL_AMOUNT_VALUE).toString();
        return name + " " + operator + " " + value;
    }

    @Override
    public void setTestFieldDefinition(FieldDefinition fieldDefinition) {
        this.myTestCaseGenFieldDefinition = fieldDefinition;
    }

    @Override
    public Map<String, Object> getTestSimulationFieldValues(Node variableValueIterator, Node testSettingsIterator) throws Exception {
        Element operatorNode = XMLUtil.getFirstElementNamed(LABEL_AMOUNT_OPERATOR, (Element)variableValueIterator);
        Element valueNode = XMLUtil.getFirstElementNamed("AmountValue", (Element)variableValueIterator);
        String fieldName = this.myTestCaseGenFieldDefinition.getFieldName();
        HashMap<String, Object> testCaseData = new HashMap<String, Object>(2);
        if (operatorNode != null && valueNode != null) {
            String operatorString = operatorNode.getTextContent();
            String valueString = valueNode.getTextContent();
            if (operatorString.equals("GT")) {
                if (!valueString.equals(this.getMaximumValue())) {
                    testCaseData.put(fieldName, this.getMaximumValue());
                }
            } else if (operatorString.equals("LT")) {
                if (!valueString.equals(this.getMaximumValue())) {
                    testCaseData.put(fieldName, this.getMinimumValue());
                }
            } else {
                testCaseData.put(fieldName, valueString);
            }
        }
        if (testCaseData.size() == 0) {
            throw new Exception("Condition settings does not allow test case generation.");
        }
        return testCaseData;
    }

    private Object getMaximumValue() {
        return "USD 9223372036854775807.00";
    }

    private Object getMinimumValue() {
        return "USD -9223372036854775807.00";
    }

    @Override
    public List<Variable> getTestVariables(Node variableValueIterator, Node testSettingsIterator) {
        return null;
    }

    @Override
    public void printTestVariables(PrintWriter out, List<Variable> vars) {
    }

    @Override
    public boolean testParameterChanged(String reference, Variable value, List<Variable> vars) {
        return false;
    }
}

