/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.conditions.datelist;

import com.ericsson.ere.annotations.jcip.Immutable;
import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.dataset.DataSetField;
import com.ericsson.ere.dataset.DataSetValueNotFoundException;
import com.ericsson.ere.datatype.EREDate;
import com.ericsson.ere.datatype.EREDateFactory;
import com.ericsson.ere.exception.PluginCreationException;
import com.ericsson.ere.selectiontree.ParseContext;
import com.ericsson.ere.selectiontree.TreeExecutionException;
import com.ericsson.ere.selectiontree.conditions.ImmutableCondition;
import com.ericsson.ere.selectiontree.conditions.ImmutableFieldMappableCondition;
import com.ericsson.ere.selectiontree.conditions.datelist.SpecialDate;
import com.ericsson.ere.selectiontree.interfaces.MillisecondDurationSupport;
import com.ericsson.ere.selectiontree.util.TreeParseUtil;
import com.ericsson.ere.trace.PluginTraceHelper;
import com.ericsson.ere.trace.TraceDataSet;
import com.ericsson.ere.trace.TracePoint;
import com.ericsson.ere.trace.TraceableV2;
import ericsson.ere.datatype.DataType;
import ericsson.ere.exception.RatingException;
import ericsson.ere.interfaces.TariffStructureNode;
import ericsson.ere.util.StringUtil;
import ericsson.ere.xml.XMLUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Immutable
public final class DateList
extends ImmutableFieldMappableCondition
implements TraceableV2,
MillisecondDurationSupport {
    public static final String TAG_DATE = "Date";
    public static final int MAX_NUMBER_OF_SPECIALDATES = 10000;
    private final List<SpecialDate> myWildcardedDates;
    private final List<SpecialDate> mySpecialDates;
    private static final long ONE_DAY_IN_SECONDS = 86400L;
    private static final long ONE_DAY_IN_MILLISECONDS = 86400000L;

    private DateList(ParseContext ctx) {
        super(ctx);
        Node config = ctx.getXMLNode();
        NodeList children = config.getChildNodes();
        Element dateNode = XMLUtil.getNamedElement(TAG_DATE, children);
        if (dateNode == null) {
            throw new PluginCreationException("Missing element: Date");
        }
        String dates = XMLUtil.getFirstTextContent(dateNode);
        if (dates.length() > 0) {
            StringTokenizer dateTokenizer = new StringTokenizer(dates, " ,\t\n\r");
            try {
                List<List<SpecialDate>> result = this.extractDatesFromToken(dateTokenizer);
                this.mySpecialDates = result.get(0);
                this.myWildcardedDates = result.get(1);
            }
            catch (RatingException ex) {
                throw new TreeExecutionException(ex);
            }
        } else {
            this.mySpecialDates = Collections.emptyList();
            this.myWildcardedDates = Collections.emptyList();
        }
    }

    @Override
    protected DataSetField createDataSetField(ParseContext ctx) {
        return this.createDataSetField(ctx, DataType.DATE);
    }

    public static ImmutableCondition create(ParseContext ctx, TariffStructureNode[] children) {
        return new DateList(ctx);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !super.equalsImpl(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DateList other = (DateList)obj;
        if (this.mySpecialDates == null ? other.mySpecialDates != null : !this.mySpecialDates.equals(other.mySpecialDates)) {
            return false;
        }
        return !(this.myWildcardedDates == null ? other.myWildcardedDates != null : !this.myWildcardedDates.equals(other.myWildcardedDates));
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCodeImpl();
        result = 31 * result + (this.mySpecialDates == null ? 0 : this.mySpecialDates.hashCode());
        result = 31 * result + (this.myWildcardedDates == null ? 0 : this.myWildcardedDates.hashCode());
        return result;
    }

    protected List<List<SpecialDate>> extractDatesFromToken(StringTokenizer tokenizer) throws RatingException {
        ArrayList<SpecialDate> specialDateList = new ArrayList<SpecialDate>();
        ArrayList<SpecialDate> wildCardDateList = new ArrayList<SpecialDate>();
        ArrayList<List<SpecialDate>> resultList = new ArrayList<List<SpecialDate>>();
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.length() <= 0) continue;
            if (token.indexOf(42) >= 0) {
                if (token.indexOf(45) >= 0) {
                    throw new RatingException(5, "Wildcard dates cannot contain ranges");
                }
                wildCardDateList.add(this.addWildcardDate(token));
                continue;
            }
            if (token.indexOf(45) >= 0) {
                specialDateList.addAll(this.addDateRange(token));
                continue;
            }
            specialDateList.add(this.addSpecialDate(token));
        }
        if (!specialDateList.isEmpty()) {
            Collections.sort(specialDateList);
        }
        if (!wildCardDateList.isEmpty()) {
            Collections.sort(wildCardDateList);
        }
        resultList.add(specialDateList);
        resultList.add(wildCardDateList);
        return resultList;
    }

    private SpecialDate addWildcardDate(String token) throws RatingException {
        byte day;
        byte month;
        short year;
        int startPos = 0;
        int endPos = 0;
        if (token.indexOf(42) == 0) {
            ++endPos;
            year = -1;
        } else {
            String yyyy = token.substring(startPos, endPos += 4);
            try {
                year = TreeParseUtil.parseShort(yyyy);
            }
            catch (NumberFormatException x) {
                throw new RatingException(5, "Failed to parse year into YYYY format. Date token: \"" + token + "\". Year part: \"" + yyyy + "\"");
            }
        }
        if (token.charAt(endPos) == '*') {
            ++endPos;
            month = -1;
        } else {
            startPos = endPos;
            String mm = token.substring(startPos, endPos += 2);
            try {
                month = TreeParseUtil.parseByte(mm);
            }
            catch (NumberFormatException x) {
                throw new RatingException(5, "Failed to parse month into MM format. Date token: \"" + token + "\". Month part: \"" + mm + "\"");
            }
        }
        if (token.charAt(endPos) == '*') {
            ++endPos;
            day = -1;
        } else {
            startPos = endPos;
            String dd = token.substring(startPos, endPos += 2);
            try {
                day = TreeParseUtil.parseByte(dd);
            }
            catch (NumberFormatException x) {
                throw new RatingException(5, "Failed to parse day into DD format. Date token: \"" + token + "\". Day part: \"" + dd + "\"");
            }
        }
        if (endPos != token.length()) {
            throw new RatingException(5, "Too many characters in token: \"" + token + "\"");
        }
        return new SpecialDate(year, month, day);
    }

    private SpecialDate addSpecialDate(String token) throws RatingException {
        byte day;
        byte month;
        short year;
        if (token.length() != 8) {
            throw new RatingException(5, "Failed to parse date token into YYYYMMDD format. Date token: \"" + token + "\".");
        }
        String yyyy = token.substring(0, 4);
        String mm = token.substring(4, 6);
        String dd = token.substring(6, 8);
        try {
            year = TreeParseUtil.parseShort(yyyy);
        }
        catch (NumberFormatException x) {
            throw new RatingException(5, "Failed to parse year into YYYY format. Date token: \"" + token + "\". Year part: \"" + yyyy + "\"");
        }
        try {
            month = TreeParseUtil.parseByte(mm);
        }
        catch (NumberFormatException x) {
            throw new RatingException(5, "Failed to parse month into MM format. Date token: \"" + token + "\". Month part: \"" + mm + "\"");
        }
        try {
            day = TreeParseUtil.parseByte(dd);
        }
        catch (NumberFormatException x) {
            throw new RatingException(5, "Failed to parse day into DD format. Date token: \"" + token + "\". Day part: \"" + dd + "\"");
        }
        return new SpecialDate(year, month, day);
    }

    private List<SpecialDate> addDateRange(String token) throws RatingException {
        SpecialDate toDate;
        SpecialDate fromDate;
        if (token.length() != 17) {
            throw new RatingException(5, "Failed to parse date range token into yyyymmdd-YYYYMMDD format. Date token: \"" + token + "\".");
        }
        String yyyy = token.substring(0, 4);
        String mm = token.substring(4, 6);
        String dd = token.substring(6, 8);
        String dash = token.substring(8, 9);
        String YYYY = token.substring(9, 13);
        String MM = token.substring(13, 15);
        String DD = token.substring(15, 17);
        if (!"-".equals(dash)) {
            throw new RatingException(5, "Failed to parse date range token into yyyymmdd-YYYYMMDD format. Date token: \"" + token + "\".");
        }
        try {
            fromDate = new SpecialDate(TreeParseUtil.parseInt(yyyy), TreeParseUtil.parseInt(mm), TreeParseUtil.parseInt(dd));
            toDate = new SpecialDate(TreeParseUtil.parseInt(YYYY), TreeParseUtil.parseInt(MM), TreeParseUtil.parseInt(DD));
        }
        catch (Exception x) {
            throw new RatingException(5, "Failed to parse date range token into yyyymmdd-YYYYMMDD format. Date token: \"" + token + "\".");
        }
        if (fromDate.compareTo(toDate) > 0) {
            throw new RatingException(5, "Invalid date range, the start date must be less than the end date. Date token: \"" + token + "\".");
        }
        ArrayList<SpecialDate> dateList = new ArrayList<SpecialDate>();
        while (!fromDate.equals(toDate)) {
            dateList.add(fromDate.clone());
            fromDate = fromDate.next();
        }
        dateList.add(toDate.clone());
        return dateList;
    }

    @Override
    public boolean test(DataSet theData) {
        boolean testResult = false;
        if (!this.mySpecialDates.isEmpty() || !this.myWildcardedDates.isEmpty()) {
            EREDate edate = null;
            if (this.useCurrentTime()) {
                edate = EREDateFactory.createFromCalendar(theData.getCurrentTime());
            } else {
                try {
                    edate = (EREDate)this.extractFieldValueFromDataSet(theData, this.myField);
                }
                catch (DataSetValueNotFoundException dataSetValueNotFoundException) {
                    // empty catch block
                }
            }
            if (edate != null) {
                SpecialDate date = new SpecialDate(edate.getFullYear(), edate.getMonthOfYear(), edate.getDayOfMonth());
                testResult = this.dateIsSpecial(date);
            }
        }
        return testResult;
    }

    private long additionalUnits(SpecialDate day, long unitsPerDay) {
        long units = 0L;
        SpecialDate nextDay = day.next();
        while (this.dateIsSpecial(nextDay)) {
            units += unitsPerDay;
            nextDay = nextDay.next();
        }
        return units;
    }

    private long getRemainingSecondsThisDay(Calendar calendar) {
        long seconds = calendar.get(11) * 3600 + calendar.get(12) * 60 + calendar.get(13);
        return 86400L - seconds;
    }

    private long getRemainingMillisecondsThisDay(Calendar calendar) {
        return this.getRemainingSecondsThisDay(calendar) * 1000L - (long)calendar.get(14);
    }

    private long calcUnsatisfied(Calendar currentTime, long remainingThisDay, long oneDayInUnits) {
        long remaining;
        block5: {
            int found;
            SpecialDate day;
            block6: {
                day = new SpecialDate(currentTime.get(1), currentTime.get(2) + 1, currentTime.get(5));
                SpecialDate last = null;
                if (this.mySpecialDates.size() > 0) {
                    last = this.mySpecialDates.get(this.mySpecialDates.size() - 1);
                }
                remaining = remainingThisDay;
                if (last != null && day.compareTo(last) <= 0 || this.wildcardListContainsLaterMatch(day)) break block6;
                remaining = Long.MAX_VALUE;
                break block5;
            }
            boolean isSpecial = this.wildcardMatch(day = day.next());
            if (isSpecial || (found = Collections.binarySearch(this.mySpecialDates, day)) >= 0) break block5;
            int nextGreaterIndex = -1 * (found + 1);
            if (nextGreaterIndex == this.mySpecialDates.size()) {
                while (!this.wildcardMatch(day)) {
                    remaining += oneDayInUnits;
                    day = day.next();
                }
            } else {
                SpecialDate nextRegular = this.mySpecialDates.get(nextGreaterIndex);
                while (!day.equals(nextRegular)) {
                    remaining += oneDayInUnits;
                    if (!this.wildcardMatch(day = day.next())) continue;
                    break;
                }
            }
        }
        return remaining;
    }

    private boolean wildcardMatch(SpecialDate date) {
        for (SpecialDate wildCarded : this.myWildcardedDates) {
            if (!wildCarded.matches(date)) continue;
            return true;
        }
        return false;
    }

    protected boolean dateIsSpecial(SpecialDate date) {
        if (this.wildcardMatch(date)) {
            return true;
        }
        int found = Collections.binarySearch(this.mySpecialDates, date);
        return found >= 0;
    }

    @Override
    public long getConditionSatisfiedDuration(DataSet theData) {
        Calendar calendar = this.extractTimeToWorkWith(theData);
        SpecialDate day = new SpecialDate(calendar.get(1), calendar.get(2) + 1, calendar.get(5));
        return this.getRemainingSecondsThisDay(calendar) + this.additionalUnits(day, 86400L);
    }

    @Override
    public long getConditionUnsatisfiedDuration(DataSet theData) {
        Calendar calendar = this.extractTimeToWorkWith(theData);
        return this.calcUnsatisfied(calendar, this.getRemainingSecondsThisDay(calendar), 86400L);
    }

    @Override
    public long getConditionSatisfiedDurationInMilliseconds(DataSet theData) {
        Calendar calendar = this.extractTimeToWorkWith(theData);
        SpecialDate day = new SpecialDate(calendar.get(1), calendar.get(2) + 1, calendar.get(5));
        return this.getRemainingMillisecondsThisDay(calendar) + this.additionalUnits(day, 86400000L);
    }

    @Override
    public long getConditionUnsatisfiedDurationInMilliseconds(DataSet theData) {
        Calendar calendar = this.extractTimeToWorkWith(theData);
        return this.calcUnsatisfied(calendar, this.getRemainingMillisecondsThisDay(calendar), 86400000L);
    }

    protected Calendar extractTimeToWorkWith(DataSet theData) {
        Calendar cal = this.useCurrentTime() ? theData.getCurrentTime() : theData.getCurrentTime();
        return cal;
    }

    @Override
    public String describeTrace(TracePoint tp) {
        String fieldName;
        TraceDataSet dataSet = TraceDataSet.createPreDataSet(tp);
        String fieldValue = null;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        if (this.useCurrentTime()) {
            fieldName = "<Current Date>";
            Calendar cal = dataSet.getCurrentTime();
            fieldValue = dateFormat.format(cal.getTime());
        } else {
            fieldName = this.describeFieldName(dataSet);
            try {
                EREDate dateToTest = (EREDate)this.extractFieldValueFromDataSet(dataSet, this.myField);
                if (dateToTest != null) {
                    String rawFieldValue = dateFormat.format(dateToTest.asDate());
                    fieldValue = this.describeValue(rawFieldValue, dataSet);
                }
            }
            catch (DataSetValueNotFoundException dataSetValueNotFoundException) {
                // empty catch block
            }
        }
        return this.createTraceDescriptionText("DateList", fieldName, fieldValue, "is found", "in list");
    }

    @Override
    public void setPreTracePointInfo(TracePoint tp) {
        if (this.useCurrentTime()) {
            PluginTraceHelper.storeCurrentTimeAsPreDataInTracePoint(tp);
        } else {
            PluginTraceHelper.addFieldValueAsPreDataInTracePoint(this.myField, this.myKeyIndex, tp);
        }
    }

    @Override
    public void setTracePointInfo(TracePoint tp) {
    }

    private boolean wildcardListContainsLaterMatch(SpecialDate day) {
        for (SpecialDate wildCarded : this.myWildcardedDates) {
            if (!wildCarded.willMatchLater(day)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<String> getUsedFields() {
        Set<String> set = super.getUsedFields();
        set.remove("BuiltInDate");
        return set;
    }

    private boolean useCurrentTime() {
        return StringUtil.isEmptyString(this.key) || this.key.equals("BuiltInDate");
    }
}

