/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.conditions.date;

import com.ericsson.ere.annotations.jcip.Immutable;
import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.dataset.DataSetField;
import com.ericsson.ere.dataset.DataSetValueNotFoundException;
import com.ericsson.ere.datatype.EREDate;
import com.ericsson.ere.datatype.EREDateFactory;
import com.ericsson.ere.datatype.EREDateUtil;
import com.ericsson.ere.exception.PluginCreationException;
import com.ericsson.ere.selectiontree.ParseContext;
import com.ericsson.ere.selectiontree.conditions.ImmutableFieldMappableCondition;
import com.ericsson.ere.selectiontree.interfaces.FieldKeyIndexUser;
import com.ericsson.ere.selectiontree.util.OperatorUtil;
import com.ericsson.ere.trace.PluginTraceHelper;
import com.ericsson.ere.trace.TraceDataSet;
import com.ericsson.ere.trace.TracePoint;
import com.ericsson.ere.trace.TraceableV2;
import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.interfaces.TariffStructureNode;
import java.text.SimpleDateFormat;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@Immutable
public final class Days
extends ImmutableFieldMappableCondition
implements FieldKeyIndexUser,
TraceableV2 {
    protected static final String BUILTINFLD_CURRENTTIME = "CurrentTime()";
    protected static final String BUILTINFLD_STARTTIME = "StartTime()";
    protected static final String TAG_PROPERTY = "Property";
    protected static final String ATTR_NAME = "name";
    protected static final String ATTR_VALUE = "value";
    protected static final String FLD_DATE_1 = "date1";
    protected static final String FLD_OPERATOR = "operator";
    protected static final String FLD_DAYS = "days";
    protected static final String[] numericOperatorArr = OperatorUtil.operatorString;
    protected static final String[] tokenOperatorArr = new String[]{"=", "GT", "LT", "GTE", "LTE"};
    private final boolean myUseStartTimeForMinuend;
    private final boolean myUseCurrentTimeForMinuend;
    private final DataSetField myMinuendField;
    private final OperatorUtil.Operator myOperator;
    private final long myDays;

    private Days(ParseContext ctx) {
        super(ctx);
        Element configNode = (Element)ctx.getXMLNode();
        if (Days.hasValueProperty(configNode, FLD_DATE_1)) {
            String minuendField = Days.getValueStringForProperty(configNode, FLD_DATE_1);
            this.myUseCurrentTimeForMinuend = BUILTINFLD_CURRENTTIME.equals(minuendField);
            this.myUseStartTimeForMinuend = BUILTINFLD_STARTTIME.equals(minuendField);
            if (!this.myUseCurrentTimeForMinuend && !this.myUseStartTimeForMinuend) {
                FieldDefinition field = ctx.getClassRepository().getFieldDefinitionByName(minuendField);
                if (field == null) {
                    throw new PluginCreationException();
                }
                this.myMinuendField = new DataSetField(field);
            } else {
                this.myMinuendField = null;
            }
        } else {
            this.myUseCurrentTimeForMinuend = false;
            this.myUseStartTimeForMinuend = false;
            this.myMinuendField = null;
        }
        if (Days.hasValueProperty(configNode, FLD_OPERATOR)) {
            String token = Days.getValueStringForProperty(configNode, FLD_OPERATOR);
            String operator = OperatorUtil.tokenToOperator(token);
            this.myOperator = OperatorUtil.getOperatorAsEnum(operator);
        } else {
            this.myOperator = null;
        }
        this.myDays = Days.hasValueProperty(configNode, FLD_DAYS) ? Days.getValueLongForProperty(configNode, FLD_DAYS) : 0L;
    }

    @Override
    protected DataSetField createDataSetField(ParseContext ctx) {
        return this.createDataSetField(ctx, DataType.DATE);
    }

    public static Days create(ParseContext ctx, TariffStructureNode[] notUsed) {
        return new Days(ctx);
    }

    protected static boolean hasValueProperty(Element root, String name) {
        return Days.getValueStringForProperty(root, name) != null;
    }

    protected static String getValueStringForProperty(Element root, String name) {
        NodeList elementsByTagName = root.getElementsByTagName(TAG_PROPERTY);
        for (int ii = 0; ii < elementsByTagName.getLength(); ++ii) {
            Element currentElement = (Element)elementsByTagName.item(ii);
            if (!currentElement.hasAttribute(ATTR_NAME) || !name.equals(currentElement.getAttribute(ATTR_NAME))) continue;
            return currentElement.getAttribute(ATTR_VALUE);
        }
        return null;
    }

    public static Long getValueLongForProperty(Element root, String name) {
        String value = Days.getValueStringForProperty(root, name);
        return value == null ? null : Long.valueOf(Long.parseLong(value));
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCodeImpl();
        result = 31 * result + (int)(this.myDays ^ this.myDays >>> 32);
        result = 31 * result + (this.myMinuendField == null ? 0 : this.myMinuendField.hashCode());
        result = 31 * result + (this.myOperator == null ? 0 : this.myOperator.hashCode());
        result = 31 * result + (this.myUseCurrentTimeForMinuend ? 1231 : 1237);
        result = 31 * result + (this.myUseStartTimeForMinuend ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass() || !super.equalsImpl(obj)) {
            return false;
        }
        Days other = (Days)obj;
        if (this.myDays != other.myDays) {
            return false;
        }
        if (this.myMinuendField == null ? other.myMinuendField != null : !this.myMinuendField.equals(other.myMinuendField)) {
            return false;
        }
        if (this.myOperator == null ? other.myOperator != null : !this.myOperator.equals((Object)other.myOperator)) {
            return false;
        }
        if (this.myUseCurrentTimeForMinuend != other.myUseCurrentTimeForMinuend) {
            return false;
        }
        return this.myUseStartTimeForMinuend == other.myUseStartTimeForMinuend;
    }

    @Override
    public boolean test(DataSet theData) {
        boolean testResult = false;
        EREDate subtrahendDays = this.getSubtrahendDate(theData);
        EREDate minuendDays = this.getMinuendDate(theData);
        if (minuendDays != null && subtrahendDays != null) {
            EREDateUtil.EREDatesDiff diff = EREDateUtil.calculateEREDateDifference(minuendDays, subtrahendDays);
            switch (this.myOperator) {
                case GT: {
                    testResult = diff.isPositiveInfinity() || diff.hasDifference() && diff.getDifference() > this.myDays;
                    break;
                }
                case GTE: {
                    testResult = diff.isPositiveInfinity() || diff.hasDifference() && diff.getDifference() >= this.myDays;
                    break;
                }
                case LT: {
                    testResult = diff.isNegativeInfinity() || diff.hasDifference() && diff.getDifference() < this.myDays;
                    break;
                }
                case LTE: {
                    testResult = diff.isNegativeInfinity() || diff.hasDifference() && diff.getDifference() <= this.myDays;
                    break;
                }
                case EQ: {
                    testResult = diff.hasDifference() ? diff.getDifference() == this.myDays : false;
                }
            }
        }
        return testResult;
    }

    private EREDate getSubtrahendDate(DataSet theData) {
        EREDate date = null;
        try {
            date = EREDateUtil.convertToEREDate(this.extractFieldValueFromDataSet(theData, this.myField));
        }
        catch (DataSetValueNotFoundException dataSetValueNotFoundException) {
            // empty catch block
        }
        return date;
    }

    private EREDate getMinuendDate(DataSet theData) {
        EREDate minuendDate = this.myUseCurrentTimeForMinuend ? EREDateFactory.createFromCalendar(theData.getCurrentTime()) : (this.myUseStartTimeForMinuend ? EREDateFactory.createFromCalendar(theData.getStartTime()) : this.getMinuendValueFromDataSet(theData));
        return minuendDate;
    }

    private EREDate getMinuendValueFromDataSet(DataSet dataset) {
        EREDate date = null;
        if (this.myMinuendField != null) {
            try {
                date = (EREDate)this.myMinuendField.getValueFromDataSet(dataset);
            }
            catch (DataSetValueNotFoundException dataSetValueNotFoundException) {
                // empty catch block
            }
        }
        return date;
    }

    @Override
    public String describeTrace(TracePoint tp) {
        TraceDataSet preDataSet = TraceDataSet.createPreDataSet(tp);
        EREDate minuendDate = this.getMinuendDate(preDataSet);
        EREDate subtrahendDate = this.getSubtrahendDate(preDataSet);
        return this.generateTraceDescription(this.getMinuendName(), Days.printDateObject(minuendDate, preDataSet, this.getMinuendName()), this.describeFieldName(preDataSet), Days.printDateObject(subtrahendDate, preDataSet, this.key));
    }

    private String generateTraceDescription(String minuendFieldName, String minuendFieldValue, String subtrahendFieldName, String subtrahendFieldValue) {
        StringBuilder buf = new StringBuilder();
        buf.append(subtrahendFieldName).append("(").append(subtrahendFieldValue).append(") ");
        buf.append(OperatorUtil.operatorString[this.myOperator.ordinal()]).append(' ').append(this.myDays).append(" day(s)\n");
        return this.createTraceDescriptionText("Days", minuendFieldName, minuendFieldValue, "-", buf.toString());
    }

    private String getMinuendName() {
        if (this.myUseCurrentTimeForMinuend) {
            return BUILTINFLD_CURRENTTIME;
        }
        if (this.myUseStartTimeForMinuend) {
            return BUILTINFLD_STARTTIME;
        }
        return this.myMinuendField.getFieldName();
    }

    private static String printDateObject(EREDate daysSinceEpoch, DataSet theData, String fieldName) {
        String formattedDate;
        if (daysSinceEpoch == null) {
            formattedDate = "[VALUE NOT FOUND]";
        } else if (EREDateUtil.isBoundaryDate(daysSinceEpoch)) {
            FieldDefinition fd = Days.getClassRepository(theData).getFieldDefinitionByName(fieldName);
            formattedDate = EREDateUtil.getDisplayableStringForEREDateConstant(daysSinceEpoch, fd);
        } else {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            formattedDate = sdf.format(daysSinceEpoch.asDate());
        }
        return formattedDate;
    }

    @Override
    public void setPreTracePointInfo(TracePoint tp) {
        PluginTraceHelper.addFieldValueAsPreDataInTracePoint(this.myField, this.myKeyIndex, tp);
        if (this.myUseCurrentTimeForMinuend) {
            PluginTraceHelper.storeCurrentTimeAsPreDataInTracePoint(tp);
        } else if (this.myMinuendField != null) {
            PluginTraceHelper.addFieldValueAsPreDataInTracePoint(this.myMinuendField, null, tp);
        }
    }

    @Override
    public void setTracePointInfo(TracePoint tp) {
    }

    @Override
    public Set<String> getUsedFields() {
        Set<String> set = super.getUsedFields();
        if (this.myMinuendField != null) {
            set.add(this.myMinuendField.getFieldName());
        }
        return set;
    }
}

