/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.conditions.bit;

import com.ericsson.ere.gui.simulator.testgenerator.TestCaseGenerationConditionInterface;
import com.ericsson.ere.gui.simulator.testgenerator.TestCaseGenerationDefs;
import com.ericsson.ere.selectiontree.AbstractBaseConditionProfile;
import com.ericsson.ere.selectiontree.interfaces.FieldMappable;
import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.gui.util.GuiUtil;
import ericsson.ere.xml.XMLUtil;
import ericsson.vareditor.variable.BitPatternVariable;
import ericsson.vareditor.variable.DropDownVariable;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;
import ericsson.vareditor.variable.bitpatternutils.BitPatternEditMenu;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractBitPatternConditionProfile
extends AbstractBaseConditionProfile
implements FieldMappable,
TestCaseGenerationConditionInterface {
    protected static final String LBL_VALUE = "Value";
    protected static final String LBL_BIT_PATTERN = "Bit pattern";
    protected static final String TAG_VALUE = "Value";
    protected static final String TAG_DATATYPE = "DataType";
    protected BitPatternEditMenu myPopupMenu;
    private final DataType myDefaultDataType;
    private FieldDefinition myFieldDef;

    protected AbstractBitPatternConditionProfile(DataType aDataType) {
        this.myDefaultDataType = aDataType;
    }

    @Override
    public List<Variable> getVariables() {
        ArrayList<Variable> variables = new ArrayList<Variable>();
        BitPatternVariable bitPattern = new BitPatternVariable(LBL_BIT_PATTERN, "0", this.getDataTypeForConnectedField());
        variables.add(bitPattern);
        return variables;
    }

    @Override
    public List<Variable> getVariables(Node node) {
        ArrayList<Variable> variables = new ArrayList<Variable>();
        NodeList child = node.getChildNodes();
        String value = XMLUtil.getFirstTextContent(XMLUtil.getNamedElement("Value", child));
        BitPatternVariable bitPattern = new BitPatternVariable(LBL_BIT_PATTERN, value, this.getDataTypeForConnectedField());
        variables.add(bitPattern);
        return variables;
    }

    @Override
    public void printParametersImpl(PrintWriter out, int indentLevel, String indentMarker, List<Variable> variables) {
        String bitPatternValue = VarListUtil.getStringValueForName(variables, LBL_BIT_PATTERN);
        out.println("<Value>" + bitPatternValue + "</" + "Value" + "><" + TAG_DATATYPE + ">" + this.getDataTypeForConnectedField().getTypeName() + "</" + TAG_DATATYPE + ">");
    }

    @Override
    public String getDescription(List<Variable> variables) {
        return this.getDescriptionText(variables, 15);
    }

    @Override
    public String getAdditionalInfo(List<Variable> variables) {
        String desc = this.getDescriptionText(variables, 100);
        return GuiUtil.descriptionToTooltip(desc, this.getName(), this.getComment(variables));
    }

    private String getDescriptionText(List<Variable> variables, int length) {
        String profileLabel = VarListUtil.getValueStringForName(variables, "Name");
        String bitValueString = ((BitPatternVariable)VarListUtil.getVariableForName(variables, LBL_BIT_PATTERN)).getDisplayableValueString();
        StringBuilder resultStringBitValues = new StringBuilder(" = ");
        StringTokenizer s = new StringTokenizer(bitValueString, ",", false);
        while (s.hasMoreTokens()) {
            if (resultStringBitValues.length() < length) {
                resultStringBitValues.append(s.nextToken());
                if (!s.hasMoreTokens()) continue;
                resultStringBitValues.append(", ");
                continue;
            }
            resultStringBitValues.append("...");
            break;
        }
        return resultStringBitValues.insert(0, profileLabel).toString();
    }

    private DataType getDataTypeForConnectedField() {
        FieldDefinition fd = this.getFieldDefinition();
        return fd != null ? fd.getTypedDataType() : this.myDefaultDataType;
    }

    @Override
    public List<Variable> getTestVariables(Node variableValueIterator, Node testSettingsIterator) {
        Element settingElement = XMLUtil.getFirstElementNamed("Settings", (Element)testSettingsIterator);
        String defaultString = "Single case";
        if (settingElement != null) {
            defaultString = XMLUtil.getFirstTextContent(settingElement);
        }
        DropDownVariable testSettingsDD = new DropDownVariable("Cases", (Object)defaultString, (Object[])new String[]{"Single case", "Single values and boundaries", "All cases"});
        ArrayList<Variable> l = new ArrayList<Variable>(2);
        l.add(testSettingsDD);
        return l;
    }

    @Override
    public void printTestVariables(PrintWriter out, List<Variable> vars) {
        out.print("<TestSettings>");
        out.print("<Settings>" + vars.get(0).getValueString() + "</Settings>");
        out.print("</TestSettings>");
    }

    @Override
    public Map<String, Object> getTestSimulationFieldValues(Node variableValueIterator, Node testSettingsIterator) throws Exception {
        Element valueElement = XMLUtil.getFirstElementNamed("Value", (Element)variableValueIterator);
        Element settingsElement = XMLUtil.getFirstElementNamed("Settings", (Element)testSettingsIterator);
        ArrayList<String> testList = new ArrayList<String>();
        if (settingsElement != null && valueElement != null) {
            String valueString = XMLUtil.getFirstTextContent(valueElement);
            String settingsString = XMLUtil.getFirstTextContent(settingsElement);
            StringTokenizer tokenizer = new StringTokenizer(valueString, ",");
            while (tokenizer.hasMoreTokens()) {
                if (settingsString.equals("Single case")) {
                    ArrayList<String> tempList = AbstractBitPatternConditionProfile.extractTestValues(tokenizer.nextToken(), settingsString, this.myFieldDef.getTypedDataType().getTypeName());
                    if (tempList.size() <= 0) continue;
                    testList.add(tempList.get(0));
                    break;
                }
                testList.addAll(AbstractBitPatternConditionProfile.extractTestValues(tokenizer.nextToken(), settingsString, this.myFieldDef.getTypedDataType().getTypeName()));
            }
            if (testList.size() == 0) {
                throw new Exception("Condition settings does not allow test case generation.");
            }
        }
        HashMap<String, Object> fieldInformation = new HashMap<String, Object>();
        fieldInformation.put(this.myFieldDef.getFieldName(), testList.toArray());
        return fieldInformation;
    }

    @Override
    public boolean testParameterChanged(String reference, Variable value, List<Variable> vars) {
        return false;
    }

    @Override
    public void setTestFieldDefinition(FieldDefinition fieldDefinition) {
        this.myFieldDef = fieldDefinition;
    }

    public static ArrayList<String> extractTestValues(String token, String settingsString, String dataType) {
        ArrayList<String> testList = new ArrayList<String>();
        if (token.length() > 0) {
            if (token.contains("-")) {
                StringTokenizer tokenizer2 = new StringTokenizer(token, "-");
                String fromString = tokenizer2.nextToken();
                String toString = tokenizer2.nextToken();
                if (settingsString.equals("All cases")) {
                    BigInteger from = new BigInteger(fromString);
                    BigInteger to = new BigInteger(toString);
                    while (from.compareTo(to) <= 0) {
                        testList.add(TestCaseGenerationDefs.convertValueToDataType(from, dataType));
                        from = from.add(BigInteger.ONE);
                    }
                } else {
                    testList.add(TestCaseGenerationDefs.convertValueToDataType(new BigInteger(fromString), dataType));
                    testList.add(TestCaseGenerationDefs.convertValueToDataType(new BigInteger(toString), dataType));
                }
            } else if (token.contains(";")) {
                StringTokenizer tokenizer2 = new StringTokenizer(token, ";");
                String valueS = tokenizer2.nextToken();
                BigInteger value = new BigInteger(valueS);
                String maskS = tokenizer2.nextToken();
                BigInteger mask = new BigInteger(maskS);
                BigInteger singleValue = value.and(mask);
                testList.add(TestCaseGenerationDefs.convertValueToDataType(singleValue, dataType));
            } else {
                testList.add(TestCaseGenerationDefs.convertValueToDataType(new BigInteger(token), dataType));
            }
        }
        return testList;
    }
}

