/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.proxy.util;

import com.ericsson.ere.proxy.AbstractEreProxy;
import com.ericsson.ere.proxy.RatingPeriodProxy;
import com.ericsson.ere.proxy.RatingPlanProxy;
import com.ericsson.ere.proxy.ServiceListProxy;
import com.ericsson.ere.proxy.ServiceProviderListProxy;
import com.ericsson.ere.proxy.ServiceProviderProxy;
import com.ericsson.ere.proxy.ServiceProxy;
import com.ericsson.ere.util.TypedKey;
import ericsson.ere.integration.connector.EreCommunicationException;
import ericsson.ere.integration.connector.http.RemotePropertyHandler;

public class ProxyUtil {
    public static ServiceListProxy getServiceListProxy(AbstractEreProxy proxy) {
        return proxy.getRatingManagerProxy().getServiceListProxy();
    }

    public static ServiceProxy getServiceProxy(AbstractEreProxy proxy) {
        if (proxy instanceof RatingPeriodProxy) {
            return ProxyUtil.getServiceListProxy(proxy).getServiceProxy(((RatingPeriodProxy)proxy).getServiceName());
        }
        if (proxy instanceof RatingPlanProxy) {
            return ProxyUtil.getServiceListProxy(proxy).getServiceProxy(((RatingPlanProxy)proxy).getServiceName());
        }
        throw new IllegalArgumentException();
    }

    public static ServiceProviderListProxy getServiceProviderListProxy(AbstractEreProxy proxy) {
        return proxy.getRatingManagerProxy().getServiceProviderListProxy();
    }

    public static ServiceProviderProxy getServiceProviderProxy(AbstractEreProxy proxy) {
        if (proxy instanceof RatingPeriodProxy) {
            return ProxyUtil.getServiceProviderListProxy(proxy).getServiceProvider(((RatingPeriodProxy)proxy).getServiceProviderName());
        }
        if (proxy instanceof RatingPlanProxy) {
            return ((RatingPlanProxy)proxy).getServiceProviderProxy();
        }
        throw new IllegalArgumentException();
    }

    public static RatingPlanProxy getRatingPlanProxy(RatingPeriodProxy proxy) {
        return ProxyUtil.getServiceProviderListProxy(proxy).getServiceProvider(proxy.getServiceProviderName()).getRatingPlanProxy(proxy.getRatingPlanName());
    }

    public static String getPropertyFromConnector(Object connector, TypedKey key) throws EreCommunicationException {
        String ret = null;
        if (connector instanceof RemotePropertyHandler) {
            ret = ProxyUtil.getPropertyFromConnector((RemotePropertyHandler)connector, key);
        }
        return ret;
    }

    public static String[] getPropertiesFromConnector(Object connector, TypedKey ... keys) throws EreCommunicationException {
        String[] ret = null;
        if (connector instanceof RemotePropertyHandler) {
            ret = ProxyUtil.getPropertiesFromConnector((RemotePropertyHandler)connector, keys);
        }
        return ret;
    }

    public static String getPropertyFromConnector(RemotePropertyHandler handler, TypedKey key) throws EreCommunicationException {
        String[] values = ProxyUtil.getPropertiesFromConnector(handler, key);
        return values != null ? values[0] : null;
    }

    public static String[] getPropertiesFromConnector(RemotePropertyHandler handler, TypedKey ... keys) throws EreCommunicationException {
        String[] properties = null;
        if (keys.length < 1) {
            throw new IllegalArgumentException("Zero length keys, must have at least one defined key in order to fetch a property.");
        }
        properties = keys.length == 1 ? new String[]{handler.getRemoteProperty(keys[0])} : handler.getRemoteProperties(keys);
        return properties;
    }
}

