/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.proxy;

import com.ericsson.ere.proxy.AbstractEreProxy;
import com.ericsson.ere.proxy.EreProxyManager;
import com.ericsson.ere.proxy.ProgressWrapper;
import com.ericsson.ere.proxy.RatingManagerProxy;
import com.ericsson.ere.proxy.RatingPlanProxy;
import com.ericsson.ere.proxy.ServiceProviderListProxy;
import com.ericsson.ere.proxy.event.ProxyStructureEvent;
import ericsson.ere.gui.GuiServiceCenter;
import ericsson.ere.gui.propertieseditor.PropertiesException;
import ericsson.ere.gui.util.DialogFactory;
import ericsson.ere.integration.connector.AbstractConnector;
import ericsson.ere.integration.connector.ChargingConnector;
import ericsson.ere.integration.connector.EreCommunicationException;
import ericsson.ere.integration.proxy.RatingPlanAndPeriodProxy;
import ericsson.ere.integration.settingsmap.SettingsMap;
import ericsson.ere.util.NodeListIterable;
import ericsson.ere.xml.XMLUtil;
import java.util.List;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ServiceProviderProxy
extends AbstractEreProxy {
    transient Vector<RatingPlanProxy> ratingPlanList = new Vector();
    private transient ServiceProviderListProxy parentProxy = null;

    public ServiceProviderProxy(AbstractConnector connector, ServiceProviderListProxy parentProxy, String serviceName) {
        this.connector = connector;
        this.parentProxy = parentProxy;
        this.setName(serviceName);
        this.myURI = this.buildURI(AbstractEreProxy.URIScheme.SERVICEPROVIDER);
        if (this.getAbortRefresh()) {
            return;
        }
        this.refresh();
    }

    @Override
    public void refresh() {
        String savedName = this.getName();
        this.myEreSettings = new SettingsMap();
        this.ratingPlanList.clear();
        this.setName(savedName);
        try {
            List<String> ratingPlanNameList = this.connector.getRatingPlanNameList(savedName);
            ProgressWrapper[] progressArray = EreProxyManager.getInstance().getProgressWrapper().splitProgress(ratingPlanNameList.size());
            for (String ratingPlanName : ratingPlanNameList) {
                EreProxyManager.getInstance().setProgressWrapper(progressArray[ratingPlanNameList.indexOf(ratingPlanName)]);
                progressArray[ratingPlanNameList.indexOf(ratingPlanName)].progressStart();
                this.ratingPlanList.add(this.connector.getProxyFactory().createRatingPlanProxy(this.connector, this, ratingPlanName));
                progressArray[ratingPlanNameList.indexOf(ratingPlanName)].progressFinished();
            }
        }
        catch (EreCommunicationException ex) {
            ex.printStackTrace(System.err);
        }
    }

    private void updateProperties(SettingsMap newPropertyMap) throws PropertiesException {
        try {
            this.connector.updateServiceProvider(this, newPropertyMap);
            this.myEreSettings.update(newPropertyMap);
        }
        catch (Exception e) {
            throw new PropertiesException(e.getMessage(), e);
        }
    }

    public Vector<RatingPlanProxy> getRatingPlanList() {
        return this.ratingPlanList;
    }

    public RatingPlanProxy getRatingPlanProxy(String name) {
        for (RatingPlanProxy tProxy : this.ratingPlanList) {
            if (!tProxy.getName().equalsIgnoreCase(name)) continue;
            return tProxy;
        }
        return null;
    }

    public Object getProperty(String propertyName) {
        return this.connector.getProperty(propertyName);
    }

    private void modify(SettingsMap model) throws PropertiesException {
        try {
            this.connector.updateServiceProvider(this, model);
        }
        catch (Exception e) {
            throw new PropertiesException(e.getMessage(), e);
        }
    }

    public void deleteRatingPlan(RatingPlanProxy someRatingPlanProxy) {
        try {
            this.connector.removeRatingPlan(someRatingPlanProxy);
            this.getEreProxy().refreshRatingManagerDocument();
            this.refresh();
            this.getEreProxy().fireProxyStructureEvent(new ProxyStructureEvent(this));
        }
        catch (Exception e) {
            String msg = "Could not delete the selected Rating plan\nReason:" + e.getMessage();
            DialogFactory.getInformationDialog(GuiServiceCenter.getInstance().getMainWindow(), "Problem deleting RatingPlan ", msg);
        }
    }

    public RatingPlanProxy createRatingPlan(Element ratingPlanElement) throws EreCommunicationException {
        String ratingPlanName = ratingPlanElement.getAttribute("Name");
        String ratingPlanService = ratingPlanElement.getAttribute("Service");
        SettingsMap properties = new SettingsMap();
        properties.setParameter("Name", ratingPlanName);
        properties.setParameter("Service", ratingPlanService);
        return this.createRatingPlan(properties, ratingPlanElement);
    }

    public RatingPlanProxy createRatingPlan(SettingsMap properties) throws EreCommunicationException {
        return this.createRatingPlan(properties, null);
    }

    public boolean hasRatingPlanAndPeriodProxy() {
        return this.connector instanceof ChargingConnector;
    }

    public RatingPlanProxy createRatingPlanAndPeriod(Element ratingPlanElement) throws EreCommunicationException {
        if (!(this.connector instanceof ChargingConnector)) {
            throw new IllegalStateException("Connector must be an instance of ChargingConnector");
        }
        NodeList periods = ratingPlanElement.getElementsByTagName("RatingPeriod");
        if (periods.getLength() == 0) {
            throw new IllegalArgumentException("No rating period found in XML.");
        }
        String ratingPlanName = ratingPlanElement.getAttribute("Name");
        String serviceName = ratingPlanElement.getAttribute("Service");
        if (ratingPlanName == null || ratingPlanName.equals("")) {
            throw new IllegalArgumentException("The RatingPlan name can not be deduced.");
        }
        RatingPlanAndPeriodProxy p = ((ChargingConnector)((Object)this.connector)).getSpecialProxy(this);
        NodeListIterable iterable = new NodeListIterable(periods);
        for (Node currentNode : iterable) {
            Element currentElement = (Element)currentNode;
            SettingsMap properties = this.createSettingsMapFromPeriodElement(ratingPlanName, serviceName, currentElement);
            Element tariff = XMLUtil.getFirstElementNamed("TariffStructure", currentElement);
            p.createRatingPlanAndPeriod(properties, tariff);
        }
        this.getEreProxy().refreshRatingManagerDocument();
        this.refresh();
        this.getEreProxy().fireProxyStructureEvent(new ProxyStructureEvent(this));
        return this.getRatingPlanProxy(ratingPlanName);
    }

    private SettingsMap createSettingsMapFromPeriodElement(String ratingPlanName, String ratingPlanService, Element period) {
        String ratingPeriodName = period.getAttribute("Name");
        String periodFile = period.getAttribute("TariffStructureFile");
        String startDate = period.getAttribute("StartDate");
        SettingsMap properties = new SettingsMap();
        properties.setParameter("Ratingplan", ratingPlanName);
        properties.setParameter("Service", ratingPlanService);
        properties.setParameter("Name", ratingPeriodName);
        properties.setParameter("RatingperiodFile", periodFile);
        properties.setParameter("Start date", startDate);
        return properties;
    }

    public RatingPlanProxy createRatingPlan(SettingsMap properties, Element ratingPlanElement) throws EreCommunicationException {
        if (this.hasRatingPlanAndPeriodProxy()) {
            throw new IllegalStateException("Connector cannot be an instance of ChargingConnector");
        }
        this.connector.createRatingPlan(this, properties);
        this.getEreProxy().refreshRatingManagerDocument();
        this.refresh();
        this.getEreProxy().fireProxyStructureEvent(new ProxyStructureEvent(this));
        return this.getRatingPlanProxy(properties.getParameterAsString("Name"));
    }

    @Deprecated
    public String getServiceProviderName() {
        return this.getName();
    }

    public boolean ratingPlanExists(String ratingPlanName) {
        return this.getRatingPlanProxy(ratingPlanName) != null;
    }

    @Override
    protected AbstractEreProxy getAbstractParentProxy() {
        return this.parentProxy;
    }

    @Override
    public RatingManagerProxy getRatingManagerProxy() {
        return this.parentProxy.getRatingManagerProxy();
    }

    @Override
    public boolean isImportableUnder(AbstractEreProxy destination) {
        return true;
    }
}

