/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.proxy;

import com.ericsson.ere.proxy.AbstractEreProxy;
import com.ericsson.ere.proxy.EreProxyManager;
import com.ericsson.ere.proxy.ProgressWrapper;
import com.ericsson.ere.proxy.RatingManagerProxy;
import com.ericsson.ere.proxy.RatingPlanProxy;
import com.ericsson.ere.proxy.SavedListProxy;
import com.ericsson.ere.proxy.ServiceProviderProxy;
import com.ericsson.ere.proxy.event.ProxyPropertyEvent;
import com.ericsson.ere.proxy.util.ProxyUtil;
import com.ericsson.ere.util.RemotePropertyDefinitions;
import com.ericsson.ere.util.TypedKey;
import ericsson.ere.datatype.Time;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.gui.GuiServiceCenter;
import ericsson.ere.gui.ratingrules.nodes.TSNode;
import ericsson.ere.gui.ratingrules.nodes.TSTariffStructure;
import ericsson.ere.gui.ratingrules.nodes.TariffDAGModel;
import ericsson.ere.gui.util.DialogFactory;
import ericsson.ere.integration.connector.AbstractConnector;
import ericsson.ere.integration.connector.EreCommunicationException;
import ericsson.ere.integration.connector.RatingRuleTreeConnector;
import ericsson.ere.integration.connector.http.RemotePropertyHandler;
import ericsson.ere.integration.settingsmap.Parameter;
import ericsson.ere.integration.settingsmap.SettingsMap;
import ericsson.ere.management.DateUtil;
import ericsson.ere.management.FieldContext;
import ericsson.ere.management.Service;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Element;

public class RatingPeriodProxy
extends AbstractEreProxy {
    private transient RatingPlanProxy myParentProxy = null;
    private transient Element myExtraInfoElement = null;
    transient boolean myIsStartTimeUsed;

    public RatingPeriodProxy(AbstractConnector connector, RatingPlanProxy parentProxy, String ratingPeriodName, String startDate) {
        this.myParentProxy = parentProxy;
        this.init(connector, ratingPeriodName, startDate);
        this.myURI = this.buildURI(AbstractEreProxy.URIScheme.PERIOD);
    }

    protected void init(AbstractConnector connector, String ratingPeriodName, String startDate) {
        this.connector = connector;
        this.setName(ratingPeriodName);
        boolean bl = this.myIsStartTimeUsed = startDate != null && !startDate.isEmpty();
        if (this.myIsStartTimeUsed) {
            this.myEreSettings.setParameter("Start date", startDate, 4, false);
        }
        if (!this.getAbortRefresh()) {
            this.refresh();
        }
    }

    String getDatePath() {
        if (this.myIsStartTimeUsed) {
            String startDate = this.myEreSettings.getParameterAsString("Start date");
            return " and @StartDate='" + startDate + "'";
        }
        return "";
    }

    @Override
    public void refresh() {
        ProgressWrapper progress = EreProxyManager.getInstance().getProgressWrapper();
        String ratingPeriodName = this.getName();
        String startDate = this.myEreSettings.getParameterAsString("Start date");
        progress.setInfo("Building rating period: " + ratingPeriodName);
        try {
            Element ratingPlanElement = null;
            String pathToRatingPeriods = "UNDEFINED";
            XPath xPath = XPathFactory.newInstance().newXPath();
            RatingPlanProxy ratingPlanProxy = this.getParentRatingPlanProxy();
            ServiceProviderProxy serviceProviderProxy = ratingPlanProxy.getServiceProviderProxy();
            ratingPlanElement = this.connector.getRatingPlanElement(serviceProviderProxy.getName(), ratingPlanProxy.getName());
            pathToRatingPeriods = this.getPathToRatingPeriods();
            Element ratingPeriodElement = (Element)xPath.evaluate(pathToRatingPeriods, ratingPlanElement, XPathConstants.NODE);
            if (this.myIsStartTimeUsed) {
                this.myEreSettings.setParameter("Start date", startDate, 4, false);
            }
            String ratingStructureFile = "";
            if (ratingPeriodElement != null) {
                ratingStructureFile = ratingPeriodElement.getAttribute("RatingStructureFile");
            }
            this.myEreSettings.setParameter("Rating Tree file", ratingStructureFile, 1, true);
            progress.progressIncrement();
        }
        catch (EreCommunicationException e) {
            e.printStackTrace(System.err);
        }
        catch (XPathExpressionException e) {
            e.printStackTrace(System.err);
        }
    }

    protected String getPathToRatingPeriods() {
        String pathToRatingPeriods = "RatingPeriod[@Name='" + this.getName() + "'" + this.getDatePath() + "]";
        return pathToRatingPeriods;
    }

    public void activateRatingPeriod() {
        try {
            String msg = "Activation is not supported by this node's connector.";
            DialogFactory.getInformationDialog(GuiServiceCenter.getInstance().getMainWindow(), "Activation request not supported", msg);
        }
        catch (Exception e) {
            String msg = "Could not activate the selected Rating period.\nCheck if not already activated\nReason:" + e.getMessage();
            DialogFactory.getInformationDialog(GuiServiceCenter.getInstance().getMainWindow(), "Problem activating Rating period", msg);
        }
    }

    public void deActivateRatingPeriod() {
        try {
            String msg = "Deactivation is not supported by this node's connector.";
            DialogFactory.getInformationDialog(GuiServiceCenter.getInstance().getMainWindow(), "DeActivation request not supported", msg);
        }
        catch (Exception e) {
            String msg = "Could not deactivate the selected Rating period.\nReason:" + e.getMessage();
            DialogFactory.getInformationDialog(GuiServiceCenter.getInstance().getMainWindow(), "Problem deactivating Rating period", msg);
        }
    }

    public static void createFileRef(SettingsMap navigatorNodeData) {
        String ratingPeriodName = navigatorNodeData.getParameterAsString("Name");
        String ratingPlanName = navigatorNodeData.getParameterAsString("Ratingplan");
        String serviceProviderName = navigatorNodeData.getParameterAsString("Service provider");
        String fileRef = RatingPeriodProxy.fixDirName(serviceProviderName) + "/" + RatingPeriodProxy.fixDirName(ratingPlanName) + "/" + RatingPeriodProxy.fixFileName(ratingPeriodName);
        navigatorNodeData.setParameter("Selection Tree file", fileRef);
    }

    private static String fixDirName(String str) {
        return str.replace(' ', '_');
    }

    private static String fixFileName(String str) {
        return str.replace(' ', '_');
    }

    public static Element createNewRatingPeriodXML(Service service, String ratingPeriodName, String ratingPlanName, String serviceProviderName) throws Exception {
        try {
            ClassRepository rep = service.getClassRepository(new FieldContext(serviceProviderName, ratingPlanName));
            TSTariffStructure ts = new TSTariffStructure(rep);
            ts.init(ratingPeriodName);
            ts.setServiceId(service.getId());
            if (rep.getNodeTypeClassName("Defs") != null) {
                TSNode defs = new TSNode(rep);
                defs.init("Definitions", "Defs");
                defs.setNodeId("defs");
                ts.addChild(defs);
            }
            ts.setTreeModel(new TariffDAGModel(null, ts));
            return (Element)ts.getUpdatedXMLConfiguration();
        }
        catch (Exception e) {
            throw new Exception("Failed to create new Selection Tree\nReason:" + e.getMessage(), e);
        }
    }

    public RatingPlanProxy getParentRatingPlanProxy() {
        return this.myParentProxy;
    }

    @Override
    public RatingManagerProxy getRatingManagerProxy() {
        return this.myParentProxy.getRatingManagerProxy();
    }

    public String getServiceName() {
        return this.getParentRatingPlanProxy().getServiceName();
    }

    public String getRatingPlanName() {
        return this.getParentRatingPlanProxy().getName();
    }

    @Deprecated
    public String getRatingPeriodName() {
        return this.getName();
    }

    public String getServiceProviderName() {
        return this.getParentRatingPlanProxy().getServiceProviderProxy().getName();
    }

    public String getRatingStructureFileRef() {
        return this.myEreSettings.getParameterAsString("Rating Tree file");
    }

    public String getId() {
        return this.connector.getId();
    }

    public Element getRatingPeriodRuleTree() throws EreCommunicationException {
        return this.connector.getRatingPeriodRuleTree(this);
    }

    public void updateRatingPeriodRuleTree(Element newRatingPeriod) throws EreCommunicationException {
        this.connector.getRatingRuleTreeConnector(this).updateRatingPlan(newRatingPeriod);
    }

    public void updateRatingPeriod(SettingsMap newSettings) throws EreCommunicationException {
        RatingRuleTreeConnector ruleTreeConnector = this.connector.getRatingRuleTreeConnector(this);
        boolean updated = false;
        if (ruleTreeConnector instanceof RemotePropertyHandler) {
            TypedKey[] keys = new TypedKey[]{RemotePropertyDefinitions.RATING_PERIOD_NAME_KEY, RemotePropertyDefinitions.RATING_PERIOD_START_TIME_KEY};
            String name = newSettings.getParameterAsString("Name");
            String startTime = newSettings.getParameterAsString("Start date");
            String[] values = new String[]{name, startTime};
            try {
                ((RemotePropertyHandler)((Object)ruleTreeConnector)).setRemoteProperties(keys, values);
                updated = true;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        if (!updated) {
            this.connector.updateRatingPeriod(this, newSettings);
        }
        this.myEreSettings.updateParametersFrom(newSettings);
        this.getEreProxy().refreshRatingManagerDocument();
        this.refresh();
        this.getEreProxy().fireProxyPropertyEvent(new ProxyPropertyEvent(this));
    }

    public Object getParentProxy() {
        return this.myParentProxy;
    }

    public String getRatingPeriodStartTime() {
        Parameter startDate = this.myEreSettings.getParameter("Start date");
        return startDate == null ? "" : startDate.getValue();
    }

    public Time getRatingPeriodTime() {
        String startTime = this.getRatingPeriodStartTime();
        return !startTime.equals("") ? new Time(startTime) : null;
    }

    @Override
    protected AbstractEreProxy getAbstractParentProxy() {
        return (AbstractEreProxy)this.getParentProxy();
    }

    public void setExtraInfoElement(Element extraInfo) {
        this.myExtraInfoElement = extraInfo;
    }

    public boolean hasExtraInfoElement() {
        return this.myExtraInfoElement != null;
    }

    public Element getExtraInfoElement() {
        return this.myExtraInfoElement;
    }

    public boolean hasActiveOrSavedParentProxy() {
        return false;
    }

    public boolean isSelectedActive() {
        return false;
    }

    @Override
    public boolean isImportableUnder(AbstractEreProxy destination) {
        String compareName = null;
        if (destination instanceof RatingPeriodProxy) {
            compareName = ((RatingPeriodProxy)destination).getServiceName();
        } else if (destination instanceof RatingPlanProxy) {
            compareName = ((RatingPlanProxy)destination).getServiceName();
        } else if (destination instanceof SavedListProxy) {
            compareName = ((SavedListProxy)destination).getServiceName();
        }
        return compareName != null && this.getServiceName().equals(compareName);
    }

    public boolean isStartTimeUsed() {
        return this.myIsStartTimeUsed;
    }

    @Override
    public String getDefaultWindowTitle() {
        String defaultTitle = "Rating Period (" + this.getServiceName() + ") - ";
        String nodeName = this.getEreProxy().getName();
        defaultTitle = nodeName.isEmpty() ? defaultTitle + this.getId() : defaultTitle + nodeName;
        defaultTitle = defaultTitle + " (" + this.getEreProxy().getType() + ")";
        defaultTitle = defaultTitle + " - " + this.getName();
        if (this.isStartTimeUsed()) {
            defaultTitle = defaultTitle + " (" + DateUtil.format(this.getRatingPeriodTime(), 2) + ")";
        }
        return defaultTitle;
    }

    public long getRemoteVersion() {
        Long version = -1L;
        try {
            RatingRuleTreeConnector periodConnector = this.connector.getRatingRuleTreeConnector(this);
            String versionString = ProxyUtil.getPropertyFromConnector(periodConnector, RemotePropertyDefinitions.RATING_PERIOD_VERSION_KEY);
            if (versionString != null) {
                version = Long.parseLong(versionString);
            }
        }
        catch (EreCommunicationException ereCommunicationException) {
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return version;
    }

    @Override
    protected String getURIPath() {
        String path = super.getURIPath();
        if (!this.getRatingPeriodStartTime().isEmpty()) {
            path = path + ":" + this.getRatingPeriodStartTime();
        }
        return path;
    }
}

