/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.naming;

import com.ericsson.ere.naming.AbstractComponentNamer;
import com.ericsson.ere.naming.DefaultSwingNamingStrategy;
import com.ericsson.ere.naming.NamingStrategy;
import java.awt.Component;
import java.awt.Container;
import javax.swing.JComponent;
import javax.swing.JViewport;

public abstract class AbstractSwingComponentNamer
extends AbstractComponentNamer {
    private static final Object NULL_NAME = new Object();
    private static final Object PROP_ORIGINAL_NAME = "original_component_name";

    protected AbstractSwingComponentNamer() {
        super(new DefaultSwingNamingStrategy());
    }

    protected AbstractSwingComponentNamer(NamingStrategy strategy) {
        super(strategy);
    }

    @Override
    public void setComponentName(Component comp, String prefix, int index) {
        Component replacement = this.getComponentSkipOverReplacement(comp);
        if (comp != replacement) {
            if (replacement != null) {
                this.setComponentName(replacement, prefix, index);
            }
            return;
        }
        String compName = this.getOriginalNameOrNameForComponent(comp);
        if (compName == null) {
            compName = this.normalizeName(this.namingStrategy().createComponentName(comp, index));
        }
        String name = prefix + "." + compName;
        this.setNameForComponent(comp, name);
        if (comp instanceof Container && this.shouldTraverseComponentChildren(comp)) {
            Container cont = (Container)comp;
            for (int i = 0; i < cont.getComponentCount(); ++i) {
                this.setComponentName(cont.getComponent(i), name, i);
            }
        }
    }

    protected abstract boolean shouldTraverseComponentChildren(Component var1);

    protected Component getComponentSkipOverReplacement(Component c) {
        Component ret = c;
        if (c instanceof JViewport) {
            ret = ((JViewport)c).getView();
        }
        return ret;
    }

    private void setNameForComponent(Component comp, String name) {
        if (comp instanceof JComponent) {
            this.setOriginalName((JComponent)comp);
        }
        comp.setName(name);
    }

    private void setOriginalName(JComponent jc) {
        if (jc.getClientProperty(PROP_ORIGINAL_NAME) == null) {
            Object originalName = jc.getName();
            if (originalName == null) {
                originalName = NULL_NAME;
            }
            jc.putClientProperty(PROP_ORIGINAL_NAME, originalName);
        }
    }

    private String getOriginalNameOrNameForComponent(Component comp) {
        String ret = null;
        if (comp != null) {
            ret = comp instanceof JComponent && this.hasOriginalName((JComponent)comp) ? this.getOriginalNameIfSet((JComponent)comp) : comp.getName();
        }
        return ret;
    }

    private boolean hasOriginalName(JComponent jc) {
        Object originalName = jc.getClientProperty(PROP_ORIGINAL_NAME);
        return originalName != null;
    }

    private String getOriginalNameIfSet(JComponent jc) {
        Object originalName = jc.getClientProperty(PROP_ORIGINAL_NAME);
        if (originalName == NULL_NAME) {
            return null;
        }
        return (String)originalName;
    }
}

