/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.mbean;

import com.ericsson.ere.mbean.ManagementSupport;
import com.ericsson.ere.mbean.ServiceProviderInfoMBean;
import ericsson.ere.management.EreManager;
import ericsson.ere.management.RatingPeriod;
import ericsson.ere.management.RatingPlan;
import ericsson.ere.management.ServiceProvider;
import java.lang.ref.WeakReference;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.ObjectName;

public class ServiceProviderInfo
implements ServiceProviderInfoMBean {
    private static AtomicInteger myInstanceNumber = new AtomicInteger(0);
    private WeakReference<EreManager> myEreManager;
    private ObjectName objectName;

    public ServiceProviderInfo(EreManager ereManager) {
        this.myEreManager = new WeakReference<EreManager>(ereManager);
        int instanceNumber = myInstanceNumber.getAndIncrement();
        this.objectName = ManagementSupport.register(this, "com.ericsson.ere.mbean", "EreManager", "ServiceProviderInfo-" + (instanceNumber == 0 ? "" : Integer.valueOf(instanceNumber)));
    }

    public void unregister() {
        ManagementSupport.unregister(this.objectName);
    }

    @Override
    public List<String> getAllRatingPeriods() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        ArrayList<String> periods = new ArrayList<String>();
        for (ServiceProvider serviceProvider : ((EreManager)this.myEreManager.get()).getAllServiceProviders()) {
            for (RatingPlan ratingPlan : serviceProvider.getAllRatingPlans()) {
                for (RatingPeriod ratingPeriod : ratingPlan.getAllRatingPeriods()) {
                    StringBuilder periodInfo = new StringBuilder();
                    periodInfo.append(ratingPeriod.getServiceProviderName());
                    periodInfo.append("/");
                    periodInfo.append(ratingPeriod.getRatingPlanId());
                    periodInfo.append("(");
                    periodInfo.append(ratingPeriod.getServiceId());
                    periodInfo.append(")/");
                    periodInfo.append(ratingPeriod.getName());
                    periodInfo.append("/");
                    periodInfo.append(ratingPeriod.getRevision());
                    periodInfo.append("/");
                    periodInfo.append(sdf.format(ratingPeriod.getStartTime().getTime()));
                    periods.add(periodInfo.toString());
                }
            }
        }
        Collections.sort(periods);
        periods.add(0, "ServiceProvider/RatingPlan Id(Service Id)/Period Name/Revision/Start Time");
        return periods;
    }

    public class ServiceProviderInfoData {
        String serviceProviderName;
        String ratingPlanId;

        public String getRatingPlanId() {
            return this.ratingPlanId;
        }

        public String getServiceProviderName() {
            return this.serviceProviderName;
        }
    }
}

