/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.io;

import java.io.Closeable;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TailReader
implements Closeable {
    private static final int BUFFERSIZE = 1024;
    private static final int LINE_BUFFER_COUNT = 20;
    private final RandomAccessFile myFile;
    private final TailContext myContext;
    private final Charset myCharset;
    private List<String> myLineBuffer = Collections.emptyList();
    private static Pattern myLFPat = Pattern.compile("\n");

    public TailReader(RandomAccessFile raf) {
        this(raf, Charset.defaultCharset());
    }

    public TailReader(RandomAccessFile raf, Charset charset) {
        this.myFile = raf;
        this.myContext = new TailContext();
        this.myCharset = charset;
    }

    public TailReader(RandomAccessFile raf, String charset) {
        this(raf, Charset.forName(charset));
    }

    public String readLine() throws IOException {
        if (this.myLineBuffer.size() == 0) {
            this.fillLineBuffer();
        }
        if (this.myLineBuffer.size() == 0) {
            return null;
        }
        return this.myLineBuffer.remove(this.myLineBuffer.size() - 1);
    }

    private void fillLineBuffer() throws IOException {
        this.myLineBuffer = TailReader.readLines(this.myFile, this.myContext, this.myCharset, 20);
    }

    private static List<String> readLines(RandomAccessFile raf, TailContext ctx, Charset charset, int count) throws IOException {
        long pos = ctx.mark;
        if (pos == Long.MAX_VALUE) {
            pos = raf.length();
        }
        if (pos == 0L) {
            return Collections.emptyList();
        }
        long linestart = TailReader.findPreviousLineStart(raf, pos, count);
        String text = TailReader.readTextBetween(raf, linestart, pos, charset);
        ctx.mark = linestart;
        return TailReader.splitText(text);
    }

    private static List<String> splitText(String text) {
        LinkedList<String> lines = new LinkedList<String>();
        Matcher m = myLFPat.matcher(text);
        int start = 0;
        while (m.find()) {
            String line = text.substring(start, m.start() + 1);
            lines.add(line);
            start = m.start() + 1;
        }
        if (start < text.length()) {
            lines.add(text.substring(start));
        }
        return lines;
    }

    private static String readTextBetween(RandomAccessFile raf, long startPos, long endPos, Charset charset) throws IOException {
        long len = endPos - startPos;
        if (len > Integer.MAX_VALUE) {
            throw new IOException("Text starting at " + startPos + " is too long (" + len + " bytes).");
        }
        byte[] buffer = new byte[(int)len];
        raf.seek(startPos);
        raf.readFully(buffer);
        String s = new String(buffer, charset.name());
        if (startPos == 0L && s.length() > 0 && s.charAt(0) == '\ufeff') {
            s = s.substring(1);
        }
        return s;
    }

    private static long findPreviousLineStart(RandomAccessFile raf, long startAt, int numLines) throws IOException {
        long pos;
        byte[] buffer = new byte[1024];
        long lastPos = startAt;
        long lfPos = -1L;
        if (numLines <= 0) {
            throw new IllegalArgumentException("Invalid line count, must be > 0.");
        }
        int nl = numLines;
        do {
            pos = 0L;
            if (lastPos - 1024L > 0L) {
                pos = lastPos - 1024L;
            }
            raf.seek(pos);
            int len = 1024;
            if (lastPos - pos < 1024L) {
                int remainder;
                len = remainder = (int)(lastPos - pos);
            }
            raf.readFully(buffer, 0, len);
            for (int i = len - 1; i >= 0; --i) {
                if (buffer[i] != 10 || startAt == lastPos && i == len - 1) continue;
                if (--nl != 0) break;
                lfPos = pos + (long)i;
                break;
            }
            lastPos = pos;
        } while (pos != 0L && lfPos < 0L);
        return lfPos + 1L;
    }

    @Override
    public void close() throws IOException {
        this.myFile.close();
    }

    private static class TailContext {
        long mark = Long.MAX_VALUE;

        private TailContext() {
        }
    }
}

