/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.wizard;

import com.ericsson.ere.gui.wizard.AbstractWizardModel;
import com.ericsson.ere.gui.wizard.WizardController;
import com.ericsson.ere.gui.wizard.panels.AbstractWizardPanel;
import com.ericsson.ere.swing.EDT;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDesktopPane;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;

public class WizardView
implements Observer {
    private WizardController myController = null;
    private Container myOwner;
    private WizardOwnerType myOwnerType;
    private Container myWindow;
    private static final long serialVersionUID = 1L;
    private JPanel myContentPane = null;
    private JPanel myMainPanel = null;
    private JPanel myTopInstructionPanel = null;
    private JPanel myMiddlePanel = null;
    private BorderLayout myMiddlePanelLayout = null;
    private JPanel myButtonPanel = null;
    private JTextArea myInstructionsArea = null;
    private JButton myBackButton = null;
    private JButton myNextButton = null;
    private JButton myCancelButton = null;
    private WizardStatus myStatus = WizardStatus.OK;

    public WizardView(JDesktopPane owner, WizardController controller, AbstractWizardModel model) {
        this.myOwner = owner;
        this.myOwnerType = WizardOwnerType.INTERNAL_FRAME;
        this.myController = controller;
        model.addObserver(this);
        this.init(model);
    }

    public WizardView(JFrame owner, WizardController controller, AbstractWizardModel model) {
        this.myOwner = owner;
        this.myOwnerType = WizardOwnerType.DIALOG;
        this.myController = controller;
        model.addObserver(this);
        this.init(model);
    }

    private void init(final AbstractWizardModel model) {
        EDT.runAndWait(new Runnable(){

            @Override
            public void run() {
                WizardView.this.myMiddlePanel = WizardView.this.createMiddlePanel((AbstractWizardPanel)((Object)model.getCurrentPanel()));
                if (WizardView.this.myOwnerType == WizardOwnerType.DIALOG) {
                    WizardView.this.myWindow = new JDialog((Frame)((JFrame)WizardView.this.myOwner), true);
                    WizardView.this.myWindow.setSize(459, 499);
                    ((JDialog)WizardView.this.myWindow).setContentPane(WizardView.this.createContentPane());
                    ((JDialog)WizardView.this.myWindow).setTitle(model.getWizardTitle());
                    ImageIcon icon = model.getWizardIcon();
                    if (icon != null) {
                        ((JDialog)WizardView.this.myWindow).setIconImage(icon.getImage());
                    }
                    ((JDialog)WizardView.this.myWindow).setLocationRelativeTo(WizardView.this.myOwner);
                    ((JDialog)WizardView.this.myWindow).setDefaultCloseOperation(2);
                } else if (WizardView.this.myOwnerType == WizardOwnerType.INTERNAL_FRAME) {
                    String title = model.getWizardTitle();
                    WizardView.this.myWindow = new JInternalFrame(title, true, true, true, true);
                    WizardView.this.myWindow.setSize(459, 499);
                    ((JInternalFrame)WizardView.this.myWindow).setTitle(title);
                    ((JInternalFrame)WizardView.this.myWindow).setFrameIcon(model.getWizardIcon());
                    ((JInternalFrame)WizardView.this.myWindow).setContentPane(WizardView.this.createContentPane());
                    ((JInternalFrame)WizardView.this.myWindow).setDefaultCloseOperation(2);
                    WizardView.this.myWindow.setName("WizardView.JInternalFrame.myWindow");
                    ((JDesktopPane)WizardView.this.myOwner).add(WizardView.this.myWindow);
                }
                WizardView.this.registerActionsForWindow();
            }
        });
        this.registerButtons();
        this.setButtonsEnablingStatus(model);
        this.myStatus = WizardStatus.OK;
    }

    public void run() {
        this.myController.startWizard();
        this.setVisible(true);
    }

    public void setSize(final int width, final int height) {
        EDT.runAndWait(new Runnable(){

            @Override
            public void run() {
                WizardView.this.myWindow.setSize(width, height);
            }
        });
    }

    private void setVisible(final boolean visible) {
        EDT.runAndWait(new Runnable(){

            @Override
            public void run() {
                WizardView.this.myWindow.setVisible(visible);
            }
        });
    }

    public void dispose() {
        EDT.runAndWait(new Runnable(){

            @Override
            public void run() {
                if (WizardView.this.myOwnerType == WizardOwnerType.INTERNAL_FRAME) {
                    ((JInternalFrame)WizardView.this.myWindow).dispose();
                } else if (WizardView.this.myOwnerType == WizardOwnerType.DIALOG) {
                    ((JDialog)WizardView.this.myWindow).dispose();
                }
            }
        });
    }

    public void cancel() {
        this.myStatus = WizardStatus.CANCEL;
    }

    public boolean isCanceled() {
        return this.myStatus == WizardStatus.CANCEL;
    }

    private JPanel createContentPane() {
        this.myContentPane = new JPanel();
        this.myContentPane.setLayout(new BorderLayout());
        this.myContentPane.add((Component)this.createMainPanel(), "Center");
        return this.myContentPane;
    }

    private JPanel createMainPanel() {
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints2.anchor = 13;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.gridy = 2;
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.weighty = 1.0;
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.fill = 1;
        gridBagConstraints1.gridy = 1;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = 0;
        this.myMainPanel = new JPanel();
        this.myMainPanel.setLayout(new GridBagLayout());
        this.myMainPanel.add((Component)this.createTopInstructionPanel(), gridBagConstraints);
        this.myMainPanel.add((Component)this.myMiddlePanel, gridBagConstraints1);
        this.myMainPanel.add((Component)this.createButtonPanel(), gridBagConstraints2);
        return this.myMainPanel;
    }

    private JPanel createTopInstructionPanel() {
        GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
        gridBagConstraints8.gridx = 0;
        gridBagConstraints8.weightx = 1.0;
        gridBagConstraints8.fill = 2;
        gridBagConstraints8.gridy = 1;
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.fill = 1;
        gridBagConstraints3.weighty = 1.0;
        gridBagConstraints3.anchor = 18;
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.insets = new Insets(22, 11, 22, 11);
        gridBagConstraints3.weightx = 1.0;
        this.myTopInstructionPanel = new JPanel();
        this.myTopInstructionPanel.setLayout(new GridBagLayout());
        this.myTopInstructionPanel.setBackground(Color.white);
        this.myTopInstructionPanel.add((Component)this.createSeparator(), gridBagConstraints8);
        this.myTopInstructionPanel.add((Component)this.createInstructionsArea(), gridBagConstraints3);
        return this.myTopInstructionPanel;
    }

    private JPanel createMiddlePanel(AbstractWizardPanel panel) {
        this.myMiddlePanelLayout = new BorderLayout();
        this.myMiddlePanel = new JPanel(this.myMiddlePanelLayout);
        this.myMiddlePanel.add((Component)panel, "Center");
        return this.myMiddlePanel;
    }

    private JPanel createButtonPanel() {
        GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
        gridBagConstraints9.gridx = 0;
        gridBagConstraints9.fill = 2;
        gridBagConstraints9.gridwidth = 4;
        gridBagConstraints9.gridy = 0;
        GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
        gridBagConstraints7.gridx = 3;
        gridBagConstraints7.insets = new Insets(17, 0, 11, 11);
        gridBagConstraints7.gridy = 1;
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.gridx = 1;
        gridBagConstraints5.insets = new Insets(17, 0, 11, 5);
        gridBagConstraints5.gridy = 1;
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 0;
        gridBagConstraints4.insets = new Insets(17, 0, 11, 5);
        gridBagConstraints4.weightx = 1.0;
        gridBagConstraints4.anchor = 13;
        gridBagConstraints4.gridy = 1;
        this.myButtonPanel = new JPanel();
        this.myButtonPanel.setLayout(new GridBagLayout());
        this.myButtonPanel.add((Component)this.createBackButton(), gridBagConstraints4);
        this.myButtonPanel.add((Component)this.createNextButton(), gridBagConstraints5);
        this.myButtonPanel.add((Component)this.createCancelButton(), gridBagConstraints7);
        this.myButtonPanel.add((Component)this.createSeparator(), gridBagConstraints9);
        return this.myButtonPanel;
    }

    private JTextArea createInstructionsArea() {
        this.myInstructionsArea = new JTextArea();
        this.myInstructionsArea.setText(((AbstractWizardPanel)this.myMiddlePanelLayout.getLayoutComponent("Center")).getPanelDescription());
        this.myInstructionsArea.setEditable(false);
        this.myInstructionsArea.setName("WizardDialog.JTextArea.instructionsArea");
        return this.myInstructionsArea;
    }

    private JButton createBackButton() {
        this.myBackButton = new JButton();
        this.myBackButton.setText("< Back");
        this.myBackButton.setName("WizardDialog.JButton.backButton");
        return this.myBackButton;
    }

    private JButton createNextButton() {
        this.myNextButton = new JButton();
        this.myNextButton.setText("Next >");
        this.myNextButton.setName("WizardDialog.JButton.nextButton");
        return this.myNextButton;
    }

    private JButton createCancelButton() {
        this.myCancelButton = new JButton();
        this.myCancelButton.setText("Cancel");
        this.myCancelButton.setName("WizardDialog.JButton.cancelAndFinishButton");
        return this.myCancelButton;
    }

    private JSeparator createSeparator() {
        return new JSeparator();
    }

    public void resetTextOnCancelButton() {
        this.setTextOnCancelButton("Cancel");
    }

    public void setTextOnCancelButton(final String text) {
        EDT.runAndWait(new Runnable(){

            @Override
            public void run() {
                WizardView.this.myCancelButton.setText(text);
            }
        });
    }

    private void registerButtons() {
        this.myNextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                WizardView.this.myController.selectNext();
            }
        });
        this.myBackButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                WizardView.this.myController.selectBack();
            }
        });
        this.myCancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                WizardView.this.myController.selectCancel();
                WizardView.this.dispose();
            }
        });
    }

    private void registerActionsForWindow() {
        AbstractAction close = this.createCloseAction();
        String actionName = (String)close.getValue("Name");
        KeyStroke key = KeyStroke.getKeyStroke(27, 0);
        if (this.myWindow instanceof JInternalFrame) {
            ((JInternalFrame)this.myWindow).getInputMap(1).put(key, actionName);
            ((JInternalFrame)this.myWindow).getActionMap().put(actionName, close);
        } else if (this.myWindow instanceof JDialog) {
            ((JDialog)this.myWindow).getRootPane().getInputMap(2).put(key, actionName);
            ((JDialog)this.myWindow).getRootPane().getActionMap().put(actionName, close);
        } else {
            throw new AssertionError((Object)"Wizards are currently only supported in JInternalFrames and JDialogs");
        }
    }

    private AbstractAction createCloseAction() {
        return new AbstractAction("close"){

            @Override
            public void actionPerformed(ActionEvent event) {
                WizardView.this.myController.selectCancel();
                WizardView.this.dispose();
            }
        };
    }

    private void showCurrentPanel(final AbstractWizardPanel panel) {
        EDT.runAndWait(new Runnable(){

            @Override
            public void run() {
                WizardView.this.myMiddlePanel.remove(WizardView.this.myMiddlePanelLayout.getLayoutComponent("Center"));
                WizardView.this.myMiddlePanel.add((Component)panel, "Center");
                WizardView.this.myMiddlePanel.revalidate();
                WizardView.this.myMiddlePanel.repaint();
                WizardView.this.myInstructionsArea.setText(panel.getPanelDescription());
            }
        });
    }

    @Override
    public void update(Observable obs, Object arg) {
        if (obs instanceof AbstractWizardModel) {
            AbstractWizardModel model = (AbstractWizardModel)obs;
            String controlButtonText = model.getControlButtonText();
            AbstractWizardPanel panel = (AbstractWizardPanel)((Object)model.getCurrentPanel());
            if (panel != null && !panel.equals(this.myMiddlePanelLayout.getLayoutComponent("Center"))) {
                this.showCurrentPanel(panel);
            }
            if (!controlButtonText.equals(this.myCancelButton.getText())) {
                this.setTextOnCancelButton(controlButtonText);
            }
            this.setButtonsEnablingStatus(model);
        }
    }

    private void setButtonsEnablingStatus(final AbstractWizardModel model) {
        EDT.runAndWait(new Runnable(){

            @Override
            public void run() {
                WizardView.this.myBackButton.setEnabled(model.isBackEnabled());
                WizardView.this.myNextButton.setEnabled(model.isNextEnabled());
                WizardView.this.myCancelButton.setEnabled(model.isControlEnabled());
            }
        });
    }

    private static enum WizardStatus {
        OK,
        CANCEL;

    }

    private static enum WizardOwnerType {
        DIALOG,
        INTERNAL_FRAME;

    }
}

